/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.advancements;

import betteradvancements.api.IBetterDisplayInfo;
import betteradvancements.util.ColorHelper;
import com.google.gson.JsonObject;
import net.minecraft.class_161;
import net.minecraft.class_2960;
import net.minecraft.class_455;

public class BetterDisplayInfo
implements IBetterDisplayInfo {
    public static final String defaultMinecraftCompletedIconColor = "#DBA213";
    public static final String defaultMinecraftUncompletedIconColor = "#FFFFFF";
    public static final String defaultMinecraftCompletedTitleColor = "#DBA213";
    public static final String defaultMinecraftUncompletedTitleColor = "#0489C1";
    private static final int minecraftCompletedIconColor = ColorHelper.RGB("#DBA213");
    private static final int minecraftUncompletedIconColor = ColorHelper.RGB("#FFFFFF");
    private static final int minecraftCompletedTitleColor = ColorHelper.RGB("#DBA213");
    private static final int minecraftUncompletedTitleColor = ColorHelper.RGB("#0489C1");
    public static int defaultCompletedIconColor = minecraftCompletedIconColor;
    public static int defaultUncompletedIconColor = minecraftUncompletedIconColor;
    public static int defaultCompletedTitleColor = minecraftCompletedTitleColor;
    public static int defaultUncompletedTitleColor = minecraftUncompletedTitleColor;
    public static boolean defaultDrawDirectLines = false;
    public static int defaultCompletedLineColor = ColorHelper.RGB("#FFFFFF");
    public static int defaultUncompletedLineColor = ColorHelper.RGB("#FFFFFF");
    public static boolean defaultHideLines = false;
    private static final int WHITE = ColorHelper.RGB(1.0f, 1.0f, 1.0f);
    private class_2960 id;
    private int completedIconColor;
    private int unCompletedIconColor;
    private int completedTitleColor;
    private int unCompletedTitleColor;
    private boolean drawDirectLines;
    private int completedLineColor;
    private int unCompletedLineColor;
    private Integer posX;
    private Integer posY;
    private boolean hideLines;
    private boolean allowDragging;

    public BetterDisplayInfo(class_161 advancement) {
        this(advancement.method_688());
        if (advancement instanceof IBetterDisplayInfo) {
            this.parseIBetterDisplayInfo((IBetterDisplayInfo)advancement);
        }
        if (advancement.method_686() instanceof IBetterDisplayInfo) {
            this.parseIBetterDisplayInfo((IBetterDisplayInfo)advancement.method_686());
        }
    }

    public BetterDisplayInfo(class_2960 id) {
        this.id = id;
        this.defaults();
    }

    public BetterDisplayInfo(class_2960 id, JsonObject displayJson) {
        this(id);
        if (displayJson != null) {
            this.parseDisplayJson(displayJson);
        }
    }

    private void defaults() {
        this.completedIconColor = defaultCompletedIconColor;
        this.completedTitleColor = defaultCompletedTitleColor;
        this.unCompletedIconColor = defaultUncompletedIconColor;
        this.unCompletedTitleColor = defaultUncompletedTitleColor;
        this.drawDirectLines = defaultDrawDirectLines;
        this.unCompletedLineColor = defaultUncompletedLineColor;
        this.completedLineColor = defaultCompletedLineColor;
        this.posX = null;
        this.posY = null;
        this.hideLines = defaultHideLines;
        this.allowDragging = false;
    }

    private void parseDisplayJson(JsonObject displayJson) {
        if (displayJson.has("completed_icon_color")) {
            this.completedIconColor = ColorHelper.RGB(displayJson.get("completed_icon_color").getAsString());
        }
        if (displayJson.has("uncompleted_icon_color")) {
            this.unCompletedIconColor = ColorHelper.RGB(displayJson.get("uncompleted_icon_color").getAsString());
        }
        if (displayJson.has("completed_title_color")) {
            this.completedTitleColor = ColorHelper.RGB(displayJson.get("completed_title_color").getAsString());
        }
        if (displayJson.has("uncompleted_title_color")) {
            this.unCompletedTitleColor = ColorHelper.RGB(displayJson.get("uncompleted_title_color").getAsString());
        }
        if (displayJson.has("draw_direct_lines")) {
            this.drawDirectLines = displayJson.get("draw_direct_lines").getAsBoolean();
        }
        if (displayJson.has("completed_line_color")) {
            this.completedLineColor = ColorHelper.RGB(displayJson.get("completed_line_color").getAsString());
        }
        if (displayJson.has("uncompleted_line_color")) {
            this.unCompletedLineColor = ColorHelper.RGB(displayJson.get("uncompleted_line_color").getAsString());
        }
        if (displayJson.has("pos_x")) {
            this.posX = displayJson.get("pos_x").getAsInt();
        }
        if (displayJson.has("pos_y")) {
            this.posY = displayJson.get("pos_y").getAsInt();
        }
        if (displayJson.has("hide_lines")) {
            this.hideLines = displayJson.get("hide_lines").getAsBoolean();
        }
    }

    private void parseIBetterDisplayInfo(IBetterDisplayInfo betterDisplayInfo) {
        if (betterDisplayInfo.getCompletedIconColor() != -1) {
            this.completedIconColor = betterDisplayInfo.getCompletedIconColor();
        }
        if (betterDisplayInfo.getUnCompletedIconColor() != -1) {
            this.unCompletedIconColor = betterDisplayInfo.getUnCompletedIconColor();
        }
        if (betterDisplayInfo.getCompletedTitleColor() != -1) {
            this.completedTitleColor = betterDisplayInfo.getCompletedTitleColor();
        }
        if (betterDisplayInfo.getUnCompletedTitleColor() != -1) {
            this.unCompletedTitleColor = betterDisplayInfo.getUnCompletedTitleColor();
        }
        if (betterDisplayInfo.drawDirectLines() != null) {
            this.drawDirectLines = betterDisplayInfo.drawDirectLines();
        }
        if (betterDisplayInfo.getCompletedLineColor() != -1) {
            this.completedLineColor = betterDisplayInfo.getCompletedLineColor();
        }
        if (betterDisplayInfo.getUnCompletedLineColor() != -1) {
            this.unCompletedLineColor = betterDisplayInfo.getUnCompletedLineColor();
        }
        if (betterDisplayInfo.getPosX() != null) {
            this.posX = betterDisplayInfo.getPosX();
        }
        if (betterDisplayInfo.getPosY() != null) {
            this.posY = betterDisplayInfo.getPosY();
        }
        if (betterDisplayInfo.hideLines() != null) {
            this.hideLines = betterDisplayInfo.hideLines();
        }
        this.allowDragging = betterDisplayInfo.allowDragging();
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public int getCompletedIconColor() {
        return this.completedIconColor;
    }

    @Override
    public int getUnCompletedIconColor() {
        return this.unCompletedIconColor;
    }

    @Override
    public int getCompletedTitleColor() {
        return this.completedTitleColor;
    }

    @Override
    public int getUnCompletedTitleColor() {
        return this.unCompletedTitleColor;
    }

    @Override
    public Boolean drawDirectLines() {
        return this.drawDirectLines;
    }

    @Override
    public int getCompletedLineColor() {
        return this.completedLineColor;
    }

    @Override
    public int getUnCompletedLineColor() {
        return this.unCompletedLineColor;
    }

    @Override
    public Integer getPosX() {
        return this.posX;
    }

    @Override
    public Integer getPosY() {
        return this.posY;
    }

    @Override
    public Boolean hideLines() {
        return this.hideLines;
    }

    @Override
    public boolean allowDragging() {
        return this.allowDragging;
    }

    public boolean hasCustomIconColor() {
        return this.completedIconColor != minecraftCompletedIconColor || this.unCompletedIconColor != minecraftUncompletedIconColor;
    }

    public boolean hasCustomTitleColor() {
        return this.completedTitleColor != minecraftCompletedTitleColor || this.unCompletedTitleColor != minecraftUncompletedTitleColor;
    }

    public int getIconYMultiplier(class_455 state) {
        if (this.hasCustomIconColor()) {
            return 2;
        }
        return state == class_455.field_2701 ? 0 : 1;
    }

    public int getIconColor(class_455 state) {
        if (!this.hasCustomIconColor()) {
            return WHITE;
        }
        return state == class_455.field_2701 ? this.getCompletedIconColor() : this.getUnCompletedIconColor();
    }

    public int getTitleYMultiplier(class_455 state) {
        if (this.hasCustomTitleColor()) {
            return 3;
        }
        return state == class_455.field_2701 ? 0 : 1;
    }

    public int getTitleColor(class_455 state) {
        if (!this.hasCustomIconColor()) {
            return WHITE;
        }
        return state == class_455.field_2701 ? this.getCompletedTitleColor() : this.getUnCompletedTitleColor();
    }
}

