/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcda.items;

import chronosacaria.mcda.Mcda;
import chronosacaria.mcda.config.ArmorStats;
import chronosacaria.mcda.items.ArmorSets;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_5250;

public class ArmorSetItem
extends class_1738 {
    protected static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    protected final Multimap<class_1320, class_1322> attributeModifiers;
    protected final ArmorSets set;

    public ArmorSetItem(ArmorSets set, class_1304 slot) {
        super((class_1741)set, slot, new class_1792.class_1793().method_7892(Mcda.ARMORS_GROUP));
        this.set = set;
        int protection = set.method_7697(slot);
        float toughness = set.method_7700();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIERS[slot.method_5927()];
        builder.put((Object)class_5134.field_23724, (Object)new class_1322(uuid, "Armor modifier", (double)protection, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23725, (Object)new class_1322(uuid, "Armor toughness", (double)toughness, class_1322.class_1323.field_6328));
        if (this.field_21976 > 0.0f) {
            builder.put((Object)class_5134.field_23718, (Object)new class_1322(uuid, "Armor knockback resistance", (double)this.field_21976, class_1322.class_1323.field_6328));
        }
        ArmorStats armorStats = Mcda.CONFIG.mcdaArmorStatsConfig.armorStats.get((Object)set);
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(uuid, "Armor attack damage boost", armorStats.attackDamageBoost, class_1322.class_1323.field_6330));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(uuid, "Armor attack speed boost", armorStats.attackSpeedBoost, class_1322.class_1323.field_6330));
        builder.put((Object)class_5134.field_23719, (Object)new class_1322(uuid, "Armor movement speed boost", armorStats.movementSpeedBoost, class_1322.class_1323.field_6330));
        this.attributeModifiers = builder.build();
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == this.field_7880 ? this.attributeModifiers : super.method_7844(slot);
    }

    public class_1814 method_7862(class_1799 itemStack) {
        return this.set.getRarity();
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        super.method_7851(itemStack, world, tooltip, tooltipContext);
        String setId = switch (this.set) {
            case ArmorSets.MYSTERY, ArmorSets.BLUE_MYSTERY, ArmorSets.GREEN_MYSTERY, ArmorSets.PURPLE_MYSTERY, ArmorSets.RED_MYSTERY -> "mystery_armor";
            default -> this.set.getSetName();
        };
        String translationKey = String.format("item.mcda.%s.tooltip_", setId);
        int i = 1;
        while (class_1074.method_4663((String)(translationKey + i))) {
            tooltip.add((class_2561)class_2561.method_43471((String)(translationKey + i)).method_27692(class_124.field_1056));
            ++i;
        }
        if (Mcda.CONFIG.mcdaArmorStatsConfig.setBonusTooltips) {
            translationKey = String.format("item.mcda.%s.effect.tooltip_", setId);
            i = 1;
            while (class_1074.method_4663((String)(translationKey + i))) {
                class_124 class_1242;
                class_5250 class_52502 = class_2561.method_43471((String)(translationKey + i));
                if (Mcda.CONFIG.mcdaArmorStatsConfig.setBonusTooltipColors) {
                    switch (this.set) {
                        case MYSTERY: {
                            class_1242 = class_124.field_1068;
                            break;
                        }
                        case BLUE_MYSTERY: 
                        case FROST: 
                        case PHANTOM: 
                        case FROST_BITE: 
                        case NIMBLE_TURTLE: 
                        case GLOW_SQUID: {
                            class_1242 = class_124.field_1062;
                            break;
                        }
                        case GREEN_MYSTERY: 
                        case HIGHLAND: 
                        case CAVE_CRAWLER: 
                        case HERO: 
                        case OPULENT: 
                        case VERDANT: {
                            class_1242 = class_124.field_1060;
                            break;
                        }
                        case PURPLE_MYSTERY: 
                        case CURIOUS: 
                        case THIEF: {
                            class_1242 = class_124.field_1076;
                            break;
                        }
                        case RED_MYSTERY: 
                        case LIVING_VINES: 
                        case SPROUT: 
                        case GHOST_KINDLER: 
                        case GOURDIAN: 
                        case BLACK_WOLF: 
                        case RENEGADE: 
                        case STALWART_MAIL: 
                        case WITHER: {
                            class_1242 = class_124.field_1061;
                            break;
                        }
                        case STURDY_SHULKER: 
                        case SPIDER: 
                        case SOULDANCER: {
                            if (i == 1) {
                                class_1242 = class_124.field_1076;
                                break;
                            }
                            class_1242 = class_124.field_1080;
                            break;
                        }
                        case SHADOW_WALKER: {
                            if (i == 1) {
                                class_1242 = class_124.field_1060;
                                break;
                            }
                            class_1242 = class_124.field_1076;
                            break;
                        }
                        case CAULDRON: 
                        case TITAN: 
                        case SPLENDID: 
                        case TROUBADOUR: {
                            class_1242 = class_124.field_1067;
                            break;
                        }
                        default: {
                            class_1242 = class_124.field_1080;
                            break;
                        }
                    }
                } else {
                    class_1242 = class_124.field_1080;
                }
                tooltip.add((class_2561)class_52502.method_27692(class_1242));
                ++i;
            }
            if (this.field_7880 == class_1304.field_6166 && (this.set == ArmorSets.RUGGED_CLIMBING_GEAR || this.set == ArmorSets.SNOW || this.set == ArmorSets.GOAT)) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.mcda.effect.lightfooted").method_27692(Mcda.CONFIG.mcdaArmorStatsConfig.setBonusTooltipColors ? class_124.field_1075 : class_124.field_1080));
            }
            if (FabricLoader.getInstance().isModLoaded("environmentz") && (this.set == ArmorSets.SNOW || this.set == ArmorSets.FROST || this.set == ArmorSets.FROST_BITE || this.set == ArmorSets.FOX || this.set == ArmorSets.ARCTIC_FOX || this.set == ArmorSets.WOLF || this.set == ArmorSets.BLACK_WOLF || this.set == ArmorSets.GOAT || this.set == ArmorSets.CLIMBING_GEAR || this.set == ArmorSets.RUGGED_CLIMBING_GEAR || this.set == ArmorSets.GHOST_KINDLER)) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.mcda.effect.freezing_protection").method_27692(Mcda.CONFIG.mcdaArmorStatsConfig.setBonusTooltipColors ? class_124.field_1054 : class_124.field_1080));
            }
        }
    }

    public ArmorSets getSet() {
        return this.set;
    }
}

