/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcda.effects;

import chronosacaria.mcda.Mcda;
import chronosacaria.mcda.api.AOEHelper;
import chronosacaria.mcda.api.BooleanHelper;
import chronosacaria.mcda.api.CleanlinessHelper;
import chronosacaria.mcda.enchants.EnchantID;
import chronosacaria.mcda.registry.EnchantsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class EnchantmentEffects {
    private static final UUID RECKLESS_UUID = UUID.fromString("c131aecf-3b88-43c9-9df3-16f791077d41");
    public static final List<class_1792> FOOD_RESERVE_LIST = List.of(class_1802.field_8279, class_1802.field_8229, class_1802.field_8509, class_1802.field_8261, class_1802.field_8347, class_1802.field_8373, class_1802.field_8373, class_1802.field_8752, class_1802.field_8544, class_1802.field_8176, class_1802.field_8497, class_1802.field_8179, class_1802.field_8071, class_1802.field_8463, class_1802.field_8512);
    public static final List<class_1799> SURPRISE_GIFT_LIST = List.of(class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8978), class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_9005), class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8997));

    protected static boolean isInstantHealthPotion(class_1799 itemStack) {
        boolean hasInstantHealth = false;
        for (class_1293 potionEffect : class_1844.method_8067((class_1799)itemStack)) {
            if (potionEffect.method_5579() != class_1294.field_5915) continue;
            hasInstantHealth = true;
            break;
        }
        return hasInstantHealth;
    }

    public static void applyFireTrail(class_1657 player, class_2338 blockPos) {
        int fireTrailLevel = class_1890.method_8203((class_1887)EnchantsRegistry.enchants.get((Object)EnchantID.FIRE_TRAIL), (class_1309)player);
        if (fireTrailLevel == 0) {
            return;
        }
        class_2338 placeFireTrail = blockPos.method_10079(player.method_5755().method_10153(), 2);
        if (player.field_6002.method_8320(placeFireTrail).method_26215() && player.method_24828() && !player.method_5715() && BooleanHelper.isFireTrailEnabled(player)) {
            player.field_6002.method_8501(placeFireTrail, class_2246.field_10036.method_9564());
        }
    }

    public static void applyFoodReserves(class_1657 playerEntity) {
        if (!EnchantmentEffects.isInstantHealthPotion(playerEntity.method_6030())) {
            return;
        }
        for (int foodReserveLevel = class_1890.method_8203((class_1887)EnchantsRegistry.enchants.get((Object)EnchantID.FOOD_RESERVES), (class_1309)playerEntity); foodReserveLevel > 0; --foodReserveLevel) {
            class_1792 foodToDrop = FOOD_RESERVE_LIST.get(playerEntity.method_6051().method_43048(FOOD_RESERVE_LIST.size()));
            class_1542 foodDrop = new class_1542(playerEntity.field_6002, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), new class_1799((class_1935)foodToDrop));
            playerEntity.field_6002.method_8649((class_1297)foodDrop);
        }
    }

    public static void applyPotionBarrier(class_1657 playerEntity) {
        if (!EnchantmentEffects.isInstantHealthPotion(playerEntity.method_6030())) {
            return;
        }
        int potionBarrierLevel = class_1890.method_8203((class_1887)EnchantsRegistry.enchants.get((Object)EnchantID.POTION_BARRIER), (class_1309)playerEntity);
        if (potionBarrierLevel == 0) {
            return;
        }
        class_1293 resistance = new class_1293(class_1294.field_5907, 60 + 20 * potionBarrierLevel, 3);
        playerEntity.method_6092(resistance);
    }

    public static void applySurpriseGift(class_1657 playerEntity) {
        if (!EnchantmentEffects.isInstantHealthPotion(playerEntity.method_6030())) {
            return;
        }
        int surpriseGiftLevel = class_1890.method_8203((class_1887)EnchantsRegistry.enchants.get((Object)EnchantID.SURPRISE_GIFT), (class_1309)playerEntity);
        if (surpriseGiftLevel == 0) {
            return;
        }
        for (int surpriseGiftChance = 50 * surpriseGiftLevel; surpriseGiftChance > 0; surpriseGiftChance -= 100) {
            if (!CleanlinessHelper.percentToOccur(surpriseGiftChance)) continue;
            class_1799 potionToDrop = SURPRISE_GIFT_LIST.get(playerEntity.method_6051().method_43048(SURPRISE_GIFT_LIST.size()));
            CleanlinessHelper.mcda$dropItem((class_1309)playerEntity, potionToDrop);
        }
    }

    public static void applyLuckyExplorer(class_1309 livingEntity) {
        class_1937 world = livingEntity.method_37908();
        if (livingEntity.method_24828() && world.method_8510() % 50L == 0L) {
            int luckyExplorerLevel = class_1890.method_8203((class_1887)EnchantsRegistry.enchants.get((Object)EnchantID.LUCKY_EXPLORER), (class_1309)livingEntity);
            if (luckyExplorerLevel == 0) {
                return;
            }
            float luckyExplorerThreshold = (float)luckyExplorerLevel * 0.1f;
            float luckyExplorerRand = livingEntity.method_6051().method_43057();
            if (luckyExplorerRand <= luckyExplorerThreshold) {
                double storedZCoord;
                class_1799 feetStack = livingEntity.method_6118(class_1304.field_6166);
                double currentXCoord = livingEntity.method_19538().method_10216();
                double currentZCoord = livingEntity.method_19538().method_10215();
                if (!feetStack.method_7948().method_10545("x-coord")) {
                    feetStack.method_7948().method_10549("x-coord", currentXCoord);
                    feetStack.method_7948().method_10549("z-coord", currentZCoord);
                    return;
                }
                double storedXCoord = feetStack.method_7948().method_10574("x-coord");
                class_243 vec3d = new class_243(storedXCoord, 0.0, storedZCoord = feetStack.method_7948().method_10574("z-coord"));
                double distanceBetween = Math.sqrt(vec3d.method_1028(currentXCoord, 0.0, currentZCoord));
                if (distanceBetween >= 100.0) {
                    CleanlinessHelper.mcda$dropItem(livingEntity, class_1802.field_8687);
                    feetStack.method_7948().method_10549("x-coord", currentXCoord);
                    feetStack.method_7948().method_10549("z-coord", currentZCoord);
                }
            }
        }
    }

    public static float applyFireFocusDamage(class_1309 target) {
        for (class_1309 nearbyEntity : AOEHelper.getAttackersOfEntities(target, 6.0f)) {
            int fireFocusLevel = class_1890.method_8203((class_1887)EnchantsRegistry.enchants.get((Object)EnchantID.FIRE_FOCUS), (class_1309)nearbyEntity);
            if (fireFocusLevel <= 0) continue;
            return 1.0f + 0.25f * (float)fireFocusLevel;
        }
        return 1.0f;
    }

    public static float applyPoisonFocusDamage(class_1309 target) {
        for (class_1309 nearbyEntity : AOEHelper.getAttackersOfEntities(target, 6.0f)) {
            int poisonFocusLevel = class_1890.method_8203((class_1887)EnchantsRegistry.enchants.get((Object)EnchantID.POISON_FOCUS), (class_1309)nearbyEntity);
            if (poisonFocusLevel <= 0) continue;
            return 1.0f + 0.25f * (float)poisonFocusLevel;
        }
        return 1.0f;
    }

    public static void applyChilling(class_1309 wearer, class_1309 livingEntity) {
        int chillingLevel = class_1890.method_8203((class_1887)EnchantsRegistry.enchants.get((Object)EnchantID.CHILLING), (class_1309)wearer);
        if (chillingLevel > 0) {
            livingEntity.method_6092(new class_1293(class_1294.field_5909, 20 * chillingLevel, chillingLevel * 2 - 1));
            livingEntity.method_6092(new class_1293(class_1294.field_5901, 20 * chillingLevel, chillingLevel * 2 - 1));
        }
    }

    public static boolean deathBarterEffect(class_1657 playerEntity) {
        int deathBarterLevel = class_1890.method_8203((class_1887)EnchantsRegistry.enchants.get((Object)EnchantID.DEATH_BARTER), (class_1309)playerEntity);
        if (deathBarterLevel > 0) {
            class_1661 playerInventory = playerEntity.method_31548();
            int emeraldTotal = 0;
            ArrayList<Integer> emeraldSlotIndices = new ArrayList<Integer>();
            for (int slotIndex = 0; slotIndex < playerInventory.method_5439(); ++slotIndex) {
                class_1799 currentStack = playerInventory.method_5438(slotIndex);
                if (currentStack.method_7909() != class_1802.field_8687) continue;
                emeraldTotal += currentStack.method_7947();
                emeraldSlotIndices.add(slotIndex);
            }
            int minEmeralds = 150 / deathBarterLevel;
            if (emeraldTotal >= minEmeralds && emeraldTotal > 0) {
                for (Integer slotIndex : emeraldSlotIndices) {
                    if (minEmeralds <= 0) break;
                    class_1799 currEmeraldsStack = playerInventory.method_5438(slotIndex.intValue());
                    int currEmeraldsCount = currEmeraldsStack.method_7947();
                    int emeraldsToTake = Math.min(minEmeralds, currEmeraldsCount);
                    currEmeraldsStack.method_7939(currEmeraldsCount - emeraldsToTake);
                    minEmeralds -= emeraldsToTake;
                }
                CleanlinessHelper.onTotemDeathEffects((class_1309)playerEntity);
                return true;
            }
        }
        return false;
    }

    public static void applyCowardice(class_3222 player) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableEnchantment.get((Object)EnchantID.COWARDICE).booleanValue()) {
            return;
        }
        if (player.method_6032() == player.method_6063()) {
            int cowardiceLevel = class_1890.method_8203((class_1887)EnchantsRegistry.enchants.get((Object)EnchantID.COWARDICE), (class_1309)player);
            if (cowardiceLevel == 0) {
                return;
            }
            class_1293 strengthBoost = new class_1293(class_1294.field_5910, 42, cowardiceLevel - 1, false, false);
            player.method_6092(strengthBoost);
        }
    }

    public static void applyFrenzied(class_3222 player) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableEnchantment.get((Object)EnchantID.FRENZIED).booleanValue()) {
            return;
        }
        if (player.method_6032() <= 0.5f * player.method_6063()) {
            int frenziedLevel = class_1890.method_8203((class_1887)EnchantsRegistry.enchants.get((Object)EnchantID.FRENZIED), (class_1309)player);
            if (frenziedLevel == 0) {
                return;
            }
            class_1293 frenzied = new class_1293(class_1294.field_5917, 40, frenziedLevel - 1, false, false);
            player.method_6092(frenzied);
        }
    }

    public static void applyReckless(class_3222 player) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableEnchantment.get((Object)EnchantID.RECKLESS).booleanValue()) {
            return;
        }
        int recklessLevel = class_1890.method_8203((class_1887)EnchantsRegistry.enchants.get((Object)EnchantID.RECKLESS), (class_1309)player);
        player.method_5996(class_5134.field_23716).method_6200(RECKLESS_UUID);
        if (recklessLevel > 0) {
            if (player.method_6127().method_27306(class_5134.field_23716)) {
                float previousMaxHealth = player.method_6063();
                player.method_5996(class_5134.field_23716).method_26835(new class_1322(RECKLESS_UUID, "reckless modifier", -0.6, class_1322.class_1323.field_6331));
                float afterMaxHealth = player.method_6063();
                if (afterMaxHealth != previousMaxHealth) {
                    player.method_6033(player.method_6032());
                }
            }
            class_1293 reckless = new class_1293(class_1294.field_5910, 40, recklessLevel - 1, false, false);
            player.method_6092(reckless);
        }
    }

    public static void applySwiftfooted(class_3222 player) {
        int swiftfootedLevel = class_1890.method_8203((class_1887)EnchantsRegistry.enchants.get((Object)EnchantID.SWIFTFOOTED), (class_1309)player);
        if (swiftfootedLevel == 0) {
            return;
        }
        class_1293 swiftfooted = new class_1293(class_1294.field_5904, 60, swiftfootedLevel - 1, false, false);
        player.method_6092(swiftfooted);
    }
}

