/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcda.api;

import chronosacaria.mcda.items.ArmorSetItem;
import chronosacaria.mcda.items.ArmorSets;
import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class CleanlinessHelper {
    static Random random = new Random();

    public static boolean checkFullArmor(class_1309 livingEntity, ArmorSets armorSets) {
        for (class_1304 slot : armorSets.getSlots()) {
            class_1792 class_17922 = livingEntity.method_6118(slot).method_7909();
            if (class_17922 instanceof ArmorSetItem) {
                ArmorSetItem armorItem = (ArmorSetItem)class_17922;
                if (armorItem.getSet().isOf(armorSets)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static void onTotemDeathEffects(class_1309 livingEntity) {
        livingEntity.method_6033(1.0f);
        livingEntity.method_6012();
        livingEntity.method_6092(new class_1293(class_1294.field_5924, 900, 1));
        livingEntity.method_6092(new class_1293(class_1294.field_5918, 900, 1));
        livingEntity.method_6092(new class_1293(class_1294.field_5898, 100, 1));
        livingEntity.field_6002.method_8421((class_1297)livingEntity, (byte)35);
    }

    public static int mcdaIndexOfLargestElementInArray(int[] arr) {
        int maxVal = arr[0];
        int index = 0;
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] <= maxVal) continue;
            maxVal = arr[i];
            index = i;
        }
        return index;
    }

    public static int mcdaFindHighestDurabilityEquipment(class_1309 livingEntity) {
        int i = 0;
        int[] armorPieceDurability = new int[]{0, 0, 0, 0};
        for (class_1799 itemStack : livingEntity.method_5661()) {
            float k = itemStack.method_7936();
            float j = k - (float)itemStack.method_7919();
            armorPieceDurability[i] = (int)(j / k * 100.0f);
            ++i;
        }
        return CleanlinessHelper.mcdaIndexOfLargestElementInArray(armorPieceDurability);
    }

    public static void mcdaRandomArmorDamage(class_1309 livingEntity, float damagePercentage, int totalNumOfPieces, boolean missingBoots) {
        Random random = new Random();
        int index = random.nextInt(totalNumOfPieces);
        if (missingBoots) {
            ++index;
        }
        class_1304 equipment = switch (index) {
            case 0 -> class_1304.field_6166;
            case 1 -> class_1304.field_6172;
            case 2 -> class_1304.field_6174;
            case 3 -> class_1304.field_6169;
            default -> throw new IllegalStateException("Unexpected value: " + index);
        };
        CleanlinessHelper.mcdaDamageEquipment(livingEntity, equipment, damagePercentage);
    }

    public static void mcdaDamageEquipment(class_1309 livingEntity, class_1304 equipSlot, float damagePercentage) {
        int breakDamage;
        boolean toBreak;
        class_1799 armorStack = livingEntity.method_6118(equipSlot);
        int k = armorStack.method_7936();
        int j = k - armorStack.method_7919();
        boolean bl = toBreak = j <= (breakDamage = (int)((float)k * damagePercentage));
        if (toBreak) {
            armorStack.method_7956(j, livingEntity, entity -> entity.method_20235(equipSlot));
        } else {
            armorStack.method_7956(breakDamage, livingEntity, entity -> entity.method_20235(equipSlot));
        }
    }

    public static boolean mcdaCooldownCheck(class_1309 livingEntity, int ticks) {
        class_1799 chestStack = livingEntity.method_6118(class_1304.field_6174);
        long currentTime = livingEntity.field_6002.method_8510();
        if (!chestStack.method_7948().method_10545("time-check")) {
            chestStack.method_7948().method_10544("time-check", currentTime);
            return false;
        }
        long storedTime = chestStack.method_7948().method_10537("time-check");
        return Math.abs(currentTime - storedTime) > (long)ticks;
    }

    public static boolean mcdaBoundingBox(class_1657 playerEntity, float boxSize) {
        return playerEntity.field_6002.method_20812((class_1297)playerEntity, playerEntity.method_5829().method_989((double)boxSize * playerEntity.method_5829().method_17939(), 0.0, (double)boxSize * playerEntity.method_5829().method_17941())).iterator().hasNext();
    }

    public static boolean mcdaCanTargetEntity(class_1657 playerEntity, class_1297 target) {
        class_243 playerVec = playerEntity.method_5828(0.0f);
        class_243 vecHorTargetDist = new class_243(target.method_23317() - playerEntity.method_23317(), target.method_23318() - playerEntity.method_23318(), target.method_23321() - playerEntity.method_23321());
        double horTargetDist = vecHorTargetDist.method_37267();
        class_243 perpHorTargetDist = vecHorTargetDist.method_1029().method_1036(new class_243(0.0, 1.0, 0.0));
        class_243 leftSideVec = vecHorTargetDist.method_1029().method_1021(horTargetDist).method_1019(perpHorTargetDist.method_1021((double)target.method_17681()));
        class_243 rightSideVec = vecHorTargetDist.method_1029().method_1021(horTargetDist).method_1019(perpHorTargetDist.method_1021((double)(-target.method_17681())));
        double playerEyeHeight = playerEntity.method_23320() - (double)playerEntity.method_24515().method_10264();
        return Math.max(leftSideVec.method_1029().field_1352, rightSideVec.method_1029().field_1352) >= playerVec.method_1029().field_1352 && Math.min(leftSideVec.method_1029().field_1352, rightSideVec.method_1029().field_1352) <= playerVec.method_1029().field_1352 && Math.max(leftSideVec.method_1029().field_1350, rightSideVec.method_1029().field_1350) >= playerVec.method_1029().field_1350 && Math.min(leftSideVec.method_1029().field_1350, rightSideVec.method_1029().field_1350) <= playerVec.method_1029().field_1350 && playerVec.field_1351 > -Math.atan(playerEyeHeight / horTargetDist) && playerVec.field_1351 < Math.atan(((double)target.method_17682() - playerEyeHeight) / horTargetDist);
    }

    public static boolean mcdaCheckHorizontalVelocity(class_243 vec3d, double magnitude, boolean equality) {
        double horVelocity = vec3d.method_37267();
        if (equality) {
            return horVelocity == magnitude;
        }
        return horVelocity > magnitude;
    }

    public static boolean percentToOccur(int chance) {
        return random.nextInt(100) < chance;
    }

    public static void playCenteredSound(class_1309 center, class_3414 soundEvent, float volume, float pitch) {
        center.field_6002.method_43128(null, center.method_23317(), center.method_23318(), center.method_23321(), soundEvent, class_3419.field_15248, volume, pitch);
    }

    public static void mcda$dropItem(class_1309 le, class_1792 item) {
        CleanlinessHelper.mcda$dropItem(le, item, 1);
    }

    public static void mcda$dropItem(class_1309 le, class_1799 itemStack) {
        class_1542 it = new class_1542(le.field_6002, le.method_23317(), le.method_23318(), le.method_23321(), itemStack);
        le.field_6002.method_8649((class_1297)it);
    }

    public static void mcda$dropItem(class_1309 le, class_1792 item, int amount) {
        CleanlinessHelper.mcda$dropItem(le, new class_1799((class_1935)item, amount));
    }
}

