/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.network;

import com.kneelawk.graphlib.GraphLib;
import com.kneelawk.graphlib.graph.BlockGraph;
import com.kneelawk.graphlib.graph.BlockGraphController;
import com.kneelawk.graphlib.graph.BlockNodeHolder;
import com.kneelawk.graphlib.graph.struct.Node;
import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.entity.StorageDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.network.UpdateHandler;
import io.github.mattidragon.extendeddrawers.storage.DrawerStorage;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

public class NetworkStorageCache {
    private static final Map<class_5321<class_1937>, Long2ObjectMap<CombinedStorage<ItemVariant, DrawerStorage>>> CACHE = new HashMap<class_5321<class_1937>, Long2ObjectMap<CombinedStorage<ItemVariant, DrawerStorage>>>();

    public static void update(class_3218 world, long id, UpdateHandler.ChangeType type) {
        Long2ObjectMap<CombinedStorage<ItemVariant, DrawerStorage>> worldCache = CACHE.get(world.method_27983());
        if (worldCache == null || !worldCache.containsKey(id)) {
            return;
        }
        switch (type) {
            case STRUCTURE: {
                worldCache.remove(id);
                break;
            }
            case CONTENT: {
                ((CombinedStorage)worldCache.get((long)id)).parts.sort(null);
                break;
            }
        }
    }

    public static CombinedStorage<ItemVariant, DrawerStorage> get(class_3218 world, class_2338 pos) {
        OptionalLong optionalId = GraphLib.getController((class_3218)world).getGraphsAt(pos).findFirst();
        if (optionalId.isEmpty()) {
            ExtendedDrawers.LOGGER.warn("Missing graph at " + pos);
            return new CombinedStorage(List.of());
        }
        long id = optionalId.getAsLong();
        return (CombinedStorage)CACHE.computeIfAbsent((class_5321<class_1937>)world.method_27983(), key -> new Long2ObjectOpenHashMap()).computeIfAbsent(id, id_ -> new CombinedStorage(NetworkStorageCache.getDrawerSlots(world, pos)));
    }

    @NotNull
    private static ArrayList<DrawerStorage> getDrawerSlots(class_3218 world, class_2338 pos) {
        return new ArrayList<DrawerStorage>(GraphLib.getController((class_3218)world).getGraphsAt(pos).mapToObj(arg_0 -> ((BlockGraphController)GraphLib.getController((class_3218)world)).getGraph(arg_0)).filter(Objects::nonNull).flatMap(BlockGraph::getNodes).map(Node::data).map(BlockNodeHolder::getPos).map(arg_0 -> ((class_3218)world).method_8321(arg_0)).filter(StorageDrawerBlockEntity.class::isInstance).map(StorageDrawerBlockEntity.class::cast).flatMap(StorageDrawerBlockEntity::streamStorages).sorted().toList());
    }

    public static void clear() {
        CACHE.clear();
    }
}

