/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.compacting;

import io.github.mattidragon.extendeddrawers.compacting.CompressionLadder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public final class CompressionRecipeManager {
    private final class_1863 recipeManager;
    private final Map<ItemVariant, CompressionLadder> ladders = new HashMap<ItemVariant, CompressionLadder>();
    private final List<CompressionLadder> overrides = new ArrayList<CompressionLadder>();

    public CompressionRecipeManager(class_1863 recipeManager) {
        this.recipeManager = recipeManager;
    }

    public static CompressionRecipeManager of(class_1863 recipeManager) {
        return ((Provider)recipeManager).extended_drawers$getCompactingManager();
    }

    public void setOverrides(List<CompressionLadder> overrides) {
        this.overrides.clear();
        this.overrides.addAll(overrides);
        this.reload();
    }

    public List<CompressionLadder> getOverrides() {
        return this.overrides;
    }

    public void reload() {
        this.ladders.clear();
        for (CompressionLadder override : this.overrides) {
            this.addLadder(override);
        }
    }

    public CompressionLadder getLadder(ItemVariant item, class_1937 world) {
        if (this.ladders.containsKey(item)) {
            return this.ladders.get(item);
        }
        CompressionLadder ladder = this.buildLadder(item, world);
        this.addLadder(ladder);
        return ladder;
    }

    private void addLadder(CompressionLadder ladder) {
        ladder.steps().forEach(step -> this.ladders.put(step.item(), ladder));
    }

    private CompressionLadder buildLadder(ItemVariant item, class_1937 world) {
        RecipePair pair;
        ItemVariant bottom = this.findBottom(item, world);
        ArrayList<CompressionLadder.Step> ladder = new ArrayList<CompressionLadder.Step>();
        ItemVariant currentItem = bottom;
        int currentSize = 1;
        ladder.add(new CompressionLadder.Step(currentItem, currentSize));
        while ((pair = this.findCompressionRecipe(currentItem, world)) != null) {
            currentItem = pair.compressed;
            ladder.add(new CompressionLadder.Step(currentItem, currentSize *= pair.scale));
        }
        return new CompressionLadder(List.copyOf(ladder));
    }

    private ItemVariant findBottom(ItemVariant item, class_1937 world) {
        RecipePair pair;
        HashSet<ItemVariant> visited = new HashSet<ItemVariant>();
        ItemVariant candidate = item;
        while ((pair = this.findDecompressionRecipe(candidate, world)) != null && !visited.contains(pair.decompressed)) {
            candidate = pair.decompressed;
            visited.add(candidate);
        }
        return candidate;
    }

    private RecipePair findCompressionRecipe(ItemVariant decompressed, class_1937 world) {
        RecipePair largeCompressionRecipe = this.findCompressionRecipeForSize(decompressed, world, true);
        if (largeCompressionRecipe != null) {
            return largeCompressionRecipe;
        }
        return this.findCompressionRecipeForSize(decompressed, world, false);
    }

    @Nullable
    private RecipePair findCompressionRecipeForSize(ItemVariant decompressed, class_1937 world, boolean isLarge) {
        class_1715 largeCompressionInventory = this.createInventory(decompressed.toStack(), isLarge ? 3 : 2);
        Optional largeCompressionRecipe = this.recipeManager.method_8132(class_3956.field_17545, (class_1263)largeCompressionInventory, world);
        if (largeCompressionRecipe.isEmpty()) {
            return null;
        }
        class_1799 largeCompressionResult = ((class_3955)largeCompressionRecipe.get()).method_8116((class_1263)largeCompressionInventory);
        class_1715 decompressionInventory = this.createInventory(largeCompressionResult, 1);
        Optional decompressionRecipe = this.recipeManager.method_8132(class_3956.field_17545, (class_1263)decompressionInventory, world);
        if (decompressionRecipe.isEmpty()) {
            return null;
        }
        class_1799 decompressionResult = ((class_3955)decompressionRecipe.get()).method_8116((class_1263)decompressionInventory);
        if (decompressionResult.method_7960()) {
            return null;
        }
        if (!decompressed.matches(decompressionResult)) {
            return null;
        }
        return new RecipePair(ItemVariant.of((class_1799)largeCompressionResult), decompressed, isLarge ? 9 : 4);
    }

    @Nullable
    private RecipePair findDecompressionRecipe(ItemVariant compressed, class_1937 world) {
        class_1799 smallCompressionResult;
        class_1799 largeCompressionResult;
        class_1799 stack = compressed.toStack();
        class_1715 decompressionInventory = this.createInventory(stack, 1);
        Optional decompressionRecipe = this.recipeManager.method_8132(class_3956.field_17545, (class_1263)decompressionInventory, world);
        if (decompressionRecipe.isEmpty()) {
            return null;
        }
        class_1799 decompressionResult = ((class_3955)decompressionRecipe.get()).method_8116((class_1263)decompressionInventory);
        if (decompressionResult.method_7960()) {
            return null;
        }
        class_1715 largeCompressionInventory = this.createInventory(decompressionResult, 3);
        Optional largeCompressionRecipe = this.recipeManager.method_8132(class_3956.field_17545, (class_1263)largeCompressionInventory, world);
        if (largeCompressionRecipe.isPresent() && compressed.matches(largeCompressionResult = ((class_3955)largeCompressionRecipe.get()).method_8116((class_1263)largeCompressionInventory))) {
            return new RecipePair(compressed, ItemVariant.of((class_1799)decompressionResult), 9);
        }
        class_1715 smallCompressionInventory = this.createInventory(decompressionResult, 2);
        Optional smallCompressionRecipe = this.recipeManager.method_8132(class_3956.field_17545, (class_1263)smallCompressionInventory, world);
        if (smallCompressionRecipe.isPresent() && compressed.matches(smallCompressionResult = ((class_3955)smallCompressionRecipe.get()).method_8116((class_1263)smallCompressionInventory))) {
            return new RecipePair(compressed, ItemVariant.of((class_1799)decompressionResult), 4);
        }
        return null;
    }

    private class_1715 createInventory(class_1799 stack, int size) {
        class_1715 inventory = new class_1715(new class_1703(null, -1){

            public class_1799 method_7601(class_1657 player, int index) {
                return class_1799.field_8037;
            }

            public boolean method_7597(class_1657 player) {
                return false;
            }
        }, size, size);
        for (int i = 0; i < size * size; ++i) {
            inventory.method_5447(i, stack);
        }
        return inventory;
    }

    public static interface Provider {
        default public CompressionRecipeManager extended_drawers$getCompactingManager() {
            throw new AssertionError((Object)"extended_drawers$getCompactingManager must be overridden");
        }
    }

    private record RecipePair(ItemVariant compressed, ItemVariant decompressed, int scale) {
    }
}

