/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.client.renderer;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.CompactingDrawerBlock;
import io.github.mattidragon.extendeddrawers.block.DrawerBlock;
import io.github.mattidragon.extendeddrawers.block.entity.CompactingDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.client.renderer.AbstractDrawerBlockEntityRenderer;
import io.github.mattidragon.extendeddrawers.config.ClientConfig;
import io.github.mattidragon.extendeddrawers.storage.CompactingDrawerStorage;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_761;

public class CompactingDrawerBlockEntityRenderer
extends AbstractDrawerBlockEntityRenderer<CompactingDrawerBlockEntity> {
    public CompactingDrawerBlockEntityRenderer(class_5614.class_5615 context) {
        super(context);
    }

    public int method_33893() {
        ClientConfig config = (ClientConfig)ClientConfig.HANDLE.get();
        return Math.max(config.iconRenderDistance(), Math.max(config.textRenderDistance(), config.itemRenderDistance()));
    }

    public void render(CompactingDrawerBlockEntity drawer, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_2338 drawerPos = drawer.method_11016();
        class_2350 dir = (class_2350)drawer.method_11010().method_11654((class_2769)DrawerBlock.FACING);
        if (!this.shouldRender(drawer, dir)) {
            return;
        }
        matrices.method_22903();
        this.alignMatrices(matrices, dir);
        light = class_761.method_23794((class_1920)((class_1920)Objects.requireNonNull(drawer.method_10997())), (class_2338)drawer.method_11016().method_10093(dir));
        this.renderIcons(drawer, matrices, vertexConsumers, light, overlay);
        CompactingDrawerStorage.Slot[] slots = drawer.storage.getActiveSlots();
        if (slots.length >= 1) {
            matrices.method_22904(0.0, 0.25, 0.0);
            this.renderSlot(drawer.storage.getSlot(CompactingDrawerBlock.getSlot(new class_241(0.5f, 0.25f), slots.length)), light, matrices, vertexConsumers, (int)drawer.method_11016().method_10063(), drawerPos);
        }
        if (slots.length >= 2) {
            matrices.method_22904(0.25, -0.5, 0.0);
            this.renderSlot(drawer.storage.getSlot(CompactingDrawerBlock.getSlot(new class_241(0.75f, 0.75f), slots.length)), light, matrices, vertexConsumers, (int)drawer.method_11016().method_10063(), drawerPos);
        }
        if (slots.length >= 3) {
            matrices.method_22904(-0.5, 0.0, 0.0);
            this.renderSlot(drawer.storage.getSlot(CompactingDrawerBlock.getSlot(new class_241(0.25f, 0.75f), slots.length)), light, matrices, vertexConsumers, (int)drawer.method_11016().method_10063(), drawerPos);
        }
        matrices.method_22909();
    }

    private void renderIcons(CompactingDrawerBlockEntity drawer, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_746 player;
        class_243 playerPos;
        ArrayList<class_1058> icons = new ArrayList<class_1058>();
        Function blockAtlas = class_310.method_1551().method_1549(class_1723.field_21668);
        if (drawer.storage.isLocked()) {
            icons.add((class_1058)blockAtlas.apply(ExtendedDrawers.id("item/lock")));
        }
        if (drawer.storage.isVoiding()) {
            icons.add((class_1058)blockAtlas.apply(new class_2960("minecraft", "item/lava_bucket")));
        }
        if (drawer.storage.isHidden()) {
            icons.add((class_1058)blockAtlas.apply(new class_2960("minecraft", "item/black_dye")));
        }
        if (drawer.storage.getUpgrade() != null) {
            icons.add((class_1058)blockAtlas.apply(drawer.storage.getUpgrade().sprite));
        }
        class_243 class_2432 = playerPos = (player = class_310.method_1551().field_1724) == null ? class_243.method_24953((class_2382)drawer.method_11016()) : player.method_19538();
        if (drawer.method_11016().method_19769((class_2374)playerPos, (double)((ClientConfig)ClientConfig.HANDLE.get()).iconRenderDistance())) {
            matrices.method_22903();
            matrices.method_22904(0.0, 0.25, 0.0);
            this.renderIcons(icons, true, light, matrices, vertexConsumers, overlay);
            matrices.method_22909();
        }
    }

    private void renderSlot(CompactingDrawerStorage.Slot slot, int light, class_4587 matrices, class_4597 vertexConsumers, int seed, class_2338 pos) {
        ClientConfig config;
        if (slot.isBlocked()) {
            return;
        }
        ItemVariant item = slot.getStorage().isHidden() ? ItemVariant.blank() : slot.getResource();
        Long amount = slot.getAmount() == 0L || ((ClientConfig)ClientConfig.HANDLE.get()).displayEmptyCount() ? null : Long.valueOf(slot.getAmount());
        class_243 playerPos = class_310.method_1551().field_1724.method_19538();
        if (pos.method_19769((class_2374)playerPos, (double)(config = (ClientConfig)ClientConfig.HANDLE.get()).textRenderDistance()) && amount != null) {
            this.renderText(amount, true, light, matrices, vertexConsumers);
        }
        if (pos.method_19769((class_2374)playerPos, (double)config.itemRenderDistance())) {
            this.renderItem(item, true, light, matrices, vertexConsumers, seed);
        }
    }
}

