/*
 * Decompiled with CFR 0.152.
 */
package net.jobsaddon.network;

import io.netty.buffer.Unpooled;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.jobsaddon.access.JobsManagerAccess;
import net.jobsaddon.init.ConfigInit;
import net.jobsaddon.jobs.JobsManager;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class JobsServerPacket {
    public static final class_2960 EMPLOY_JOB_PACKET = new class_2960("jobsaddon", "employ_job");
    public static final class_2960 JOB_PACKET = new class_2960("jobsaddon", "job");
    public static final class_2960 JOB_XP_PACKET = new class_2960("jobsaddon", "job_xp");
    public static final class_2960 SEND_JOB_CONFIG_SYNC_PACKET = new class_2960("jobsaddon", "send_config_sync_packet");
    public static final class_2960 JOB_CONFIG_SYNC_PACKET = new class_2960("jobsaddon", "config_sync_packet");

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)EMPLOY_JOB_PACKET, (server, player, handler, buffer, sender) -> {
            String jobName = buffer.method_19772();
            boolean employJob = buffer.readBoolean();
            server.execute(() -> {
                JobsManager jobsManager = ((JobsManagerAccess)player).getJobsManager();
                if (employJob) {
                    if (jobsManager.canEmployJob(jobName)) {
                        jobsManager.employJob(jobName);
                        jobsManager.setEmployedJobTime(ConfigInit.CONFIG.jobChangeTime);
                    }
                } else {
                    jobsManager.quitJob(jobName);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SEND_JOB_CONFIG_SYNC_PACKET, (server, player, handler, buffer, sender) -> server.execute(() -> JobsServerPacket.writeS2CJobConfigSyncPacket(player, ConfigInit.CONFIG.getJobConfigList())));
    }

    public static void writeS2CJobPacket(JobsManager jobsManager, class_3222 serverPlayerEntity) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(jobsManager.getJobLevel("brewer"));
        buf.writeInt(jobsManager.getJobLevel("builder"));
        buf.writeInt(jobsManager.getJobLevel("farmer"));
        buf.writeInt(jobsManager.getJobLevel("fisher"));
        buf.writeInt(jobsManager.getJobLevel("lumberjack"));
        buf.writeInt(jobsManager.getJobLevel("miner"));
        buf.writeInt(jobsManager.getJobLevel("smither"));
        buf.writeInt(jobsManager.getJobLevel("warrior"));
        buf.writeInt(jobsManager.getJobXP("brewer"));
        buf.writeInt(jobsManager.getJobXP("builder"));
        buf.writeInt(jobsManager.getJobXP("farmer"));
        buf.writeInt(jobsManager.getJobXP("fisher"));
        buf.writeInt(jobsManager.getJobXP("lumberjack"));
        buf.writeInt(jobsManager.getJobXP("miner"));
        buf.writeInt(jobsManager.getJobXP("smither"));
        buf.writeInt(jobsManager.getJobXP("warrior"));
        if (jobsManager.getEmployedJobs() != null) {
            buf.writeInt(jobsManager.getEmployedJobs().size());
            for (int i = 0; i < jobsManager.getEmployedJobs().size(); ++i) {
                buf.method_10814(jobsManager.getEmployedJobs().get(i));
            }
        } else {
            buf.writeInt(0);
        }
        buf.writeInt(jobsManager.getEmployedJobTime());
        class_2658 packet = new class_2658(JOB_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2CJobXPPacket(class_3222 serverPlayerEntity, String jobName, int amount) {
        JobsManager jobsManager = ((JobsManagerAccess)serverPlayerEntity).getJobsManager();
        jobsManager.addJobXP((class_1657)serverPlayerEntity, jobName, amount);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(jobName);
        buf.writeInt(jobsManager.getJobXP(jobName));
        class_2658 packet = new class_2658(JOB_XP_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2CJobConfigSyncPacket(class_3222 serverPlayerEntity, List<Object> list) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof Integer) {
                buf.writeInt(((Integer)list.get(i)).intValue());
                continue;
            }
            if (list.get(i) instanceof Float) {
                buf.writeFloat(((Float)list.get(i)).floatValue());
                continue;
            }
            if (list.get(i) instanceof Double) {
                buf.writeDouble(((Double)list.get(i)).doubleValue());
                continue;
            }
            if (!(list.get(i) instanceof Boolean)) continue;
            buf.writeBoolean(((Boolean)list.get(i)).booleanValue());
        }
        class_2658 packet = new class_2658(JOB_CONFIG_SYNC_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }
}

