/*
 * Decompiled with CFR 0.152.
 */
package net.jobsaddon.mixin.player;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import net.jobsaddon.JobsAddonMain;
import net.jobsaddon.access.JobsManagerAccess;
import net.jobsaddon.access.PlayerAccess;
import net.jobsaddon.jobs.JobHelper;
import net.jobsaddon.jobs.JobsManager;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements JobsManagerAccess,
PlayerAccess {
    private final JobsManager jobsManager = new JobsManager();
    private class_2338 lastBlockPos;
    private int lastBlockId;
    private int blockCount;
    @Nullable
    private class_2960 lastRecipeIdentifier;

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbtMixin(class_2487 tag, CallbackInfo info) {
        this.jobsManager.readNbt(tag);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbtMixin(class_2487 tag, CallbackInfo info) {
        this.jobsManager.writeNbt(tag);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tickMixin(CallbackInfo info) {
        if (this.jobsManager.getEmployedJobTime() > 0) {
            this.jobsManager.setEmployedJobTime(this.jobsManager.getEmployedJobTime() - 1);
        }
    }

    @Inject(method={"onKilledOther"}, at={@At(value="HEAD")})
    private void onKilledOtherMixin(class_3218 world, class_1309 other, CallbackInfoReturnable<Boolean> info) {
        class_1657 player = (class_1657)this;
        if (!player.field_6002.field_9236) {
            JobHelper.addFisherEntityXp(player, other);
            JobHelper.addWarriorXp(player, other);
        }
    }

    @Override
    public JobsManager getJobsManager() {
        return this.jobsManager;
    }

    @Override
    public boolean setLastBlockId(class_2338 blockPos, boolean building, int id) {
        if (building) {
            this.blockCount = this.lastBlockId == id ? ++this.blockCount : 0;
            this.lastBlockId = id;
            if (this.blockCount > 200) {
                JobsAddonMain.LOGGER.warn("Player " + ((class_1657)this).method_5477().getString() + " placed over 200 blocks of type " + ((class_2248)class_2378.field_11146.method_10200(id)).method_8389().method_7848().getString() + " at last pos " + ((class_1657)this).method_24515());
                try (FileWriter playerLogFile = new FileWriter("playerlog.txt", true);){
                    playerLogFile.append("Player " + ((class_1657)this).method_5477().getString() + " placed over 200 blocks of type " + ((class_2248)class_2378.field_11146.method_10200(id)).method_8389().method_7848().getString() + " at last pos " + ((class_1657)this).method_24515() + " at " + new Timestamp(System.currentTimeMillis()));
                    playerLogFile.append(System.lineSeparator());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.blockCount = 0;
            }
            return this.blockCount < 200;
        }
        this.blockCount = this.lastBlockPos != null && this.lastBlockPos.equals((Object)blockPos) ? ++this.blockCount : 0;
        this.lastBlockPos = blockPos;
        return this.blockCount < 10;
    }

    @Override
    public int getLastBlockId() {
        return this.lastBlockId;
    }

    @Override
    @Nullable
    public class_2960 getLastRecipeId() {
        return this.lastRecipeIdentifier;
    }

    @Override
    public void setLastRecipeId(class_2960 identifier) {
        this.lastRecipeIdentifier = identifier;
    }
}

