/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.handler;

import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.data.ItemBlacklistManager;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import fuzs.pickupnotifier.client.gui.entry.ExperienceDisplayEntry;
import fuzs.pickupnotifier.client.gui.entry.ItemDisplayEntry;
import fuzs.pickupnotifier.client.handler.DrawEntriesHandler;
import fuzs.pickupnotifier.config.ClientConfig;
import fuzs.pickupnotifier.mixin.client.accessor.AbstractArrowAccessor;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_746;

public class AddEntriesHandler {
    public static void onEntityPickup(class_310 minecraft, int entityId, int playerId, int amount) {
        if (class_310.method_1551().field_1687.method_8469(playerId) instanceof class_746 && !DrawEntriesHandler.INSTANCE.isItemEntityHandled(entityId)) {
            AddEntriesHandler.onEntityPickup(minecraft, entityId, amount);
        }
    }

    public static void addPickUpEntry(class_310 minecraft, int entityId, int amount) {
        if (!((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.forceClient) {
            DrawEntriesHandler.INSTANCE.addHandledEntity(entityId);
            AddEntriesHandler.onEntityPickup(minecraft, entityId, amount);
        }
    }

    public static void addItemEntry(class_310 minecraft, class_1799 stack) {
        if (!((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.forceClient && ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.includeItems) {
            AddEntriesHandler.addItemEntry(minecraft, stack, stack.method_7947());
        }
    }

    private static void onEntityPickup(class_310 minecraft, int itemId, int amount) {
        class_1297 entity = minecraft.field_1687.method_8469(itemId);
        if (entity instanceof class_1542) {
            class_1542 item = (class_1542)entity;
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.includeItems) {
                AddEntriesHandler.addItemEntry(minecraft, item.method_6983(), amount);
            }
        } else if (entity instanceof class_1665) {
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.includeArrows) {
                AddEntriesHandler.addItemEntry(minecraft, ((AbstractArrowAccessor)entity).pickupnotifier$callGetPickupItem(), amount);
            }
        } else if (entity instanceof class_1303) {
            class_1303 experience = (class_1303)entity;
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.includeExperience) {
                AddEntriesHandler.addExperienceEntry(minecraft, experience, amount);
            }
        }
    }

    private static void addItemEntry(class_310 minecraft, class_1799 stack, int amount) {
        if (!stack.method_7960() && ItemBlacklistManager.INSTANCE.isItemAllowed((class_5321<class_1937>)minecraft.field_1687.method_27983(), stack.method_7909())) {
            stack = stack.method_7972();
            stack.method_7983("Enchantments");
            AddEntriesHandler.addEntry(minecraft, new ItemDisplayEntry(stack, amount));
        }
    }

    private static void addExperienceEntry(class_310 minecraft, class_1303 orb, int amount) {
        if (orb.method_5919() > 0) {
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.experienceValue) {
                amount = orb.method_5919();
            }
            AddEntriesHandler.addEntry(minecraft, new ExperienceDisplayEntry(orb.method_5477(), amount));
        }
    }

    private static void addEntry(class_310 minecraft, DisplayEntry newEntry) {
        Optional possibleDuplicate;
        if (minecraft.field_1724 != null && minecraft.field_1724.method_31549().field_7477 && ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.disableInCreative) {
            return;
        }
        int scaledHeight = (int)((float)minecraft.method_22683().method_4502() / ((float)((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.scale / 6.0f));
        int maxSize = (int)((double)scaledHeight * ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.maxHeight / 18.0) - 1;
        Optional<Object> optional = possibleDuplicate = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.combineEntries ? DrawEntriesHandler.INSTANCE.getCollector().findDuplicate(newEntry) : Optional.empty();
        if (possibleDuplicate.isPresent()) {
            DisplayEntry duplicate = (DisplayEntry)possibleDuplicate.get();
            duplicate.mergeWith(newEntry);
            DrawEntriesHandler.INSTANCE.getCollector().refresh(duplicate);
        } else {
            DrawEntriesHandler.INSTANCE.getCollector().add(newEntry, maxSize);
        }
    }
}

