/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import com.google.common.collect.ImmutableSortedMap;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.config.ClientConfig;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import net.minecraft.class_1159;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_918;

public class DisplayEntryRenderHelper {
    private static final NavigableMap<Integer, Character> MAP = ImmutableSortedMap.naturalOrder().put((Object)1000, (Object)Character.valueOf('K')).put((Object)1000000, (Object)Character.valueOf('M')).put((Object)1000000000, (Object)Character.valueOf('B')).build();

    private static class_5250 shortenValue(int value) {
        Map.Entry<Integer, Character> entry = MAP.floorEntry(value);
        if (entry == null) {
            return class_2561.method_43470((String)String.valueOf(value));
        }
        return class_2561.method_43470((String)(String.valueOf(value / entry.getKey()) + entry.getValue()));
    }

    public static void renderGuiItemDecorations(class_918 itemRenderer, class_327 font, int count, int xPosition, int yPosition) {
        if (count <= 1 && !((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displaySingleCount) {
            return;
        }
        class_4587 poseStack = new class_4587();
        class_5250 component = DisplayEntryRenderHelper.shortenValue(count);
        poseStack.method_22904(0.0, 0.0, (double)(itemRenderer.field_4730 + 200.0f));
        float scale = Math.min(1.0f, 16.0f / (float)font.method_27525((class_5348)component));
        poseStack.method_22905(scale, scale, 1.0f);
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        float posX = (float)(xPosition + 17) / scale - (float)font.method_27525((class_5348)component);
        Objects.requireNonNull(font);
        float f = (float)(yPosition + 9 * 2) / scale;
        Objects.requireNonNull(font);
        float posY = f - 9.0f;
        font.method_30882((class_2561)component, posX, posY, 0xFFFFFF, true, poseStack.method_23760().method_23761(), (class_4597)bufferSource, false, 0, 0xF000F0);
        bufferSource.method_22993();
    }

    public static void renderTooltipInternal(class_4587 poseStack, int posX, int posY, int width, int height, int alpha) {
        poseStack.method_22903();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        class_1159 matrix4f = poseStack.method_23760().method_23761();
        int color = DisplayEntryRenderHelper.applyAlphaComponent(-267386864, alpha);
        int blitOffset = 0;
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX - 3, posY - 4, posX + width + 3, posY - 3, blitOffset, color, color);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX - 3, posY + height + 3, posX + width + 3, posY + height + 4, blitOffset, color, color);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX - 3, posY - 3, posX + width + 3, posY + height + 3, blitOffset, color, color);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX - 4, posY - 3, posX - 3, posY + height + 3, blitOffset, color, color);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX + width + 3, posY - 3, posX + width + 4, posY + height + 3, blitOffset, color, color);
        int colorA = DisplayEntryRenderHelper.applyAlphaComponent(0x505000FF, alpha);
        int colorB = DisplayEntryRenderHelper.applyAlphaComponent(1344798847, alpha);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX - 3, posY - 3 + 1, posX - 3 + 1, posY + height + 3 - 1, blitOffset, colorA, colorB);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX + width + 2, posY - 3 + 1, posX + width + 3, posY + height + 3 - 1, blitOffset, colorA, colorB);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX - 3, posY - 3, posX + width + 3, posY - 3 + 1, blitOffset, colorA, colorA);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX - 3, posY + height + 2, posX + width + 3, posY + height + 3, blitOffset, colorB, colorB);
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        poseStack.method_22909();
    }

    private static int applyAlphaComponent(int color, int alpha) {
        return color & 0xFFFFFF | Math.min(color >> 24 & 0xFF, alpha) << 24;
    }

    private static void fillGradient(class_1159 matrix, class_287 builder, int x1, int y1, int x2, int y2, int blitOffset, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float g = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float h = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float i = (float)(colorA & 0xFF) / 255.0f;
        float j = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float k = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float l = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float m = (float)(colorB & 0xFF) / 255.0f;
        builder.method_22918(matrix, (float)x2, (float)y1, (float)blitOffset).method_22915(g, h, i, f).method_1344();
        builder.method_22918(matrix, (float)x1, (float)y1, (float)blitOffset).method_22915(g, h, i, f).method_1344();
        builder.method_22918(matrix, (float)x1, (float)y2, (float)blitOffset).method_22915(k, l, m, j).method_1344();
        builder.method_22918(matrix, (float)x2, (float)y2, (float)blitOffset).method_22915(k, l, m, j).method_1344();
    }
}

