/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntryRenderHelper;
import fuzs.pickupnotifier.config.ClientConfig;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public abstract class DisplayEntry {
    public static final int ENTRY_HEIGHT = 18;
    private static final int TEXT_ITEM_MARGIN = 4;
    private static final DisplayEntryTextFactory RIGHT = (name, displayAmount, inventoryCount) -> {
        class_5250 component = displayAmount > 1 || displayAmount == 1 && ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displaySingleCount ? class_2561.method_43470((String)(displayAmount + "x ")) : class_2561.method_43473();
        component.method_10852(name);
        if (inventoryCount > 0) {
            component.method_27693(" ").method_10852((class_2561)DisplayEntry.wrapInBrackets((class_2561)class_2561.method_43470((String)String.valueOf(inventoryCount))));
        }
        return component;
    };
    private static final DisplayEntryTextFactory LEFT = (name, displayAmount, inventoryCount) -> {
        class_5250 component = inventoryCount > 0 ? DisplayEntry.wrapInBrackets((class_2561)class_2561.method_43470((String)String.valueOf(inventoryCount))).method_27693(" ") : class_2561.method_43473();
        component.method_10852(name);
        if (displayAmount > 1 || displayAmount == 1 && ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displaySingleCount) {
            component.method_10852((class_2561)class_2561.method_43470((String)(" x" + displayAmount)));
        }
        return component;
    };
    private final class_1814 rarity;
    private int remainingTicks;
    private int displayAmount;
    private class_2561 component;

    protected DisplayEntry(int displayAmount, class_1814 rarity) {
        this.displayAmount = displayAmount;
        this.rarity = rarity;
        this.resetEntry();
    }

    private static class_5250 wrapInBrackets(class_2561 toWrap) {
        return class_2561.method_43470((String)"(").method_10852(toWrap).method_27693(")");
    }

    public int getRemainingTicks() {
        return this.remainingTicks;
    }

    public int getDisplayAmount() {
        return this.displayAmount;
    }

    public boolean mayDiscard() {
        return this.remainingTicks <= 0;
    }

    public void tick() {
        if (this.remainingTicks > 0) {
            --this.remainingTicks;
        }
    }

    protected abstract class_2561 getEntryName();

    protected abstract int getInventoryCount(class_1661 var1);

    public class_2561 getTextComponent(class_1657 player) {
        if (this.component == null) {
            DisplayEntryTextFactory factory = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.position.mirrored() ? RIGHT : LEFT;
            int displayAmount = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayAmount.text() ? this.getDisplayAmount() : 0;
            int inventoryCount = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.inventoryCount ? this.getInventoryCount(player.method_31548()) : 0;
            this.component = factory.create(this.getEntryName(), displayAmount, inventoryCount).method_10862(this.getComponentStyle());
        }
        return this.component;
    }

    private class_2583 getComponentStyle() {
        if (!((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.ignoreRarity && this.rarity != class_1814.field_8906) {
            return class_2583.field_24360.method_10977(this.rarity.field_8908);
        }
        return class_2583.field_24360.method_10977(((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.textColor);
    }

    public float getRemainingTicksRelative(float partialTicks) {
        float moveTime = Math.min(((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.moveTime, ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.displayTime);
        return 1.0f - class_3532.method_15363((float)(((float)this.remainingTicks - partialTicks) / moveTime), (float)0.0f, (float)1.0f);
    }

    public void resetEntry() {
        this.remainingTicks = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.displayTime;
        this.component = null;
    }

    public abstract boolean mayMergeWith(DisplayEntry var1);

    public void mergeWith(DisplayEntry other) {
        this.displayAmount += other.displayAmount;
        this.resetEntry();
    }

    public int getEntryWidth(class_310 minecraft) {
        int textWidth = minecraft.field_1772.method_27525((class_5348)this.getTextComponent((class_1657)minecraft.field_1724));
        return ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.drawSprite ? textWidth + 4 + 16 : textWidth;
    }

    public void render(class_310 minecraft, class_4587 poseStack, int posX, int posY, float alpha, float scale) {
        int fadeTime;
        boolean mirrorPosition = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.position.mirrored();
        boolean withSprite = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.drawSprite;
        int posXSide = mirrorPosition || !withSprite ? posX : posX + 16 + 4;
        poseStack.method_22903();
        poseStack.method_22905(scale, scale, 1.0f);
        this.renderBg(minecraft, poseStack, posX, posY, alpha);
        int n = fadeTime = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.fadeAway ? 255 - (int)(255.0f * alpha) : 255;
        if (fadeTime >= 5) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_332.method_27535((class_4587)poseStack, (class_327)minecraft.field_1772, (class_2561)this.getTextComponent((class_1657)minecraft.field_1724), (int)posXSide, (int)(posY + 4), (int)(0xFFFFFF | fadeTime << 24));
            if (withSprite) {
                int textWidth = minecraft.field_1772.method_27525((class_5348)this.getTextComponent((class_1657)minecraft.field_1724));
                this.renderSprite(minecraft, poseStack, mirrorPosition ? posX + textWidth + 4 : posX, posY, scale);
            }
            RenderSystem.disableBlend();
        }
        poseStack.method_22909();
    }

    private void renderBg(class_310 minecraft, class_4587 poseStack, int posX, int posY, float alpha) {
        switch (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.background) {
            case BLACK: {
                int backgroundOpacity = (int)((Double)minecraft.field_1690.method_42550().method_41753() * (double)(1.0f - alpha) * 255.0) << 24 & 0xFF000000;
                class_332.method_25294((class_4587)poseStack, (int)(posX - 3), (int)posY, (int)(posX + this.getEntryWidth(minecraft) + 5), (int)(posY + 16), (int)backgroundOpacity);
                break;
            }
            case TOOLTIP: {
                DisplayEntryRenderHelper.renderTooltipInternal(poseStack, posX, posY + 3, this.getEntryWidth(minecraft), 9, (int)((1.0f - alpha) * 255.0f));
            }
        }
    }

    protected abstract void renderSprite(class_310 var1, class_4587 var2, int var3, int var4, float var5);

    @FunctionalInterface
    private static interface DisplayEntryTextFactory {
        public class_5250 create(class_2561 var1, int var2, int var3);
    }
}

