/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.city.palette;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2389;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2544;
import net.minecraft.class_2555;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_3749;
import net.minecraft.class_4778;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockPottedPlant;
import org.betterx.betternether.blocks.BlockSmallLantern;
import org.betterx.betternether.registry.NetherBlocks;

public class CityPalette {
    private static final class_5819 RANDOM = new class_5820(130520220057L);
    private final String name;
    private final List<class_2248> foundationBlocks = new ArrayList<class_2248>();
    private final List<class_2248> foundationSlabs = new ArrayList<class_2248>();
    private final List<class_2248> foundationStairs = new ArrayList<class_2248>();
    private final List<class_2248> foundationWalls = new ArrayList<class_2248>();
    private final List<class_2248> roofBlocks = new ArrayList<class_2248>();
    private final List<class_2248> roofSlabs = new ArrayList<class_2248>();
    private final List<class_2248> roofStairs = new ArrayList<class_2248>();
    private final List<class_2248> planksBlocks = new ArrayList<class_2248>();
    private final List<class_2248> planksSlabs = new ArrayList<class_2248>();
    private final List<class_2248> planksStairs = new ArrayList<class_2248>();
    private final List<class_2248> fences = new ArrayList<class_2248>();
    private final List<class_2248> walls = new ArrayList<class_2248>();
    private final List<class_2248> gates = new ArrayList<class_2248>();
    private final List<class_2248> logs = new ArrayList<class_2248>();
    private final List<class_2248> bark = new ArrayList<class_2248>();
    private final List<class_2248> stoneBlocks = new ArrayList<class_2248>();
    private final List<class_2248> stoneSlabs = new ArrayList<class_2248>();
    private final List<class_2248> stoneStairs = new ArrayList<class_2248>();
    private final List<class_2248> glowingBlocks = new ArrayList<class_2248>();
    private final List<class_2248> wallLights = new ArrayList<class_2248>();
    private final List<class_2248> ceilingLights = new ArrayList<class_2248>();
    private final List<class_2248> floorLights = new ArrayList<class_2248>();
    private final List<class_2248> doors = new ArrayList<class_2248>();
    private final List<class_2248> trapdoors = new ArrayList<class_2248>();
    private final List<class_2248> platesStone = new ArrayList<class_2248>();
    private final List<class_2248> platesWood = new ArrayList<class_2248>();
    private final List<class_2248> glassBlocks = new ArrayList<class_2248>();
    private final List<class_2248> glassPanes = new ArrayList<class_2248>();
    private final List<class_2248> pots = new ArrayList<class_2248>();

    public CityPalette(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private CityPalette putBlocks(class_2248[] blocks, List<class_2248> list) {
        for (class_2248 b : blocks) {
            list.add(b);
        }
        return this;
    }

    public CityPalette addFoundationBlocks(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.foundationBlocks);
    }

    public CityPalette addFoundationSlabs(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.foundationSlabs);
    }

    public CityPalette addFoundationStairs(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.foundationStairs);
    }

    public CityPalette addFoundationWalls(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.foundationWalls);
    }

    public CityPalette addRoofBlocks(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.roofBlocks);
    }

    public CityPalette addRoofSlabs(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.roofSlabs);
    }

    public CityPalette addRoofStairs(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.roofStairs);
    }

    public CityPalette addPlanksBlocks(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.planksBlocks);
    }

    public CityPalette addPlanksSlabs(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.planksSlabs);
    }

    public CityPalette addPlanksStairs(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.planksStairs);
    }

    public CityPalette addFences(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.fences);
    }

    public CityPalette addWalls(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.walls);
    }

    public CityPalette addGates(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.gates);
    }

    public CityPalette addLogs(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.logs);
    }

    public CityPalette addBark(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.bark);
    }

    public CityPalette addStoneBlocks(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.stoneBlocks);
    }

    public CityPalette addStoneSlabs(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.stoneSlabs);
    }

    public CityPalette addStoneStairs(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.stoneStairs);
    }

    public CityPalette addGlowingBlocks(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.glowingBlocks);
    }

    public CityPalette addWallLights(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.wallLights);
    }

    public CityPalette addCeilingLights(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.ceilingLights);
    }

    public CityPalette addFloorLights(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.floorLights);
    }

    public CityPalette addDoors(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.doors);
    }

    public CityPalette addTrapdoors(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.trapdoors);
    }

    public CityPalette addStonePlates(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.platesStone);
    }

    public CityPalette addWoodPlates(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.platesWood);
    }

    public CityPalette addGlassBlocks(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.glassBlocks);
    }

    public CityPalette addGlassPanes(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.glassPanes);
    }

    public CityPalette addPotsPanes(class_2248 ... blocks) {
        return this.putBlocks(blocks, this.pots);
    }

    private class_2248 getRandomBlock(class_2680 state, List<class_2248> list) {
        if (list.isEmpty()) {
            return state.method_26204();
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        String seed = class_2378.field_11146.method_10221((Object)state.method_26204()).method_12832();
        RANDOM.method_43052((long)seed.hashCode());
        return list.get(RANDOM.method_43048(list.size()));
    }

    private class_2680 getFullState(class_2680 input, List<class_2248> list) {
        if (list.isEmpty()) {
            return input;
        }
        if (list.size() == 1) {
            return list.get(0).method_9564();
        }
        return this.getRandomBlock(input, list).method_9564();
    }

    private class_2680 getSlabState(class_2680 input, List<class_2248> list) {
        if (list.isEmpty()) {
            return input;
        }
        if (list.size() == 1) {
            return this.copySlab(input, list.get(0));
        }
        return this.copySlab(input, this.getRandomBlock(input, list));
    }

    private class_2680 getStairState(class_2680 input, List<class_2248> list) {
        if (list.isEmpty()) {
            return input;
        }
        if (list.size() == 1) {
            return this.copyStair(input, list.get(0));
        }
        return this.copyStair(input, this.getRandomBlock(input, list));
    }

    private class_2680 copySlab(class_2680 source, class_2248 block) {
        class_2680 state = (class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)((class_2771)source.method_11654((class_2769)class_2482.field_11501)))).method_11657((class_2769)class_2482.field_11502, (Comparable)((Boolean)source.method_11654((class_2769)class_2482.field_11502)));
        return state;
    }

    private class_2680 copyStair(class_2680 source, class_2248 block) {
        class_2680 state = (class_2680)((class_2680)((class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_2510.field_11571, (Comparable)((class_2350)source.method_11654((class_2769)class_2510.field_11571)))).method_11657((class_2769)class_2510.field_11572, (Comparable)((class_2760)source.method_11654((class_2769)class_2510.field_11572)))).method_11657((class_2769)class_2510.field_11565, (Comparable)((class_2778)source.method_11654((class_2769)class_2510.field_11565)))).method_11657((class_2769)class_2510.field_11573, (Comparable)((Boolean)source.method_11654((class_2769)class_2510.field_11573)));
        return state;
    }

    private class_2680 copyWall(class_2680 source, class_2248 block) {
        class_2680 state = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_2544.field_22156, (Comparable)((class_4778)source.method_11654((class_2769)class_2544.field_22156)))).method_11657((class_2769)class_2544.field_22157, (Comparable)((class_4778)source.method_11654((class_2769)class_2544.field_22157)))).method_11657((class_2769)class_2544.field_22158, (Comparable)((class_4778)source.method_11654((class_2769)class_2544.field_22158)))).method_11657((class_2769)class_2544.field_22159, (Comparable)((class_4778)source.method_11654((class_2769)class_2544.field_22159)))).method_11657((class_2769)class_2544.field_11717, (Comparable)((Boolean)source.method_11654((class_2769)class_2544.field_11717)))).method_11657((class_2769)class_2510.field_11573, (Comparable)((Boolean)source.method_11654((class_2769)class_2510.field_11573)));
        return state;
    }

    private class_2680 copyFence(class_2680 source, class_2248 block) {
        class_2680 state = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_2354.field_10907, (Comparable)((Boolean)source.method_11654((class_2769)class_2354.field_10907)))).method_11657((class_2769)class_2354.field_10905, (Comparable)((Boolean)source.method_11654((class_2769)class_2354.field_10905)))).method_11657((class_2769)class_2354.field_10904, (Comparable)((Boolean)source.method_11654((class_2769)class_2354.field_10904)))).method_11657((class_2769)class_2354.field_10903, (Comparable)((Boolean)source.method_11654((class_2769)class_2354.field_10903)))).method_11657((class_2769)class_2354.field_10900, (Comparable)((Boolean)source.method_11654((class_2769)class_2354.field_10900)));
        return state;
    }

    private class_2680 copyGate(class_2680 source, class_2248 block) {
        class_2680 state = (class_2680)((class_2680)((class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_2349.field_11024, (Comparable)((Boolean)source.method_11654((class_2769)class_2349.field_11024)))).method_11657((class_2769)class_2349.field_11026, (Comparable)((Boolean)source.method_11654((class_2769)class_2349.field_11026)))).method_11657((class_2769)class_2349.field_11021, (Comparable)((Boolean)source.method_11654((class_2769)class_2349.field_11021)))).method_11657((class_2769)class_2349.field_11177, (Comparable)((class_2350)source.method_11654((class_2769)class_2349.field_11177)));
        return state;
    }

    private class_2680 copyPillar(class_2680 source, class_2248 block) {
        class_2680 state = (class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)source.method_11654((class_2769)class_2465.field_11459)));
        return state;
    }

    private class_2680 copyLanternWall(class_2680 source, class_2248 block) {
        if (source.method_26204() instanceof BlockSmallLantern && !(block instanceof BlockSmallLantern)) {
            class_2350 facing = (class_2350)source.method_11654((class_2769)BlockSmallLantern.FACING);
            class_2680 state = block.method_9564();
            if (block instanceof class_2555) {
                return (class_2680)state.method_11657((class_2769)class_2555.field_11731, (Comparable)facing);
            }
            return state;
        }
        return source;
    }

    private class_2680 copyLanternCeiling(class_2680 source, class_2248 block) {
        if (source.method_26204() instanceof BlockSmallLantern && !(block instanceof BlockSmallLantern)) {
            class_2680 state = block.method_9564();
            if (block instanceof class_3749) {
                return (class_2680)state.method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.valueOf(true));
            }
            return state;
        }
        return source;
    }

    private class_2680 copyDoor(class_2680 source, class_2248 block) {
        class_2680 state = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_2323.field_10938, (Comparable)((class_2350)source.method_11654((class_2769)class_2323.field_10938)))).method_11657((class_2769)class_2323.field_10946, (Comparable)((class_2756)source.method_11654((class_2769)class_2323.field_10946)))).method_11657((class_2769)class_2323.field_10941, (Comparable)((class_2750)source.method_11654((class_2769)class_2323.field_10941)))).method_11657((class_2769)class_2323.field_10945, (Comparable)((Boolean)source.method_11654((class_2769)class_2323.field_10945)))).method_11657((class_2769)class_2323.field_10940, (Comparable)((Boolean)source.method_11654((class_2769)class_2323.field_10940)));
        return state;
    }

    private class_2680 copyTrapdoor(class_2680 source, class_2248 block) {
        class_2680 state = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_2533.field_11177, (Comparable)((class_2350)source.method_11654((class_2769)class_2533.field_11177)))).method_11657((class_2769)class_2533.field_11625, (Comparable)((class_2760)source.method_11654((class_2769)class_2533.field_11625)))).method_11657((class_2769)class_2533.field_11631, (Comparable)((Boolean)source.method_11654((class_2769)class_2533.field_11631)))).method_11657((class_2769)class_2533.field_11629, (Comparable)((Boolean)source.method_11654((class_2769)class_2533.field_11629)))).method_11657((class_2769)class_2533.field_11626, (Comparable)((Boolean)source.method_11654((class_2769)class_2533.field_11626)));
        return state;
    }

    private class_2680 copyPane(class_2680 source, class_2248 block) {
        class_2680 state = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_2389.field_10907, (Comparable)((Boolean)source.method_11654((class_2769)class_2389.field_10907)))).method_11657((class_2769)class_2389.field_10905, (Comparable)((Boolean)source.method_11654((class_2769)class_2389.field_10905)))).method_11657((class_2769)class_2389.field_10904, (Comparable)((Boolean)source.method_11654((class_2769)class_2389.field_10904)))).method_11657((class_2769)class_2389.field_10903, (Comparable)((Boolean)source.method_11654((class_2769)class_2389.field_10903)))).method_11657((class_2769)class_2389.field_10900, (Comparable)((Boolean)source.method_11654((class_2769)class_2389.field_10900)));
        return state;
    }

    public class_2680 getFoundationBlock(class_2680 input) {
        return this.getFullState(input, this.foundationBlocks);
    }

    public class_2680 getFoundationSlab(class_2680 input) {
        return this.getSlabState(input, this.foundationSlabs);
    }

    public class_2680 getFoundationStair(class_2680 input) {
        return this.getStairState(input, this.foundationStairs);
    }

    public class_2680 getFoundationWall(class_2680 input) {
        if (this.foundationWalls.isEmpty()) {
            return input;
        }
        if (this.foundationWalls.size() == 1) {
            return this.copyWall(input, this.foundationWalls.get(0));
        }
        return this.copyWall(input, this.getRandomBlock(input, this.foundationWalls));
    }

    public class_2680 getRoofBlock(class_2680 input) {
        return this.getFullState(input, this.roofBlocks);
    }

    public class_2680 getRoofSlab(class_2680 input) {
        return this.getSlabState(input, this.roofSlabs);
    }

    public class_2680 getRoofStair(class_2680 input) {
        return this.getStairState(input, this.roofStairs);
    }

    public class_2680 getPlanksBlock(class_2680 input) {
        return this.getFullState(input, this.planksBlocks);
    }

    public class_2680 getPlanksSlab(class_2680 input) {
        return this.getSlabState(input, this.planksSlabs);
    }

    public class_2680 getPlanksStair(class_2680 input) {
        return this.getStairState(input, this.planksStairs);
    }

    public class_2680 getFence(class_2680 input) {
        if (this.fences.isEmpty()) {
            return input;
        }
        if (this.fences.size() == 1) {
            return this.copyFence(input, this.fences.get(0));
        }
        return this.copyFence(input, this.getRandomBlock(input, this.fences));
    }

    public class_2680 getWall(class_2680 input) {
        if (this.walls.isEmpty()) {
            return input;
        }
        if (this.walls.size() == 1) {
            return this.copyWall(input, this.walls.get(0));
        }
        return this.copyWall(input, this.getRandomBlock(input, this.walls));
    }

    public class_2680 getGate(class_2680 input) {
        if (this.gates.isEmpty()) {
            return input;
        }
        if (this.gates.size() == 1) {
            return this.copyGate(input, this.gates.get(0));
        }
        return this.copyGate(input, this.getRandomBlock(input, this.gates));
    }

    public class_2680 getLog(class_2680 input) {
        if (this.logs.isEmpty()) {
            return input;
        }
        if (this.logs.size() == 1) {
            return this.copyPillar(input, this.logs.get(0));
        }
        return this.copyPillar(input, this.getRandomBlock(input, this.logs));
    }

    public class_2680 getBark(class_2680 input) {
        if (this.bark.isEmpty()) {
            return input;
        }
        if (this.bark.size() == 1) {
            return this.copyPillar(input, this.bark.get(0));
        }
        return this.copyPillar(input, this.getRandomBlock(input, this.bark));
    }

    public class_2680 getStoneBlock(class_2680 input) {
        return this.getFullState(input, this.stoneBlocks);
    }

    public class_2680 getStoneSlab(class_2680 input) {
        return this.getSlabState(input, this.stoneSlabs);
    }

    public class_2680 getStoneStair(class_2680 input) {
        return this.getStairState(input, this.stoneStairs);
    }

    public class_2680 getGlowingBlock(class_2680 input) {
        return this.getFullState(input, this.glowingBlocks);
    }

    public class_2680 getWallLight(class_2680 input) {
        if (this.wallLights.isEmpty()) {
            return input;
        }
        if (this.wallLights.size() == 1) {
            return this.copyLanternWall(input, this.bark.get(0));
        }
        return this.copyLanternWall(input, this.getRandomBlock(input, this.wallLights));
    }

    public class_2680 getCeilingLight(class_2680 input) {
        return this.copyLanternCeiling(input, this.getRandomBlock(input, this.ceilingLights));
    }

    public class_2680 getFloorLight(class_2680 input) {
        return this.getFullState(input, this.ceilingLights);
    }

    public class_2680 getDoor(class_2680 input) {
        return this.copyDoor(input, this.getRandomBlock(input, this.doors));
    }

    public class_2680 getTrapdoor(class_2680 input) {
        return this.copyTrapdoor(input, this.getRandomBlock(input, this.trapdoors));
    }

    public class_2680 getWoodenPlate(class_2680 input) {
        return this.getFullState(input, this.platesWood);
    }

    public class_2680 getStonePlate(class_2680 input) {
        return this.getFullState(input, this.platesStone);
    }

    public class_2680 getGlassBlock(class_2680 input) {
        return this.getFullState(input, this.glassBlocks);
    }

    public class_2680 getGlassPane(class_2680 input) {
        return this.copyPane(input, this.getRandomBlock(input, this.glassPanes));
    }

    public class_2680 getPot(class_2680 input) {
        return this.getFullState(input, this.pots);
    }

    public class_2680 getPlant(class_2680 input) {
        String seed = class_2378.field_11146.method_10221((Object)input.method_26204()).method_12832();
        RANDOM.method_43052((long)seed.hashCode());
        return (class_2680)NetherBlocks.POTTED_PLANT.method_9564().method_11657(BlockPottedPlant.PLANT, (Comparable)((Object)BNBlockProperties.PottedPlantShape.values()[RANDOM.method_43048(BNBlockProperties.PottedPlantShape.values().length)]));
    }
}

