/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.betterx.bclib.api.v3.levelgen.features.UserGrowableFeature;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BlockPlantWall;
import org.betterx.betternether.blocks.RubeusLog;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.features.NonOverlappingFeature;
import org.betterx.betternether.world.features.configs.NaturalTreeConfiguration;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class RubeusTreeFeature
extends NonOverlappingFeature<NaturalTreeConfiguration>
implements UserGrowableFeature<NaturalTreeConfiguration> {
    private static final float[] CURVE_X = new float[]{9.0f, 7.0f, 1.5f, 0.5f, 3.0f, 7.0f};
    private static final float[] CURVE_Y = new float[]{20.0f, 17.0f, 12.0f, 4.0f, 0.0f, -2.0f};
    private static final int MIDDLE_Y = 10;

    public RubeusTreeFeature() {
        super(NaturalTreeConfiguration.CODEC);
    }

    @Override
    protected boolean isStructure(class_2680 state) {
        return state.method_26204() == NetherBlocks.MAT_RUBEUS.getLog();
    }

    @Override
    protected boolean isGround(class_2680 state) {
        return BlocksHelper.isNetherGround(state);
    }

    @Override
    protected boolean place(class_5425 world, class_2338 pos, class_5819 random, NaturalTreeConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        int length = BlocksHelper.upRay((class_1936)world, pos, 27);
        if (length >= 25) {
            return super.place(world, pos, random, config, MAX_HEIGHT, context);
        }
        return false;
    }

    private void updateSDFFrom(class_2338 bpos, StructureGeneratorThreadContext context) {
        for (int x = -7; x <= 7; ++x) {
            for (int y = -7; y <= 7; ++y) {
                for (int z = -7; z <= 7; ++z) {
                    int dist;
                    if (x == 0 && y == 0 && z == 0 || (dist = Math.abs(x) + Math.abs(y) + Math.abs(z)) > 7) continue;
                    class_2338 blPos = bpos.method_10069(x, y, z);
                    context.LOGS_DIST.merge(blPos, (byte)dist, (oldDist, newDist) -> (byte)Math.min(oldDist.byteValue(), dist));
                }
            }
        }
    }

    private void updateDistances(class_5425 world, StructureGeneratorThreadContext context) {
        for (Map.Entry<class_2338, Byte> entry : context.LOGS_DIST.entrySet()) {
            byte dist = entry.getValue();
            class_2338 logPos = entry.getKey();
            class_2680 currentState = world.method_8320(logPos);
            if (!currentState.method_28498((class_2769)class_2741.field_12541)) continue;
            int cDist = (Integer)currentState.method_11654((class_2769)class_2741.field_12541);
            if (dist < cDist) {
                BlocksHelper.setWithoutUpdate((class_1936)world, logPos, (class_2680)currentState.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(dist)));
                cDist = dist;
            }
            if (cDist < 7) continue;
            BlocksHelper.setWithoutUpdate((class_1936)world, logPos, class_2246.field_10124.method_9564());
        }
    }

    @Override
    public boolean grow(class_5425 world, class_2338 pos, class_5819 random, NaturalTreeConfiguration config, StructureGeneratorThreadContext context) {
        boolean natural = config.natural;
        context.clear();
        world.method_8652(pos, class_2246.field_10124.method_9564(), 0);
        float scale = MHelper.randRange(0.5f, 1.0f, random);
        int minCount = (double)scale < 0.75 ? 3 : 4;
        int maxCount = (double)scale < 0.75 ? 5 : 7;
        int count = MHelper.randRange(minCount, maxCount, random);
        for (int n = 0; n < count; ++n) {
            float branchSize = MHelper.randRange(0.5f, 0.8f, random) * scale;
            float angle = (float)n * ((float)Math.PI * 2) / (float)count;
            float radius = CURVE_X[0] * branchSize;
            int x1 = Math.round((float)pos.method_10263() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int y1 = Math.round((float)pos.method_10264() + CURVE_Y[0] * branchSize + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int z1 = Math.round((float)pos.method_10260() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            float crownR = 5.0f * branchSize;
            if (crownR < 1.5f) {
                crownR = 1.5f;
            }
            this.crown((class_1936)world, x1, y1 + 1, z1, crownR, random);
            int middle = Math.round((float)pos.method_10264() + (float)(10 + MHelper.randRange(-2, 2, random)) * branchSize);
            boolean generate = true;
            for (int i = 1; i < CURVE_X.length && generate; ++i) {
                radius = CURVE_X[i] * branchSize;
                int x2 = Math.round((float)pos.method_10263() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                int y2 = Math.round((float)pos.method_10264() + CURVE_Y[i] * branchSize + (CURVE_Y[i] > 0.0f ? MHelper.randRange(-2.0f, 2.0f, random) * branchSize : 0.0f));
                int z2 = Math.round((float)pos.method_10260() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                if (CURVE_Y[i] <= 0.0f && !this.isGround(world.method_8320((class_2338)context.POS.method_10103(x2, y2, z2)))) {
                    boolean noGround = true;
                    for (int d = 1; d < 3; ++d) {
                        if (!this.isGround(world.method_8320((class_2338)context.POS.method_10103(x2, y2 - d, z2)))) continue;
                        y2 -= d;
                        noGround = false;
                        break;
                    }
                    if (noGround) {
                        x2 = pos.method_10263();
                        y2 = pos.method_10264();
                        generate = false;
                    }
                }
                this.line((class_1936)world, x1, y1, z1, x2, y2, z2, middle, context);
                x1 = x2;
                y1 = y2;
                z1 = z2;
            }
        }
        Iterator<class_2338> iterator = context.TOP.iterator();
        while (iterator.hasNext()) {
            class_2338 bpos = iterator.next();
            if (bpos == null || !context.POINTS.contains(bpos.method_10084()) || context.TOP.contains(bpos.method_10084())) continue;
            iterator.remove();
        }
        iterator = context.MIDDLE.iterator();
        while (iterator.hasNext()) {
            class_2338 bpos = iterator.next();
            if (bpos != null) {
                class_2338 up = bpos.method_10084();
                if (!context.MIDDLE.contains(up) && (context.TOP.contains(up) || !context.POINTS.contains(up))) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        for (class_2338 bpos : context.POINTS) {
            if (context.POINTS.contains(bpos.method_10084()) && context.POINTS.contains(bpos.method_10074())) {
                state = NetherBlocks.MAT_RUBEUS.getLog().method_9564();
                if (context.MIDDLE.contains(bpos)) {
                    this.setCondition((class_1936)world, bpos, pos.method_10264(), (class_2680)state.method_11657(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE), false, random);
                } else if (context.TOP.contains(bpos)) {
                    this.setCondition((class_1936)world, bpos, pos.method_10264(), (class_2680)state.method_11657(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.TOP), false, random);
                } else {
                    this.setCondition((class_1936)world, bpos, pos.method_10264(), (class_2680)state.method_11657(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM), natural, random);
                }
            } else {
                state = NetherBlocks.MAT_RUBEUS.getBark().method_9564();
                if (context.MIDDLE.contains(bpos)) {
                    this.setCondition((class_1936)world, bpos, pos.method_10264(), (class_2680)state.method_11657(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE), false, random);
                } else if (context.TOP.contains(bpos)) {
                    this.setCondition((class_1936)world, bpos, pos.method_10264(), (class_2680)state.method_11657(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.TOP), false, random);
                } else {
                    this.setCondition((class_1936)world, bpos, pos.method_10264(), (class_2680)state.method_11657(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM), natural, random);
                }
            }
            this.updateSDFFrom(bpos, context);
        }
        this.updateDistances(world, context);
        context.LOGS_DIST.clear();
        context.POINTS.clear();
        context.MIDDLE.clear();
        context.TOP.clear();
        return true;
    }

    private void line(class_1936 level, int x1, int y1, int z1, int x2, int y2, int z2, int middleY, StructureGeneratorThreadContext context) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int mx = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        float fdx = (float)dx / (float)mx;
        float fdy = (float)dy / (float)mx;
        float fdz = (float)dz / (float)mx;
        float px = x1;
        float py = y1;
        float pz = z1;
        class_2338 pos = context.POS.method_10103(x1, y1, z1).method_10062();
        context.POINTS.add(pos);
        if (pos.method_10264() == middleY) {
            context.MIDDLE.add(pos);
        } else if (pos.method_10264() > middleY) {
            context.TOP.add(pos);
        }
        pos = context.POS.method_10103(x2, y2, z2).method_10062();
        context.POINTS.add(pos);
        if (pos.method_10264() == middleY) {
            context.MIDDLE.add(pos);
        } else if (pos.method_10264() > middleY) {
            context.TOP.add(pos);
        }
        for (int i = 0; i < mx; ++i) {
            context.POS.method_10103(Math.round(px += fdx), Math.round(py += fdy), Math.round(pz += fdz));
            pos = context.POS.method_10062();
            context.POINTS.add(pos);
            if (context.POS.method_10264() == middleY) {
                context.MIDDLE.add(pos);
                continue;
            }
            if (context.POS.method_10264() <= middleY) continue;
            context.TOP.add(pos);
        }
    }

    private void crown(class_1936 world, int x, int y, int z, float radius, class_5819 random) {
        int start;
        class_2338.class_2339 POS = new class_2338.class_2339();
        class_2680 leaves = (class_2680)NetherBlocks.RUBEUS_LEAVES.method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(true));
        class_2680 cone = NetherBlocks.MAT_RUBEUS.getCone().method_9564();
        float halfR = radius * 0.5f;
        float r2 = radius * radius;
        int cy = start = (int)Math.floor(-radius);
        while ((float)cy <= radius) {
            int cy2_out = cy * cy;
            float cy2_in = (float)cy + halfR;
            cy2_in *= cy2_in;
            POS.method_33098((int)((float)(y + cy) - halfR));
            int cx = start;
            while ((float)cx <= radius) {
                int cx2 = cx * cx;
                POS.method_33097(x + cx);
                int cz = start;
                while ((float)cz <= radius) {
                    int cz2 = cz * cz;
                    if ((float)(cx2 + cy2_out + cz2) < r2 && (float)cx2 + cy2_in + (float)cz2 > r2) {
                        POS.method_33099(z + cz);
                        this.setIfAirLeaves(world, (class_2338)POS, leaves);
                        if ((POS.method_10263() + POS.method_10260() & 1) == 0 && random.method_43048(6) == 0) {
                            this.setIfAir(world, POS.method_10074(), cone);
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
    }

    private void setCondition(class_1936 world, class_2338 pos, int y, class_2680 state, boolean moss, class_5819 random) {
        if (pos.method_10264() > y) {
            this.setIfAir(world, pos, state);
        } else {
            this.setIfGroundOrAir(world, pos, state);
        }
        if (moss && Math.abs(pos.method_10264() - y) < 4) {
            for (class_2350 dir : BlocksHelper.HORIZONTAL) {
                if (random.method_43048(3) <= 0) continue;
                this.setIfAir(world, pos.method_10093(dir), (class_2680)NetherBlocks.JUNGLE_MOSS.method_9564().method_11657((class_2769)BlockPlantWall.FACING, (Comparable)dir));
            }
        }
    }

    private void setIfAir(class_1936 world, class_2338 pos, class_2680 state) {
        class_2680 bState = world.method_8320(pos);
        if ((world.method_22347(pos) || bState.method_26207().method_15800() || bState.method_26204() == NetherBlocks.RUBEUS_LEAVES) && state.method_26184((class_4538)world, pos)) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }

    private void setIfGroundOrAir(class_1936 world, class_2338 pos, class_2680 state) {
        class_2680 bState = world.method_8320(pos);
        if ((bState.method_26215() || bState.method_26204() == NetherBlocks.RUBEUS_LEAVES || bState.method_26207().method_15800() || BlocksHelper.isNetherGround(bState)) && state.method_26184((class_4538)world, pos)) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }

    private void setIfAirLeaves(class_1936 world, class_2338 pos, class_2680 state) {
        class_2680 bState = world.method_8320(pos);
        if (world.method_22347(pos) || bState.method_26207().method_15800()) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }

    public boolean grow(class_5425 level, class_2338 pos, class_5819 random, NaturalTreeConfiguration configuration) {
        return this.grow(level, pos, random, new NaturalTreeConfiguration(false, configuration.distance), NetherThreadDataStorage.generatorForThread().context);
    }
}

