/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_4048;
import net.minecraft.class_5132;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.spawning.SpawnRuleBuilder;
import org.betterx.bclib.config.PathConfig;
import org.betterx.bclib.entity.BCLEntityWrapper;
import org.betterx.bclib.interfaces.SpawnRule;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.entity.EntityChair;
import org.betterx.betternether.entity.EntityFirefly;
import org.betterx.betternether.entity.EntityFlyingPig;
import org.betterx.betternether.entity.EntityHydrogenJellyfish;
import org.betterx.betternether.entity.EntityJungleSkeleton;
import org.betterx.betternether.entity.EntityNaga;
import org.betterx.betternether.entity.EntityNagaProjectile;
import org.betterx.betternether.entity.EntitySkull;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.betternether.world.NetherBiomeConfig;
import org.betterx.ui.ColorUtil;

public class NetherEntities {
    public static final Map<class_1299<? extends class_1297>, class_5132> ATTRIBUTES = Maps.newHashMap();
    private static final List<BCLEntityWrapper<?>> NETHER_ENTITIES = Lists.newArrayList();
    public static final class_1299<EntityChair> CHAIR = FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, EntityChair::new).dimensions(class_4048.method_18385((float)0.5f, (float)0.8f)).fireImmune().disableSummon().build();
    public static final class_1299<EntityNagaProjectile> NAGA_PROJECTILE = FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, EntityNagaProjectile::new).dimensions(class_4048.method_18385((float)1.0f, (float)1.0f)).disableSummon().build();
    public static final BCLEntityWrapper<EntityFirefly> FIREFLY = NetherEntities.register("firefly", class_1311.field_6303, 0.5f, 0.5f, EntityFirefly::new, EntityFirefly.createMobAttributes(), true, ColorUtil.color((int)255, (int)223, (int)168), ColorUtil.color((int)233, (int)182, (int)95));
    public static final BCLEntityWrapper<EntityHydrogenJellyfish> HYDROGEN_JELLYFISH = NetherEntities.register("hydrogen_jellyfish", class_1311.field_6303, 2.0f, 5.0f, EntityHydrogenJellyfish::new, EntityHydrogenJellyfish.createMobAttributes(), false, ColorUtil.color((int)253, (int)164, (int)24), ColorUtil.color((int)88, (int)21, (int)4));
    public static final BCLEntityWrapper<EntityNaga> NAGA = NetherEntities.register("naga", class_1311.field_6302, 0.625f, 2.75f, EntityNaga::new, EntityNaga.createMobAttributes(), true, ColorUtil.color((int)12, (int)12, (int)12), ColorUtil.color((int)210, (int)90, (int)26));
    public static final BCLEntityWrapper<EntityFlyingPig> FLYING_PIG = NetherEntities.register("flying_pig", class_1311.field_6303, 1.0f, 1.25f, EntityFlyingPig::new, EntityFlyingPig.createMobAttributes(), true, ColorUtil.color((int)241, (int)140, (int)93), ColorUtil.color((int)176, (int)58, (int)47));
    public static final BCLEntityWrapper<EntityJungleSkeleton> JUNGLE_SKELETON = NetherEntities.register("jungle_skeleton", class_1311.field_6302, 0.6f, 1.99f, EntityJungleSkeleton::new, EntityJungleSkeleton.method_26918(), true, ColorUtil.color((int)134, (int)162, (int)149), ColorUtil.color((int)6, (int)111, (int)79));
    public static final BCLEntityWrapper<EntitySkull> SKULL = NetherEntities.register("skull", class_1311.field_6302, 0.625f, 0.625f, EntitySkull::new, EntitySkull.createMobAttributes(), true, ColorUtil.color((int)24, (int)19, (int)19), ColorUtil.color((int)255, (int)28, (int)18));
    public static final int MAX_FLOAT_HEIGHT = 7;
    public static final SpawnRule RULE_FLOAT_NOT_ABOVE_LAVA = (type, world, spawnReason, pos, random) -> NetherEntities.testSpawnAboveLava(world, pos, false);
    public static final SpawnRule RULE_FLOAT_ABOVE_LAVA = (type, world, spawnReason, pos, random) -> NetherEntities.testSpawnAboveLava(world, pos, true);

    private static <T extends class_1308> BCLEntityWrapper<T> register(String name, class_1311 group, float width, float height, class_1299.class_4049<T> entity, class_5132.class_5133 attributes, boolean fixedSize, int eggColor, int dotsColor) {
        class_2960 id = BetterNether.makeID(name);
        class_1299 type = FabricEntityTypeBuilder.create((class_1311)group, entity).dimensions(fixedSize ? class_4048.method_18385((float)width, (float)height) : class_4048.method_18384((float)width, (float)height)).fireImmune().build();
        type = (class_1299)class_2378.method_10230((class_2378)class_2378.field_11145, (class_2960)id, (Object)type);
        FabricDefaultAttributeRegistry.register((class_1299)type, (class_5132.class_5133)attributes);
        NetherItems.makeEgg("spawn_egg_" + name, (class_1299<? extends class_1308>)type, eggColor, dotsColor);
        if (Configs.MOBS.getBooleanRoot(id.method_12832(), true)) {
            return new BCLEntityWrapper(type, true);
        }
        BCLEntityWrapper wrapper = new BCLEntityWrapper(type, false);
        NETHER_ENTITIES.add(wrapper);
        return wrapper;
    }

    private static boolean testSpawnAboveLava(class_1936 world, class_2338 pos, boolean allow) {
        int h = BlocksHelper.downRay((class_1936)world, (class_2338)pos, (int)9);
        if (h > 7) {
            return false;
        }
        for (int i = 1; i <= h + 1; ++i) {
            if (!BlocksHelper.isLava((class_2680)world.method_8320(pos.method_10087(i)))) continue;
            return allow;
        }
        return !allow;
    }

    public static void register() {
        NetherEntities.registerEntity("chair", CHAIR, EntityChair.getAttributeContainer());
        NetherEntities.registerEntity("naga_projectile", NAGA_PROJECTILE);
        SpawnRuleBuilder.start(FIREFLY).belowMaxHeight().customRule(RULE_FLOAT_NOT_ABOVE_LAVA).maxNearby(32, 64).buildNoRestrictions(class_2902.class_2903.field_13203);
        SpawnRuleBuilder.start(HYDROGEN_JELLYFISH).belowMaxHeight().maxNearby(24, 64).buildNoRestrictions(class_2902.class_2903.field_13197);
        SpawnRuleBuilder.start(NAGA).hostile(8).maxNearby(32, 64).buildOnGround(class_2902.class_2903.field_13203);
        SpawnRuleBuilder.start(FLYING_PIG).belowMaxHeight().customRule(RULE_FLOAT_NOT_ABOVE_LAVA).maxNearby(16, 64).buildNoRestrictions(class_2902.class_2903.field_13197);
        SpawnRuleBuilder.start(JUNGLE_SKELETON).notPeaceful().maxNearby(16, 64).buildOnGround(class_2902.class_2903.field_13203);
        SpawnRuleBuilder.start(SKULL).belowMaxHeight().vanillaHostile().maxNearby(16, 64).buildNoRestrictions(class_2902.class_2903.field_13197);
    }

    public static void registerEntity(String name, class_1299<? extends class_1309> entity) {
        NetherEntities.registerEntity(name, entity, class_1308.method_26828().method_26866());
    }

    public static void registerEntity(String name, class_1299<? extends class_1297> entity, class_5132 container) {
        class_2378.method_10230((class_2378)class_2378.field_11145, (class_2960)new class_2960("betternether", name), entity);
        ATTRIBUTES.put(entity, container);
    }

    public static boolean isNetherEntity(class_1297 entity) {
        return NETHER_ENTITIES.contains(entity.method_5864());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void modifyNonBNBiome(class_2960 biomeID, class_6880<class_1959> biome) {
        boolean isCrimson = biomeID.equals((Object)class_1972.field_22077.method_29177());
        KnownSpawnTypes.FIREFLY.addSpawn(biomeID, biome, isCrimson ? 3.0f : 1.0f);
        KnownSpawnTypes.HYDROGEN_JELLYFISH.addSpawn(biomeID, biome);
        KnownSpawnTypes.NAGA.addSpawn(biomeID, biome, isCrimson ? 0.0f : 1.0f);
        PathConfig pathConfig = Configs.BIOMES;
        synchronized (pathConfig) {
            Configs.BIOMES.saveChanges();
        }
    }

    public static enum KnownSpawnTypes {
        GHAST(50, 4, 4, class_1299.field_6107),
        ZOMBIFIED_PIGLIN(100, 4, 4, class_1299.field_6050),
        MAGMA_CUBE(2, 4, 4, class_1299.field_6102),
        SKULL(2, 2, 4, SKULL),
        ENDERMAN(1, 4, 4, class_1299.field_6091),
        PIGLIN(15, 4, 4, class_1299.field_22281),
        STRIDER(60, 1, 2, class_1299.field_23214),
        HOGLIN(9, 1, 2, class_1299.field_21973),
        FIREFLY(5, 1, 3, FIREFLY),
        HYDROGEN_JELLYFISH(5, 2, 6, HYDROGEN_JELLYFISH),
        NAGA(8, 3, 5, NAGA),
        FLYING_PIG(20, 2, 4, FLYING_PIG),
        JUNGLE_SKELETON(40, 2, 4, JUNGLE_SKELETON),
        PIGLIN_BRUTE(0, 1, 1, class_1299.field_25751);

        public final int weight;
        public final int minGroupSize;
        public final int maxGroupSize;
        public final class_1299 type;
        public final BCLEntityWrapper wrapper;

        public boolean isVanilla() {
            return this.wrapper == null;
        }

        public void addSpawn(BCLBiomeBuilder builder, NetherBiomeConfig data) {
            String category = data.configGroup() + ".spawn." + this.type.method_5891().method_6133() + "." + this.type.method_5882().replace("entity.", "");
            int weight = Configs.BIOMES.getInt(category, "weight", data.spawnWeight(this));
            int min = Configs.BIOMES.getInt(category, "minGroupSize", this.minGroupSize);
            int max = Configs.BIOMES.getInt(category, "maxGroupSize", this.maxGroupSize);
            if (this.wrapper == null) {
                builder.spawn(this.type, weight, min, max);
            } else {
                builder.spawn(this.wrapper, weight, min, max);
            }
        }

        public void addSpawn(class_2960 ID, class_6880<class_1959> biome, float multiplier) {
            String category = ID.method_12836() + "." + ID.method_12832() + ".spawn." + this.type.method_5891().method_6133() + "." + this.type.method_5882().replace("entity.", "");
            int dweight = Configs.BIOMES.getInt(category, "weight", (int)((float)this.weight * multiplier));
            int min = Configs.BIOMES.getInt(category, "minGroupSize", this.minGroupSize);
            int max = Configs.BIOMES.getInt(category, "maxGroupSize", this.maxGroupSize);
            BiomeAPI.addBiomeMobSpawn(biome, (class_1299)this.type, (int)dweight, (int)min, (int)max);
        }

        public void addSpawn(class_2960 ID, class_6880<class_1959> biome) {
            this.addSpawn(ID, biome, 1.0f);
        }

        private KnownSpawnTypes(int w, int min, int max, class_1299 type) {
            this.weight = w;
            this.minGroupSize = min;
            this.maxGroupSize = max;
            this.type = type;
            this.wrapper = null;
        }

        private <M extends class_1308> KnownSpawnTypes(int w, int min, int max, BCLEntityWrapper type) {
            this.weight = w;
            this.minGroupSize = min;
            this.maxGroupSize = max;
            this.type = type.type();
            this.wrapper = type;
        }
    }
}

