/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.things.mixin;

import com.glisco.things.Things;
import com.glisco.things.items.ThingsItems;
import com.glisco.things.misc.ExtendedStatusEffectInstance;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1292.class})
public class StatusEffectUtilMixin {
    @Unique
    private static final ThreadLocal<class_1309> cachedEntity = new ThreadLocal();

    @Inject(method={"hasHaste"}, at={@At(value="HEAD")}, cancellable=true)
    private static void hasMomentum(class_1309 entity, CallbackInfoReturnable<Boolean> cir) {
        if (entity.method_6059(Things.MOMENTUM)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getHasteAmplifier"}, at={@At(value="HEAD")})
    private static void storeEntity(class_1309 entity, CallbackInfoReturnable<Integer> cir) {
        cachedEntity.set(entity);
    }

    @ModifyVariable(method={"getHasteAmplifier"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;hasStatusEffect(Lnet/minecraft/entity/effect/StatusEffect;)Z", ordinal=1), ordinal=0)
    private static int getMomentumAmplifier(int i) {
        class_1309 entity = cachedEntity.get();
        if (entity.method_6059(Things.MOMENTUM) && entity.method_6059(class_1294.field_5917) && (i += entity.method_6112(Things.MOMENTUM).method_5578()) == 0) {
            ++i;
        }
        cachedEntity.set(null);
        return i;
    }

    @ModifyVariable(method={"durationToString"}, at=@At(value="HEAD"), argsOnly=true)
    private static float extendTime(float multiplier, class_1293 instance, float unused) {
        class_1309 entity = ((ExtendedStatusEffectInstance)instance).things$getAttachedEntity();
        if (entity != null && Things.hasTrinket(entity, ThingsItems.BROKEN_WATCH)) {
            return multiplier * 1.5f;
        }
        return multiplier;
    }
}

