/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.things.misc;

import com.glisco.things.Things;
import com.glisco.things.items.ThingsItems;
import com.glisco.things.items.trinkets.AgglomerationItem;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class AgglomerateRecipe
extends class_1852 {
    public AgglomerateRecipe(class_2960 id) {
        super(id);
    }

    public boolean matches(class_1715 inventory, class_1937 world) {
        int totalItems = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (inventory.method_5438(i).method_7960()) continue;
            ++totalItems;
        }
        if (totalItems != 3) {
            return false;
        }
        if (!AgglomerateRecipe.matchOnce(inventory, stack -> stack.method_31574(ThingsItems.EMPTY_AGGLOMERATION))) {
            return false;
        }
        class_1799 firstStack = AgglomerateRecipe.matchOne(inventory, AgglomerateRecipe::isValidItem);
        if (firstStack == null) {
            return false;
        }
        ArrayList firstValidSlots = new ArrayList();
        TrinketsApi.getPlayerSlots().forEach((groupName, slotGroup) -> slotGroup.getSlots().forEach((slotName, slotType) -> {
            if (firstStack.method_31573(class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960("trinkets", groupName + "/" + slotName)))) {
                firstValidSlots.add(slotType);
            }
        }));
        return AgglomerateRecipe.matchOnce(inventory, stack -> {
            boolean anyCompatibleSlot = false;
            for (SlotType slotType : firstValidSlots) {
                if (!stack.method_31573(class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960("trinkets", slotType.getGroup() + "/" + slotType.getName())))) continue;
                anyCompatibleSlot = true;
            }
            return anyCompatibleSlot && !class_1799.method_7987((class_1799)stack, (class_1799)firstStack) && AgglomerateRecipe.isValidItem(stack);
        });
    }

    private static boolean isValidItem(class_1799 stack) {
        return !stack.method_7960() && !stack.method_31574(ThingsItems.EMPTY_AGGLOMERATION) && !stack.method_31574(ThingsItems.AGGLOMERATION) && TrinketsApi.getTrinket((class_1792)stack.method_7909()) != TrinketsApi.getDefaultTrinket() && !stack.method_31573(Things.AGGLOMERATION_BLACKLIST);
    }

    public class_1799 craft(class_1715 inventory) {
        class_1799 firstTrinket = AgglomerateRecipe.matchOne(inventory, stack -> !stack.method_7960() && !stack.method_31574(ThingsItems.EMPTY_AGGLOMERATION));
        class_1799 secondTrinket = AgglomerateRecipe.matchOne(inventory, stack -> !stack.method_7960() && stack != firstTrinket && !stack.method_31574(ThingsItems.EMPTY_AGGLOMERATION));
        return AgglomerationItem.createStack(firstTrinket, secondTrinket);
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    private static boolean matchOnce(class_1715 inventory, Predicate<class_1799> condition) {
        boolean found = false;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (!condition.test(inventory.method_5438(i))) continue;
            if (found) {
                return false;
            }
            found = true;
        }
        return found;
    }

    private static class_1799 matchOne(class_1715 inventory, Predicate<class_1799> condition) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!condition.test(stack)) continue;
            return stack;
        }
        return null;
    }

    public static class Serializer
    extends class_1866<AgglomerateRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
            super(AgglomerateRecipe::new);
        }
    }
}

