/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.entity.block;

import com.nhoryzon.mc.farmersdelight.FarmersDelightMod;
import com.nhoryzon.mc.farmersdelight.block.SkilletBlock;
import com.nhoryzon.mc.farmersdelight.entity.block.HeatableBlockEntity;
import com.nhoryzon.mc.farmersdelight.entity.block.SyncedBlockEntity;
import com.nhoryzon.mc.farmersdelight.entity.block.inventory.ItemStackHandler;
import com.nhoryzon.mc.farmersdelight.entity.block.inventory.SkilletBlockInventory;
import com.nhoryzon.mc.farmersdelight.mixin.accessors.RecipeManagerAccessorMixin;
import com.nhoryzon.mc.farmersdelight.registry.BlockEntityTypesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.ParticleTypesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.SoundsRegistry;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3920;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class SkilletBlockEntity
extends SyncedBlockEntity
implements HeatableBlockEntity {
    public static final String TAG_KEY_SKILLET_STACK = "Skillet";
    private int cookTime;
    private int cookTimeTotal;
    private final ItemStackHandler inventory;
    private class_2960 lastRecipeID;
    private class_1799 skilletStack = class_1799.field_8037;
    private int fireAspectLevel;

    public SkilletBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(BlockEntityTypesRegistry.SKILLET.get(), blockPos, blockState);
        this.inventory = new SkilletBlockInventory(this);
    }

    public static void cookingTick(class_1937 world, class_2338 pos, class_2680 state, SkilletBlockEntity skillet) {
        boolean isHeated = skillet.isHeated(world, pos);
        if (isHeated) {
            class_1799 cookingStack = skillet.getStoredStack();
            if (cookingStack.method_7960()) {
                skillet.cookTime = 0;
            } else {
                skillet.cookAndOutputItems(cookingStack);
            }
        } else if (skillet.cookTime > 0) {
            skillet.cookTime = class_3532.method_15340((int)(skillet.cookTime - 2), (int)0, (int)skillet.cookTimeTotal);
        }
    }

    public static void animationTick(class_1937 world, class_2338 pos, class_2680 state, SkilletBlockEntity skillet) {
        if (skillet.isHeated(world, pos) && skillet.hasStoredStack()) {
            double z;
            double y;
            double x;
            class_5819 random = world.method_8409();
            if (random.method_43057() < 0.2f) {
                x = (double)pos.method_10263() + 0.5 + (random.method_43058() * 0.4 - 0.2);
                y = (double)pos.method_10264() + 0.1;
                z = (double)pos.method_10260() + 0.5 + (random.method_43058() * 0.4 - 0.2);
                double motionY = random.method_43056() ? 0.015 : 0.005;
                world.method_8406((class_2394)ParticleTypesRegistry.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
            }
            if (skillet.fireAspectLevel > 0 && random.method_43057() < (float)skillet.fireAspectLevel * 0.05f) {
                x = (double)pos.method_10263() + 0.5 + (random.method_43058() * 0.4 - 0.2);
                y = (double)pos.method_10264() + 0.1;
                z = (double)pos.method_10260() + 0.5 + (random.method_43058() * 0.4 - 0.2);
                double motionX = world.field_9229.method_43057() - 0.5f;
                double motionY = world.field_9229.method_43057() * 0.5f + 0.2f;
                double motionZ = world.field_9229.method_43057() - 0.5f;
                world.method_8406((class_2394)class_2398.field_11208, x, y, z, motionX, motionY, motionZ);
            }
        }
    }

    private void cookAndOutputItems(class_1799 cookingStack) {
        class_1277 wrapper;
        Optional<class_3920> recipe;
        if (this.field_11863 == null) {
            return;
        }
        ++this.cookTime;
        if (this.cookTime >= this.cookTimeTotal && (recipe = this.getMatchingRecipe((class_1263)(wrapper = new class_1277(new class_1799[]{cookingStack})))).isPresent()) {
            class_1799 resultStack = recipe.get().method_8116((class_1263)wrapper);
            class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)SkilletBlock.FACING)).method_10170();
            class_1542 entity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.3, (double)this.field_11867.method_10260() + 0.5, resultStack.method_7972());
            entity.method_18800((double)((float)direction.method_10148() * 0.08f), 0.25, (double)((float)direction.method_10165() * 0.08f));
            this.field_11863.method_8649((class_1297)entity);
            this.cookTime = 0;
            this.inventory.extractItemStack(0, 1, false);
        }
    }

    public boolean isCooking() {
        return this.isHeated() && this.hasStoredStack();
    }

    public boolean isHeated() {
        if (this.field_11863 != null) {
            return this.isHeated(this.field_11863, this.field_11867);
        }
        return false;
    }

    private Optional<class_3920> getMatchingRecipe(class_1263 inventory) {
        Optional recipe;
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = (class_1860)((RecipeManagerAccessorMixin)this.field_11863.method_8433()).getAllForType(class_3956.field_17549).get(this.lastRecipeID)) instanceof class_3920) {
            class_3920 campfireRecipe = (class_3920)recipe;
            if (recipe.method_8115(inventory, this.field_11863)) {
                return Optional.of(campfireRecipe);
            }
        }
        if ((recipe = this.field_11863.method_8433().method_8132(class_3956.field_17549, inventory, this.field_11863)).isPresent()) {
            this.lastRecipeID = ((class_3920)recipe.get()).method_8114();
            return recipe;
        }
        return Optional.empty();
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.fromTag(nbt);
    }

    private void fromTag(class_2487 nbt) {
        this.inventory.readNbt(nbt.method_10562("Inventory"));
        this.cookTime = nbt.method_10550("CookTime");
        this.cookTimeTotal = nbt.method_10550("CookTimeTotal");
        this.skilletStack = class_1799.method_7915((class_2487)nbt.method_10562(TAG_KEY_SKILLET_STACK));
        this.fireAspectLevel = class_1890.method_8225((class_1887)class_1893.field_9124, (class_1799)this.skilletStack);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("Inventory", (class_2520)this.inventory.writeNbt(new class_2487()));
        nbt.method_10569("CookTime", this.cookTime);
        nbt.method_10569("CookTimeTotal", this.cookTimeTotal);
        nbt.method_10566(TAG_KEY_SKILLET_STACK, (class_2520)this.skilletStack.method_7953(new class_2487()));
    }

    @Override
    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound);
        return nbtCompound;
    }

    public class_2487 writeSkilletItem(class_2487 nbt) {
        nbt.method_10566(TAG_KEY_SKILLET_STACK, (class_2520)this.skilletStack.method_7953(new class_2487()));
        return nbt;
    }

    public void setSkilletItem(class_1799 stack) {
        this.skilletStack = stack.method_7972();
        this.fireAspectLevel = class_1890.method_8225((class_1887)class_1893.field_9124, (class_1799)stack);
        this.inventoryChanged();
    }

    public class_1799 addItemToCook(class_1799 addedStack, class_1657 player) {
        Optional<class_3920> recipe = this.getMatchingRecipe((class_1263)new class_1277(new class_1799[]{addedStack}));
        if (recipe.isPresent()) {
            this.cookTimeTotal = SkilletBlock.getSkilletCookingTime(recipe.get().method_8167(), this.fireAspectLevel);
            boolean wasEmpty = this.getStoredStack().method_7960();
            class_1799 remainderStack = this.inventory.insertItemStack(0, addedStack.method_7972(), false);
            if (!class_1799.method_7973((class_1799)remainderStack, (class_1799)addedStack)) {
                this.lastRecipeID = recipe.get().method_8114();
                this.cookTime = 0;
                if (wasEmpty && this.field_11863 != null && this.isHeated(this.field_11863, this.field_11867)) {
                    this.field_11863.method_43128(null, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), SoundsRegistry.BLOCK_SKILLET_ADD_FOOD.get(), class_3419.field_15245, 0.8f, 1.0f);
                }
                return remainderStack;
            }
        } else if (player != null) {
            player.method_7353((class_2561)FarmersDelightMod.i18n("block.skillet.invalid_item", new Object[0]), true);
        }
        return addedStack;
    }

    public class_1799 removeItem() {
        return this.inventory.extractItemStack(0, this.getStoredStack().method_7914(), false);
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public class_1799 getStoredStack() {
        return this.inventory.method_5438(0);
    }

    public boolean hasStoredStack() {
        return !this.getStoredStack().method_7960();
    }

    @Override
    public void inventoryChanged() {
        this.method_5431();
        Objects.requireNonNull(this.field_11863).method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }
}

