/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight;

import com.google.gson.GsonBuilder;
import com.nhoryzon.mc.farmersdelight.FarmersDelightMod;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1767;

public final class Configuration {
    public static final int DURATION_VANILLA_SOUP = 6000;
    public static final int DURATION_RABBIT_STEW_JUMP = 200;
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "farmersdelight.json");
    private boolean enableVanillaCropCrates = true;
    private boolean farmersBuyFDCrops = true;
    private boolean wanderingTraderSellsFDItems = true;
    private double richSoilBoostChance = 0.2;
    private double cuttingBoardFortuneBonus = 0.1;
    private boolean enableRopeReeling = true;
    private List<String> canvasSignDarkBackgroundList = Arrays.asList("gray", "purple", "blue", "brown", "green", "red", "black");
    private String defaultTomatoVineRope = "farmersdelight:rope";
    private boolean enableTomatoVineClimbingTaggedRopes = true;
    private boolean vanillaSoupExtraEffects = true;
    private boolean rabbitStewJumpBoost = true;
    private boolean dispenserToolsCuttingBoard = true;
    private boolean enableStackableSoupSize = true;
    private List<String> soupItemList = Arrays.asList("minecraft:mushroom_stew", "minecraft:beetroot_soup", "minecraft:rabbit_stew");
    private boolean overrideAllSoupItems = false;
    private boolean generateFDChestLoot = true;
    private boolean generateVillageCompostHeaps = true;
    private boolean generateWildCabbages = true;
    private int chanceWildCabbages = 30;
    private boolean generateWildBeetroots = true;
    private int chanceWildBeetroots = 30;
    private boolean generateWildPotatoes = true;
    private int chanceWildPotatoes = 100;
    private boolean generateWildOnions = true;
    private int chanceWildOnions = 120;
    private boolean generateWildCarrots = true;
    private int chanceWildCarrots = 120;
    private boolean generateWildTomatoes = true;
    private int chanceWildTomatoes = 100;
    private boolean generateWildRice = true;
    private int chanceWildRice = 20;
    private boolean nourishedHungerOverlay = true;
    private boolean comfortHealthOverlay = true;
    private boolean foodEffectTooltip = true;

    public static Configuration load() {
        Configuration configuration = new Configuration();
        if (!CONFIG_FILE.exists()) {
            Configuration.save(configuration);
        }
        try {
            BufferedReader reader = Files.newBufferedReader(CONFIG_FILE.toPath());
            configuration = (Configuration)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)reader, Configuration.class);
            ((Reader)reader).close();
        }
        catch (IOException e) {
            FarmersDelightMod.LOGGER.error("Error while trying to load configuration file. Default configuration used.", (Throwable)e);
        }
        return configuration;
    }

    public static void save(Configuration config) {
        try {
            BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE.toPath(), new OpenOption[0]);
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)config, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            FarmersDelightMod.LOGGER.error("Error while trying to save configuration file.", (Throwable)e);
        }
    }

    public boolean isEnableVanillaCropCrates() {
        return this.enableVanillaCropCrates;
    }

    public void setEnableVanillaCropCrates(boolean pEnableVanillaCropCrates) {
        this.enableVanillaCropCrates = pEnableVanillaCropCrates;
    }

    public boolean isFarmersBuyFDCrops() {
        return this.farmersBuyFDCrops;
    }

    public void setFarmersBuyFDCrops(boolean pFarmersBuyFDCrops) {
        this.farmersBuyFDCrops = pFarmersBuyFDCrops;
    }

    public boolean isWanderingTraderSellsFDItems() {
        return this.wanderingTraderSellsFDItems;
    }

    public void setWanderingTraderSellsFDItems(boolean pWanderingTraderSellsFDItems) {
        this.wanderingTraderSellsFDItems = pWanderingTraderSellsFDItems;
    }

    public double getRichSoilBoostChance() {
        return this.richSoilBoostChance;
    }

    public void setRichSoilBoostChance(double pRichSoilBoostChance) {
        this.richSoilBoostChance = Configuration.limit(0.2, 1.0, pRichSoilBoostChance);
    }

    public double getCuttingBoardFortuneBonus() {
        return this.cuttingBoardFortuneBonus;
    }

    public void setCuttingBoardFortuneBonus(double pCuttingBoardFortuneBonus) {
        this.cuttingBoardFortuneBonus = Configuration.limit(0.1, 1.0, pCuttingBoardFortuneBonus);
    }

    public boolean isEnableRopeReeling() {
        return this.enableRopeReeling;
    }

    public void setEnableRopeReeling(boolean pEnableRopeReeling) {
        this.enableRopeReeling = pEnableRopeReeling;
    }

    public List<String> getCanvasSignDarkBackgroundList() {
        return this.canvasSignDarkBackgroundList;
    }

    public List<class_1767> getCanvasSignDarkBackgroundDyeList() {
        return this.getCanvasSignDarkBackgroundList().stream().map(s -> class_1767.method_7793((String)s, null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void setCanvasSignDarkBackgroundList(List<String> pCanvasSignDarkBackgroundList) {
        this.canvasSignDarkBackgroundList = pCanvasSignDarkBackgroundList == null ? new ArrayList<String>() : pCanvasSignDarkBackgroundList.stream().filter(s -> class_1767.method_7793((String)s, null) != null).collect(Collectors.toList());
    }

    public String getDefaultTomatoVineRope() {
        return this.defaultTomatoVineRope;
    }

    public void setDefaultTomatoVineRope(String pDefaultTomatoVineRope) {
        this.defaultTomatoVineRope = pDefaultTomatoVineRope;
    }

    public boolean isEnableTomatoVineClimbingTaggedRopes() {
        return this.enableTomatoVineClimbingTaggedRopes;
    }

    public void setEnableTomatoVineClimbingTaggedRopes(boolean pEnableTomatoVineClimbingTaggedRopes) {
        this.enableTomatoVineClimbingTaggedRopes = pEnableTomatoVineClimbingTaggedRopes;
    }

    public boolean isVanillaSoupExtraEffects() {
        return this.vanillaSoupExtraEffects;
    }

    public void setVanillaSoupExtraEffects(boolean pVanillaSoupExtraEffects) {
        this.vanillaSoupExtraEffects = pVanillaSoupExtraEffects;
    }

    public boolean isRabbitStewJumpBoost() {
        return this.rabbitStewJumpBoost;
    }

    public void setRabbitStewJumpBoost(boolean pRabbitStewJumpBoost) {
        this.rabbitStewJumpBoost = pRabbitStewJumpBoost;
    }

    public boolean isDispenserToolsCuttingBoard() {
        return this.dispenserToolsCuttingBoard;
    }

    public void setDispenserToolsCuttingBoard(boolean pDispenserToolsCuttingBoard) {
        this.dispenserToolsCuttingBoard = pDispenserToolsCuttingBoard;
    }

    public boolean isEnableStackableSoupSize() {
        return this.enableStackableSoupSize;
    }

    public void setEnableStackableSoupSize(boolean pEnableStackableSoupSize) {
        this.enableStackableSoupSize = pEnableStackableSoupSize;
    }

    public List<String> getSoupItemList() {
        return this.soupItemList;
    }

    public void setSoupItemList(List<String> pSoupItemList) {
        this.soupItemList = pSoupItemList;
    }

    public boolean isOverrideAllSoupItems() {
        return this.overrideAllSoupItems;
    }

    public void setOverrideAllSoupItems(boolean pOverrideAllSoupItems) {
        this.overrideAllSoupItems = pOverrideAllSoupItems;
    }

    public boolean isGenerateFDChestLoot() {
        return this.generateFDChestLoot;
    }

    public void setGenerateFDChestLoot(boolean pGenerateFDChestLoot) {
        this.generateFDChestLoot = pGenerateFDChestLoot;
    }

    public boolean isGenerateVillageCompostHeaps() {
        return this.generateVillageCompostHeaps;
    }

    public void setGenerateVillageCompostHeaps(boolean pGenerateVillageCompostHeaps) {
        this.generateVillageCompostHeaps = pGenerateVillageCompostHeaps;
    }

    public boolean isGenerateWildCabbages() {
        return this.generateWildCabbages;
    }

    public void setGenerateWildCabbages(boolean pGenerateWildCabbages) {
        this.generateWildCabbages = pGenerateWildCabbages;
    }

    public int getChanceWildCabbages() {
        return this.chanceWildCabbages;
    }

    public void setChanceWildCabbages(int pChanceWildCabbages) {
        this.chanceWildCabbages = Configuration.limit(0, Integer.MAX_VALUE, pChanceWildCabbages);
    }

    public boolean isGenerateWildBeetroots() {
        return this.generateWildBeetroots;
    }

    public void setGenerateWildBeetroots(boolean pGenerateWildBeetroots) {
        this.generateWildBeetroots = pGenerateWildBeetroots;
    }

    public int getChanceWildBeetroots() {
        return this.chanceWildBeetroots;
    }

    public void setChanceWildBeetroots(int pChanceWildBeetroots) {
        this.chanceWildBeetroots = Configuration.limit(0, Integer.MAX_VALUE, pChanceWildBeetroots);
    }

    public boolean isGenerateWildPotatoes() {
        return this.generateWildPotatoes;
    }

    public void setGenerateWildPotatoes(boolean pGenerateWildPotatoes) {
        this.generateWildPotatoes = pGenerateWildPotatoes;
    }

    public int getChanceWildPotatoes() {
        return this.chanceWildPotatoes;
    }

    public void setChanceWildPotatoes(int pChanceWildPotatoes) {
        this.chanceWildPotatoes = Configuration.limit(0, Integer.MAX_VALUE, pChanceWildPotatoes);
    }

    public boolean isGenerateWildOnions() {
        return this.generateWildOnions;
    }

    public void setGenerateWildOnions(boolean pGenerateWildOnions) {
        this.generateWildOnions = pGenerateWildOnions;
    }

    public int getChanceWildOnions() {
        return this.chanceWildOnions;
    }

    public void setChanceWildOnions(int pChanceWildOnions) {
        this.chanceWildOnions = Configuration.limit(0, Integer.MAX_VALUE, pChanceWildOnions);
    }

    public boolean isGenerateWildCarrots() {
        return this.generateWildCarrots;
    }

    public void setGenerateWildCarrots(boolean pGenerateWildCarrots) {
        this.generateWildCarrots = pGenerateWildCarrots;
    }

    public int getChanceWildCarrots() {
        return this.chanceWildCarrots;
    }

    public void setChanceWildCarrots(int pChanceWildCarrots) {
        this.chanceWildCarrots = Configuration.limit(0, Integer.MAX_VALUE, pChanceWildCarrots);
    }

    public boolean isGenerateWildTomatoes() {
        return this.generateWildTomatoes;
    }

    public void setGenerateWildTomatoes(boolean pGenerateWildTomatoes) {
        this.generateWildTomatoes = pGenerateWildTomatoes;
    }

    public int getChanceWildTomatoes() {
        return this.chanceWildTomatoes;
    }

    public void setChanceWildTomatoes(int pChanceWildTomatoes) {
        this.chanceWildTomatoes = Configuration.limit(0, Integer.MAX_VALUE, pChanceWildTomatoes);
    }

    public boolean isGenerateWildRice() {
        return this.generateWildRice;
    }

    public void setGenerateWildRice(boolean pGenerateWildRice) {
        this.generateWildRice = pGenerateWildRice;
    }

    public int getChanceWildRice() {
        return this.chanceWildRice;
    }

    public void setChanceWildRice(int pChanceWildRice) {
        this.chanceWildRice = Configuration.limit(0, Integer.MAX_VALUE, pChanceWildRice);
    }

    public boolean isNourishedHungerOverlay() {
        return this.nourishedHungerOverlay;
    }

    public void setNourishedHungerOverlay(boolean pNourishedHungerOverlay) {
        this.nourishedHungerOverlay = pNourishedHungerOverlay;
    }

    public boolean isComfortHealthOverlay() {
        return this.comfortHealthOverlay;
    }

    public void setComfortHealthOverlay(boolean pComfortHealthOverlay) {
        this.comfortHealthOverlay = pComfortHealthOverlay;
    }

    public boolean isFoodEffectTooltip() {
        return this.foodEffectTooltip;
    }

    public void setFoodEffectTooltip(boolean pFoodEffectTooltip) {
        this.foodEffectTooltip = pFoodEffectTooltip;
    }

    private static double limit(double min, double max, double value) {
        if (value > max) {
            return max;
        }
        return Math.max(value, min);
    }

    private static int limit(int min, int max, int value) {
        if (value > max) {
            return max;
        }
        return Math.max(value, min);
    }
}

