/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.integration.voicechat;

import com.sonicether.soundphysics.SoundPhysics;
import com.sonicether.soundphysics.SoundPhysicsMod;
import com.sonicether.soundphysics.integration.voicechat.AudioChannel;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.audiochannel.ClientLocationalAudioChannel;
import de.maxhenkel.voicechat.api.events.ClientSoundEvent;
import de.maxhenkel.voicechat.api.events.ClientVoicechatConnectionEvent;
import de.maxhenkel.voicechat.api.events.CreateOpenALContextEvent;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.OpenALSoundEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_310;
import org.lwjgl.openal.EXTThreadLocalContext;

@ForgeVoicechatPlugin
public class SimpleVoiceChatPlugin
implements VoicechatPlugin {
    private static final UUID OWN_VOICE_ID = UUID.randomUUID();
    private final Map<UUID, AudioChannel> audioChannels = new HashMap<UUID, AudioChannel>();
    private ClientLocationalAudioChannel locationalAudioChannel;

    public String getPluginId() {
        return "sound_physics_remastered";
    }

    public void initialize(VoicechatApi api) {
        SoundPhysics.LOGGER.info("Initializing Simple Voice Chat integration");
        this.audioChannels.clear();
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(CreateOpenALContextEvent.class, this::onCreateALContext);
        registration.registerEvent(OpenALSoundEvent.class, this::onOpenALSound);
        registration.registerEvent(ClientVoicechatConnectionEvent.class, this::onConnection);
        registration.registerEvent(ClientSoundEvent.class, this::onClientSound);
    }

    private void onClientSound(ClientSoundEvent event) {
        if (this.locationalAudioChannel == null) {
            return;
        }
        if (!SoundPhysicsMod.CONFIG.hearSelf.get().booleanValue()) {
            return;
        }
        class_243 position = class_310.method_1551().field_1724.method_19538();
        this.locationalAudioChannel.setLocation(event.getVoicechat().createPosition(position.field_1352, position.field_1351, position.field_1350));
        this.locationalAudioChannel.play(event.getRawAudio());
    }

    private void onCreateALContext(CreateOpenALContextEvent event) {
        long oldContext = EXTThreadLocalContext.alcGetThreadContext();
        EXTThreadLocalContext.alcSetThreadContext((long)event.getContext());
        SoundPhysics.LOGGER.info("Initializing sound physics for voice chat audio");
        SoundPhysics.init();
        EXTThreadLocalContext.alcSetThreadContext((long)oldContext);
    }

    private void onConnection(ClientVoicechatConnectionEvent event) {
        SoundPhysics.DEBUG_LOGGER.info("Clearing unused audio channels");
        this.audioChannels.values().removeIf(AudioChannel::canBeRemoved);
        this.locationalAudioChannel = event.getVoicechat().createLocationalAudioChannel(OWN_VOICE_ID, event.getVoicechat().createPosition(0.0, 0.0, 0.0));
    }

    private void onOpenALSound(OpenALSoundEvent event) {
        if (!SoundPhysicsMod.CONFIG.simpleVoiceChatIntegration.get().booleanValue()) {
            return;
        }
        Position position = event.getPosition();
        UUID channelId = event.getChannelId();
        if (channelId == null) {
            return;
        }
        boolean auxOnly = SoundPhysicsMod.CONFIG.hearSelf.get() != false && OWN_VOICE_ID.equals(channelId);
        AudioChannel audioChannel = this.audioChannels.get(channelId);
        if (audioChannel == null) {
            audioChannel = new AudioChannel(channelId);
            this.audioChannels.put(channelId, audioChannel);
        }
        audioChannel.onSound(event.getSource(), position == null ? null : new class_243(position.getX(), position.getY(), position.getZ()), auxOnly);
    }
}

