/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.world.gen.carver;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.id.paradiselost.world.gen.carver.CloudCarverConfig;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2939;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_5873;
import net.minecraft.class_6350;
import net.minecraft.class_6643;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class CloudCarver
extends class_2939<CloudCarverConfig> {
    public CloudCarver(Codec<CloudCarverConfig> configCodec) {
        super(configCodec);
    }

    private static boolean isPositionExcluded(double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ) {
        return scaledRelativeX * scaledRelativeX + scaledRelativeY * scaledRelativeY + scaledRelativeZ * scaledRelativeZ >= 0.85;
    }

    public boolean carve(class_5873 context, CloudCarverConfig config, class_2791 chunk, Function<class_2338, class_6880<class_1959>> posToBiome, class_5819 random, class_6350 sampler, class_1923 pos, class_6643 carvingMask) {
        int mainChunkX = chunk.method_12004().field_9181;
        int mainChunkZ = chunk.method_12004().field_9180;
        double x = pos.method_33939(16);
        double y = config.field_31488.method_35391(random, (class_5868)context);
        double z = pos.method_33941(16);
        int size = (int)Math.round((double)(7 * (random.method_43048(4) + 1) * config.sizeMultiplier.method_35008(random)) * 1.5);
        int systemCount = 1;
        for (int i = 0; i < systemCount; ++i) {
            int tunnelCount = 1;
            float yawToPitchRatio = random.method_43057() / 4.0f + 0.4f;
            for (int j = 0; j < tunnelCount; ++j) {
                float yaw = (float)((double)random.method_43057() * Math.PI - 1.5707963267948966) * config.yawMultiplier.method_33920(random);
                float pitch = (float)((double)random.method_43057() * Math.PI - 1.5707963267948966) / 2.0f;
                float width = random.method_43057() * 2.0f + random.method_43057() * 3.0f + 4.5f;
                if (random.method_43048(config.engorgementChance.method_35008(random)) == 0) {
                    width *= random.method_43057() * random.method_43057() * 1.5f + 1.0f;
                }
                int maxBranches = size - random.method_43048(size / 4);
                this.carveTunnels(context, config, chunk, posToBiome, carvingMask, random.method_43055(), sampler, mainChunkX, mainChunkZ, x, y, z, width *= config.widthMultiplier.method_33920(random), yaw, pitch, yawToPitchRatio, 0, maxBranches, (context1, scaledRelativeX, scaledRelativeY, scaledRelativeZ, y1) -> CloudCarver.isPositionExcluded(scaledRelativeX, scaledRelativeY, scaledRelativeZ));
            }
        }
        return true;
    }

    protected void carveTunnels(class_5873 context, CloudCarverConfig config, class_2791 chunk, Function<class_2338, class_6880<class_1959>> posToBiome, class_6643 carvingMask, long seed, class_6350 sampler, int mainChunkX, int mainChunkZ, double x, double y, double z, float width, float yaw, float pitch, float yawToPitchRatio, int branchStartIndex, int branchCount, class_2939.class_5874 skipPredicate) {
        class_5819 random = class_5819.method_43049((long)seed);
        int nextBranch = random.method_43048(branchCount / 2) + branchCount / 4;
        boolean steeperCave = random.method_43048(6) == 0;
        float yawChange = 0.0f;
        float pitchChange = 0.0f;
        for (int i = branchStartIndex; i < branchCount; ++i) {
            double scaledYaw = 1.5 + (double)(class_3532.method_15374((float)((float)Math.PI * (float)i / (float)branchCount)) * width);
            double scaledPitch = scaledYaw * (double)yawToPitchRatio;
            float delta = class_3532.method_15362((float)pitch);
            x += (double)(class_3532.method_15362((float)yaw) * delta);
            y += (double)class_3532.method_15374((float)pitch);
            z += (double)(class_3532.method_15374((float)yaw) * delta);
            pitch *= steeperCave ? 0.82f : 0.65f;
            pitch += pitchChange * 0.1f;
            yaw += yawChange * 0.1f;
            pitchChange *= 0.9f;
            yawChange *= 0.75f;
            pitchChange += (random.method_43057() - random.method_43057()) * random.method_43057();
            yawChange += (random.method_43057() - random.method_43057()) * random.method_43057() * random.method_43057() * config.maxYaw.method_33920(random);
            if (i == nextBranch && width > 1.0f && random.method_43056()) {
                return;
            }
            if (random.method_43048(4) == 0) continue;
            this.method_33978(context, config, chunk, posToBiome, sampler, x, y, z, scaledYaw, scaledPitch, carvingMask, skipPredicate);
        }
    }

    public boolean shouldCarve(CloudCarverConfig config, class_5819 random) {
        return random.method_43057() <= config.field_13738;
    }

    @Nullable
    protected class_2680 getState(class_5873 context, CloudCarverConfig config, class_2338 pos, class_6350 sampler) {
        return config.cloudState;
    }
}

