/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.world.feature.tree.placers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.id.paradiselost.world.feature.tree.ParadiseLostTreeHell;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import net.minecraft.class_5863;
import net.minecraft.class_6017;

public class WisteriaTrunkPlacer
extends class_5141 {
    public static final Codec<WisteriaTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6017.field_29946.fieldOf("maxBranchRange").forGetter(placer -> placer.maxBranchRange), (App)class_6017.field_29946.fieldOf("branchCount").forGetter(placer -> placer.branchCount), (App)class_5863.field_29007.fieldOf("branchRange").forGetter(placer -> placer.branchRange), (App)class_5863.field_29007.fieldOf("branchHeight").forGetter(placer -> placer.branchHeight), (App)Codec.INT.fieldOf("base_height").forGetter(placer -> placer.field_23760), (App)Codec.INT.fieldOf("height_rand_a").forGetter(placer -> placer.field_23761), (App)Codec.INT.fieldOf("height_rand_b").forGetter(placer -> placer.field_23762)).apply((Applicative)instance, WisteriaTrunkPlacer::new));
    private final class_6017 maxBranchRange;
    private final class_6017 branchCount;
    private final class_5863 branchHeight;
    private final class_5863 branchRange;
    private static final class_2350[] directions = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};

    public WisteriaTrunkPlacer(class_6017 maxBranchRange, class_6017 branchCount, class_5863 branchRange, class_5863 branchHeight, int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.maxBranchRange = maxBranchRange;
        this.branchCount = branchCount;
        this.branchHeight = branchHeight;
        this.branchRange = branchRange;
    }

    protected class_5142<?> method_28903() {
        return ParadiseLostTreeHell.WISTERIA_TRUNK;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        ArrayList<class_4647.class_5208> nodes = new ArrayList<class_4647.class_5208>();
        int firstHeight = random.method_43048(this.field_23760) + this.field_23760 / 2 + 1;
        for (int i = 0; i <= firstHeight + 1; ++i) {
            this.method_35375(world, replacer, random, startPos.method_10086(i), config);
        }
        class_2338 trunkTop = startPos.method_10086(firstHeight - 2);
        nodes.add(new class_4647.class_5208(trunkTop.method_10086(3), 0, false));
        int yOffset = 0;
        for (int i = 0; i < this.branchCount.method_35008(random); ++i) {
            int offset;
            class_2350 dir2;
            int previous = 0;
            float a = this.branchHeight.method_33920(random);
            float b = this.branchRange.method_33920(random);
            class_2350 dir = this.randomDirection(random);
            class_2350 class_23502 = dir2 = random.method_43056() ? dir.method_10170() : dir.method_10160();
            for (offset = 1; offset <= this.maxBranchRange.method_35011() && (yOffset = this.trunkFunc(offset, a, b)) >= 1; ++offset) {
                if (previous == yOffset) {
                    this.method_35375(world, replacer, random, trunkTop.method_10086(yOffset).method_10079(dir, offset).method_10079(dir2, offset / 2), config);
                } else {
                    for (int y = previous + 1; y <= yOffset; ++y) {
                        this.method_35375(world, replacer, random, trunkTop.method_10086(y).method_10079(dir, offset).method_10079(dir2, offset / 2), config);
                    }
                }
                previous = yOffset;
            }
            trunkTop = trunkTop.method_10084();
            nodes.add(new class_4647.class_5208(trunkTop.method_10086(previous - 1).method_10079(dir, offset - 2).method_10079(dir2, offset / 4), 0, false));
        }
        return nodes;
    }

    private int trunkFunc(float x, float a, float b) {
        return (int)Math.ceil(-Math.log(2.0f * a / x - b) + 3.0);
    }

    private class_2350 randomDirection(class_5819 random) {
        return directions[random.method_43048(directions.length)];
    }
}

