/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.world.dimension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.id.paradiselost.ParadiseLost;
import net.id.paradiselost.entities.ParadiseLostEntityTypes;
import net.id.paradiselost.world.feature.placed_features.ParadiseLostMiscPlacedFeatures;
import net.id.paradiselost.world.feature.placed_features.ParadiseLostTreePlacedFeatures;
import net.id.paradiselost.world.feature.placed_features.ParadiseLostVegetationPlacedFeatures;
import net.id.paradiselost.world.gen.carver.ParadiseLostCarvers;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5463;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6796;
import net.minecraft.class_6814;
import net.minecraft.class_6880;

public final class ParadiseLostBiomes {
    public static final class_5321<class_1959> AUTUMNAL_TUNDRA_KEY = ParadiseLostBiomes.register("autumnal_tundra");
    public static final class_5321<class_1959> CONTINENTAL_PLATEAU_KEY = ParadiseLostBiomes.register("continental_plateau");
    public static final class_5321<class_1959> HIGHLANDS_PLAINS_KEY = ParadiseLostBiomes.register("highlands");
    public static final class_5321<class_1959> HIGHLANDS_FOREST_KEY = ParadiseLostBiomes.register("highlands_forest");
    public static final class_5321<class_1959> HIGHLANDS_GRAND_GLADE_KEY = ParadiseLostBiomes.register("highlands_grand_glade");
    public static final class_5321<class_1959> HIGHLANDS_SHIELD_KEY = ParadiseLostBiomes.register("highlands_shield");
    public static final class_5321<class_1959> HIGHLANDS_THICKET_KEY = ParadiseLostBiomes.register("highlands_thicket");
    public static final class_5321<class_1959> TRADEWINDS_KEY = ParadiseLostBiomes.register("tradewinds");
    public static final class_5321<class_1959> WISTERIA_WOODS_KEY = ParadiseLostBiomes.register("wisteria_woods");
    public static final class_6880<class_1959> AUTUMNAL_TUNDRA = ParadiseLostBiomes.register(AUTUMNAL_TUNDRA_KEY, ParadiseLostBiomes.createAutumnalTundra());
    public static final class_6880<class_1959> CONTINENTAL_PLATEAU = ParadiseLostBiomes.register(CONTINENTAL_PLATEAU_KEY, ParadiseLostBiomes.createContinentalPlateau());
    public static final class_6880<class_1959> HIGHLANDS_PLAINS = ParadiseLostBiomes.register(HIGHLANDS_PLAINS_KEY, ParadiseLostBiomes.createHighlandsPlains());
    public static final class_6880<class_1959> HIGHLANDS_FOREST = ParadiseLostBiomes.register(HIGHLANDS_FOREST_KEY, ParadiseLostBiomes.createHighlandsForest());
    public static final class_6880<class_1959> HIGHLANDS_GRAND_GLADE = ParadiseLostBiomes.register(HIGHLANDS_GRAND_GLADE_KEY, ParadiseLostBiomes.createHighlandsGrandGlade());
    public static final class_6880<class_1959> HIGHLANDS_SHIELD = ParadiseLostBiomes.register(HIGHLANDS_SHIELD_KEY, ParadiseLostBiomes.createHighlandsShield());
    public static final class_6880<class_1959> HIGHLANDS_THICKET = ParadiseLostBiomes.register(HIGHLANDS_THICKET_KEY, ParadiseLostBiomes.createHighlandsThicket());
    public static final class_6880<class_1959> TRADEWINDS = ParadiseLostBiomes.register(TRADEWINDS_KEY, ParadiseLostBiomes.createTradewinds());
    public static final class_6880<class_1959> WISTERIA_WOODS = ParadiseLostBiomes.register(WISTERIA_WOODS_KEY, ParadiseLostBiomes.createWisteriaWoods());

    public static void init() {
    }

    private static class_5321<class_1959> register(String name) {
        return class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)ParadiseLost.locate(name));
    }

    private static class_6880<class_1959> register(class_5321<class_1959> key, class_1959 biome) {
        return class_5458.method_39203((class_2378)class_5458.field_25933, key, (Object)biome);
    }

    private static class_4763 createBiomeEffects(int skyColor, int foliageColor, int grassColor, int fogColor, int waterColor, int waterFogColor, class_4763.class_5486 grassModifier) {
        return new class_4763.class_4764().method_30820(skyColor).method_30821(foliageColor).method_30822(grassColor).method_24392(fogColor).method_24395(waterColor).method_24397(waterFogColor).method_30818(grassModifier).method_24391();
    }

    private static class_4763 createBiomeEffects(int skyColor, int foliageColor, int grassColor, int fogColor, int waterColor, int waterFogColor) {
        return ParadiseLostBiomes.createBiomeEffects(skyColor, foliageColor, grassColor, fogColor, waterColor, waterFogColor, class_4763.class_5486.field_26426);
    }

    private static class_5485 createGenerationSettings(Map<class_2893.class_2894, List<class_6880<? extends class_2922<?>>>> carvers, Map<class_2893.class_2895, List<class_6880<class_6796>>> features) {
        class_5485.class_5495 builder = new class_5485.class_5495();
        for (class_2893.class_2894 class_28942 : class_2893.class_2894.values()) {
            for (class_6880 carver : carvers.getOrDefault(class_28942, List.of())) {
                builder.method_30991(class_28942, carver);
            }
        }
        for (class_2893.class_2894 class_28943 : class_2893.class_2895.values()) {
            for (class_6880 feature : features.getOrDefault(class_28943, List.of())) {
                builder.method_30992((class_2893.class_2895)class_28943, feature);
            }
        }
        return builder.method_30987();
    }

    private static class_5483 createSpawnSettings(Map<class_1311, List<class_5483.class_1964>> spawns, Map<class_1299<?>, SpawnCost> costs) {
        class_5483.class_5496 builder = new class_5483.class_5496();
        for (class_1311 group : class_1311.values()) {
            for (class_5483.class_1964 spawn : spawns.getOrDefault(group, List.of())) {
                builder.method_31011(group, spawn);
            }
        }
        for (Map.Entry entry : costs.entrySet()) {
            SpawnCost cost = (SpawnCost)entry.getValue();
            builder.method_31009((class_1299)entry.getKey(), cost.charge(), cost.energyBudget());
        }
        return builder.method_31007();
    }

    @SafeVarargs
    public static <A, B> Map<A, List<B>> merge(Map<A, List<B>> ... maps) {
        if (maps.length == 1) {
            return maps[0];
        }
        HashMap<Object, List> result = new HashMap<Object, List>();
        for (Map<A, List<B>> map : maps) {
            for (Map.Entry<A, List<B>> entry : map.entrySet()) {
                result.computeIfAbsent(entry.getKey(), ignored -> new ArrayList()).addAll((Collection)entry.getValue());
            }
        }
        return result;
    }

    private static Map<class_2893.class_2894, List<class_6880<? extends class_2922<?>>>> getParadiseLostCarvers() {
        return Map.of(class_2893.class_2894.field_13169, List.of(class_5463.field_33119, ParadiseLostCarvers.LARGE_COLD_CLOUD_CARVER, ParadiseLostCarvers.COLD_CLOUD_CARVER, ParadiseLostCarvers.TINY_COLD_CLOUD_CARVER, ParadiseLostCarvers.LARGE_BLUE_CLOUD_CARVER, ParadiseLostCarvers.BLUE_CLOUD_CARVER, ParadiseLostCarvers.TINY_BLUE_CLOUD_CARVER, ParadiseLostCarvers.LARGE_GOLDEN_CLOUD_CARVER, ParadiseLostCarvers.GOLDEN_CLOUD_CARVER, ParadiseLostCarvers.TINY_GOLDEN_CLOUD_CARVER));
    }

    private static Map<class_2893.class_2895, List<class_6880<class_6796>>> getStandardParadiseLostFeatures() {
        return Map.of(class_2893.class_2895.field_13176, List.of(ParadiseLostMiscPlacedFeatures.ORE_CHERINE, ParadiseLostMiscPlacedFeatures.ORE_OLVITE), class_2893.class_2895.field_13178, List.of(ParadiseLostVegetationPlacedFeatures.PATCH_BROWN_SPORECAP, ParadiseLostVegetationPlacedFeatures.PATCH_PINK_SPORECAP, ParadiseLostVegetationPlacedFeatures.NATURAL_SWEDROOT));
    }

    private static class_1959 createHighlandsPlains() {
        return new class_1959.class_1960().method_24379(ParadiseLostBiomes.createBiomeEffects(0xC0C0FF, 0xF1FF99, 11131845, 0xFFFFFF, 5826047, 6547455)).method_30973(ParadiseLostBiomes.createGenerationSettings(ParadiseLostBiomes.getParadiseLostCarvers(), ParadiseLostBiomes.merge(ParadiseLostBiomes.getStandardParadiseLostFeatures(), Map.of(class_2893.class_2895.field_13171, List.of(ParadiseLostMiscPlacedFeatures.PLAINS_BOULDER), class_2893.class_2895.field_35182, List.of(ParadiseLostMiscPlacedFeatures.WATER_SPRING), class_2893.class_2895.field_13178, List.of(ParadiseLostVegetationPlacedFeatures.FLOWERS, ParadiseLostVegetationPlacedFeatures.GRASS, ParadiseLostVegetationPlacedFeatures.TALL_GRASS, ParadiseLostVegetationPlacedFeatures.PATCH_BLACKCURRANT, ParadiseLostTreePlacedFeatures.SPARSE_TREES))))).method_30974(ParadiseLostBiomes.createSpawnSettings(ParadiseLostBiomes.merge(Map.of(class_1311.field_6294, List.of(new class_5483.class_1964(ParadiseLostEntityTypes.PARADISE_HARE, 12, 4, 4), new class_5483.class_1964(ParadiseLostEntityTypes.MOA, 6, 5, 13)))), Map.of())).method_8735(class_1959.class_1963.field_9382).method_8747(0.5f).method_8727(1.0f).method_30972();
    }

    private static class_1959 createHighlandsForest() {
        return new class_1959.class_1960().method_24379(ParadiseLostBiomes.createBiomeEffects(0xC0C0FF, 0xF1FF99, 10673090, 0xFFFFFF, 5826047, 6547455)).method_30973(ParadiseLostBiomes.createGenerationSettings(ParadiseLostBiomes.getParadiseLostCarvers(), ParadiseLostBiomes.merge(ParadiseLostBiomes.getStandardParadiseLostFeatures(), Map.of(class_2893.class_2895.field_13171, List.of(), class_2893.class_2895.field_35182, List.of(ParadiseLostMiscPlacedFeatures.WATER_SPRING), class_2893.class_2895.field_13178, List.of(ParadiseLostVegetationPlacedFeatures.FLOWERS, ParadiseLostVegetationPlacedFeatures.TALL_GRASS, ParadiseLostVegetationPlacedFeatures.TUNDRA_FOLIAGE, ParadiseLostVegetationPlacedFeatures.BUSH, ParadiseLostVegetationPlacedFeatures.PATCH_BLACKCURRANT, ParadiseLostTreePlacedFeatures.SCATTERED_TREES, ParadiseLostTreePlacedFeatures.ALT_FALLEN_LEAVES))))).method_30974(ParadiseLostBiomes.createSpawnSettings(ParadiseLostBiomes.merge(Map.of(class_1311.field_6294, List.of(new class_5483.class_1964(ParadiseLostEntityTypes.PARADISE_HARE, 12, 4, 4), new class_5483.class_1964(ParadiseLostEntityTypes.MOA, 6, 3, 7)))), Map.of())).method_8735(class_1959.class_1963.field_9382).method_8747(0.5f).method_8727(1.0f).method_30972();
    }

    private static class_1959 createTradewinds() {
        return new class_1959.class_1960().method_24379(ParadiseLostBiomes.createBiomeEffects(0xC0C0FF, 0xF1FF99, 9292207, 0xFFFFFF, 5826047, 6547455)).method_30973(ParadiseLostBiomes.createGenerationSettings(ParadiseLostBiomes.getParadiseLostCarvers(), ParadiseLostBiomes.merge(ParadiseLostBiomes.getStandardParadiseLostFeatures(), Map.of(class_2893.class_2895.field_13171, List.of(), class_2893.class_2895.field_35182, List.of(ParadiseLostMiscPlacedFeatures.WATER_SPRING), class_2893.class_2895.field_13178, List.of(ParadiseLostVegetationPlacedFeatures.TALL_GRASS, ParadiseLostVegetationPlacedFeatures.BUSH, ParadiseLostVegetationPlacedFeatures.PATCH_BLACKCURRANT, ParadiseLostTreePlacedFeatures.PLATEAU_TREES, ParadiseLostTreePlacedFeatures.SPARSE_TREES))))).method_30974(ParadiseLostBiomes.createSpawnSettings(ParadiseLostBiomes.merge(Map.of(class_1311.field_6294, List.of(new class_5483.class_1964(ParadiseLostEntityTypes.PARADISE_HARE, 12, 4, 4), new class_5483.class_1964(ParadiseLostEntityTypes.MOA, 6, 3, 7)))), Map.of())).method_8735(class_1959.class_1963.field_9382).method_8747(0.5f).method_8727(1.0f).method_30972();
    }

    private static class_1959 createHighlandsThicket() {
        return new class_1959.class_1960().method_24379(ParadiseLostBiomes.createBiomeEffects(0xC0C0FF, 15597437, 7575944, 0xFFFFFF, 5826047, 6547455)).method_30973(ParadiseLostBiomes.createGenerationSettings(ParadiseLostBiomes.getParadiseLostCarvers(), ParadiseLostBiomes.merge(ParadiseLostBiomes.getStandardParadiseLostFeatures(), Map.of(class_2893.class_2895.field_13171, List.of(ParadiseLostMiscPlacedFeatures.THICKET_BOULDER, ParadiseLostMiscPlacedFeatures.GOLDEN_BOULDER), class_2893.class_2895.field_35182, List.of(ParadiseLostMiscPlacedFeatures.WATER_SPRING), class_2893.class_2895.field_13178, List.of(ParadiseLostVegetationPlacedFeatures.THICKET_SHAMROCK, ParadiseLostVegetationPlacedFeatures.THICKET_LIVERWORT_CARPET, ParadiseLostVegetationPlacedFeatures.GRASS, ParadiseLostTreePlacedFeatures.FALLEN_LEAVES, ParadiseLostVegetationPlacedFeatures.TALL_GRASS, ParadiseLostVegetationPlacedFeatures.DENSE_BUSH, ParadiseLostTreePlacedFeatures.THICKET_TREES, ParadiseLostTreePlacedFeatures.THICKET_MOTHER_AUREL_TREES))))).method_30974(ParadiseLostBiomes.createSpawnSettings(ParadiseLostBiomes.merge(Map.of(class_1311.field_6302, List.of(new class_5483.class_1964(ParadiseLostEntityTypes.HELLENROSE, 50, 1, 2)), class_1311.field_6294, List.of(new class_5483.class_1964(ParadiseLostEntityTypes.PARADISE_HARE, 12, 4, 4), new class_5483.class_1964(ParadiseLostEntityTypes.MOA, 10, 1, 5)))), Map.of(ParadiseLostEntityTypes.HELLENROSE, SpawnCost.of(0.75, 0.07)))).method_8735(class_1959.class_1963.field_9382).method_8747(0.4f).method_8727(2.0f).method_30972();
    }

    private static class_1959 createHighlandsGrandGlade() {
        return new class_1959.class_1960().method_24379(ParadiseLostBiomes.createBiomeEffects(0xC0C0FF, 15597437, 7575944, 0xFFFFFF, 5826047, 6547455)).method_30973(ParadiseLostBiomes.createGenerationSettings(ParadiseLostBiomes.getParadiseLostCarvers(), ParadiseLostBiomes.merge(ParadiseLostBiomes.getStandardParadiseLostFeatures(), Map.of(class_2893.class_2895.field_13171, List.of(ParadiseLostMiscPlacedFeatures.THICKET_BOULDER), class_2893.class_2895.field_35182, List.of(ParadiseLostMiscPlacedFeatures.WATER_SPRING), class_2893.class_2895.field_13178, List.of(ParadiseLostTreePlacedFeatures.THICKET_FALLEN_LOG, ParadiseLostVegetationPlacedFeatures.GRASS, ParadiseLostTreePlacedFeatures.FALLEN_LEAVES, ParadiseLostVegetationPlacedFeatures.PATCH_BROWN_SPORECAP_COMMON, ParadiseLostVegetationPlacedFeatures.TALL_GRASS, ParadiseLostVegetationPlacedFeatures.DENSE_BUSH, ParadiseLostTreePlacedFeatures.SPARSE_TREES))))).method_30974(ParadiseLostBiomes.createSpawnSettings(ParadiseLostBiomes.merge(Map.of(class_1311.field_6302, List.of(new class_5483.class_1964(ParadiseLostEntityTypes.HELLENROSE, 50, 1, 2)), class_1311.field_6294, List.of(new class_5483.class_1964(ParadiseLostEntityTypes.PARADISE_HARE, 12, 4, 4), new class_5483.class_1964(ParadiseLostEntityTypes.MOA, 10, 1, 5)))), Map.of(ParadiseLostEntityTypes.HELLENROSE, SpawnCost.of(0.75, 0.07)))).method_8735(class_1959.class_1963.field_9382).method_8747(0.4f).method_8727(2.0f).method_30972();
    }

    private static class_1959 createWisteriaWoods() {
        return new class_1959.class_1960().method_24379(ParadiseLostBiomes.createBiomeEffects(0xC0C0FF, 0xF1FF99, 10868417, 0xFFFFFF, 5826047, 6547455)).method_30973(ParadiseLostBiomes.createGenerationSettings(ParadiseLostBiomes.getParadiseLostCarvers(), ParadiseLostBiomes.merge(ParadiseLostBiomes.getStandardParadiseLostFeatures(), Map.of(class_2893.class_2895.field_13171, List.of(), class_2893.class_2895.field_13178, List.of(ParadiseLostVegetationPlacedFeatures.RAINBOW_MALT_SPRIGS, ParadiseLostVegetationPlacedFeatures.FLOWERS, ParadiseLostVegetationPlacedFeatures.GRASS, ParadiseLostTreePlacedFeatures.FALLEN_ROSE_LEAVES, ParadiseLostTreePlacedFeatures.FALLEN_LAVENDER_LEAVES, ParadiseLostVegetationPlacedFeatures.BUSH, ParadiseLostVegetationPlacedFeatures.PATCH_BLACKCURRANT, ParadiseLostTreePlacedFeatures.RAINBOW_FOREST_TREES))))).method_30974(ParadiseLostBiomes.createSpawnSettings(ParadiseLostBiomes.merge(Map.of(class_1311.field_6302, List.of(new class_5483.class_1964(ParadiseLostEntityTypes.HELLENROSE, 100, 3, 7)), class_1311.field_6294, List.of(new class_5483.class_1964(ParadiseLostEntityTypes.PARADISE_HARE, 12, 4, 4), new class_5483.class_1964(ParadiseLostEntityTypes.MOA, 10, 1, 5)))), Map.of(ParadiseLostEntityTypes.HELLENROSE, SpawnCost.of(0.7, 0.1)))).method_8735(class_1959.class_1963.field_9382).method_8747(0.5f).method_8727(1.0f).method_30972();
    }

    private static class_1959 createAutumnalTundra() {
        return new class_1959.class_1960().method_24379(ParadiseLostBiomes.createBiomeEffects(0xC0C0FF, 16769162, 13562594, 0xFFFFFF, 9234175, 10611455)).method_30973(ParadiseLostBiomes.createGenerationSettings(ParadiseLostBiomes.getParadiseLostCarvers(), ParadiseLostBiomes.merge(ParadiseLostBiomes.getStandardParadiseLostFeatures(), Map.of(class_2893.class_2895.field_25186, List.of(ParadiseLostMiscPlacedFeatures.TUNDRA_PONDS, ParadiseLostMiscPlacedFeatures.TUNDRA_SNOW), class_2893.class_2895.field_13171, List.of(ParadiseLostMiscPlacedFeatures.GENERIC_BOULDER), class_2893.class_2895.field_35182, List.of(ParadiseLostMiscPlacedFeatures.WATER_SPRING), class_2893.class_2895.field_13178, List.of(ParadiseLostMiscPlacedFeatures.TUNDRA_SPIRES, ParadiseLostVegetationPlacedFeatures.TUNDRA_FOLIAGE, ParadiseLostTreePlacedFeatures.MIXED_TREES), class_2893.class_2895.field_13179, List.of(class_6814.field_36012))))).method_30974(ParadiseLostBiomes.createSpawnSettings(ParadiseLostBiomes.merge(Map.of(class_1311.field_6294, List.of(new class_5483.class_1964(ParadiseLostEntityTypes.PARADISE_HARE, 12, 4, 4), new class_5483.class_1964(ParadiseLostEntityTypes.MOA, 6, 5, 13), new class_5483.class_1964(ParadiseLostEntityTypes.PARADISE_HARE, 6, 1, 3)))), Map.of())).method_8735(class_1959.class_1963.field_9382).method_8747(0.1f).method_8727(2.0f).method_30972();
    }

    private static class_1959 createContinentalPlateau() {
        return new class_1959.class_1960().method_24379(ParadiseLostBiomes.createBiomeEffects(0xC0C0FF, 16769162, 13562594, 0xFFFFFF, 9234175, 10611455)).method_30973(ParadiseLostBiomes.createGenerationSettings(ParadiseLostBiomes.getParadiseLostCarvers(), ParadiseLostBiomes.merge(ParadiseLostBiomes.getStandardParadiseLostFeatures(), Map.of(class_2893.class_2895.field_13171, List.of(ParadiseLostMiscPlacedFeatures.PLAINS_BOULDER), class_2893.class_2895.field_35182, List.of(ParadiseLostMiscPlacedFeatures.WATER_SPRING), class_2893.class_2895.field_13178, List.of(ParadiseLostVegetationPlacedFeatures.FLOWERS, ParadiseLostVegetationPlacedFeatures.GRASS, ParadiseLostVegetationPlacedFeatures.TALL_GRASS, ParadiseLostVegetationPlacedFeatures.PATCH_BLACKCURRANT, ParadiseLostVegetationPlacedFeatures.PLATEAU_FOLIAGE, ParadiseLostVegetationPlacedFeatures.PLATEAU_SHAMROCK, ParadiseLostVegetationPlacedFeatures.PLATEAU_FLOWERING_GRASS, ParadiseLostTreePlacedFeatures.PLATEAU_TREES))))).method_30974(ParadiseLostBiomes.createSpawnSettings(ParadiseLostBiomes.merge(Map.of(class_1311.field_6294, List.of(new class_5483.class_1964(ParadiseLostEntityTypes.PARADISE_HARE, 12, 4, 4), new class_5483.class_1964(ParadiseLostEntityTypes.MOA, 6, 5, 13), new class_5483.class_1964(ParadiseLostEntityTypes.PARADISE_HARE, 6, 1, 3)))), Map.of())).method_8735(class_1959.class_1963.field_9382).method_8747(0.25f).method_8727(0.0f).method_30972();
    }

    private static class_1959 createHighlandsShield() {
        return new class_1959.class_1960().method_24379(ParadiseLostBiomes.createBiomeEffects(0xC0C0FF, 16441439, 11466198, 0xFFFFFF, 5826047, 6547455)).method_30973(ParadiseLostBiomes.createGenerationSettings(ParadiseLostBiomes.getParadiseLostCarvers(), ParadiseLostBiomes.merge(ParadiseLostBiomes.getStandardParadiseLostFeatures(), Map.of(class_2893.class_2895.field_25186, List.of(ParadiseLostMiscPlacedFeatures.SHIELD_PONDS), class_2893.class_2895.field_13171, List.of(ParadiseLostMiscPlacedFeatures.GENERIC_BOULDER), class_2893.class_2895.field_35182, List.of(ParadiseLostMiscPlacedFeatures.WATER_SPRING), class_2893.class_2895.field_13178, List.of(ParadiseLostTreePlacedFeatures.SHIELD_STUMPS, ParadiseLostTreePlacedFeatures.SHIELD_HOLLOW_STUMPS, ParadiseLostTreePlacedFeatures.MOTTLED_FALLEN_LOG, ParadiseLostTreePlacedFeatures.MOTTLED_HOLLOW_FALLEN_LOG, ParadiseLostVegetationPlacedFeatures.FLOWERS, ParadiseLostVegetationPlacedFeatures.SHIELD_FLAX, ParadiseLostVegetationPlacedFeatures.SHIELD_NETTLES, ParadiseLostVegetationPlacedFeatures.SHIELD_FOLIAGE, ParadiseLostVegetationPlacedFeatures.GRASS, ParadiseLostVegetationPlacedFeatures.TALL_GRASS, ParadiseLostMiscPlacedFeatures.WATER_SPRING, ParadiseLostTreePlacedFeatures.SHIELD_TREES, ParadiseLostTreePlacedFeatures.DENSE_SHIELD_TREES, ParadiseLostMiscPlacedFeatures.SHIELD_ROCKS, ParadiseLostTreePlacedFeatures.SHIELD_FALLEN_LEAVES))))).method_30974(ParadiseLostBiomes.createSpawnSettings(ParadiseLostBiomes.merge(Map.of(class_1311.field_6302, List.of(new class_5483.class_1964(ParadiseLostEntityTypes.HELLENROSE, 50, 1, 3)), class_1311.field_6294, List.of(new class_5483.class_1964(ParadiseLostEntityTypes.PARADISE_HARE, 12, 4, 4), new class_5483.class_1964(ParadiseLostEntityTypes.MOA, 6, 5, 13), new class_5483.class_1964(ParadiseLostEntityTypes.PARADISE_HARE, 6, 1, 3)))), Map.of(ParadiseLostEntityTypes.HELLENROSE, SpawnCost.of(1.0, 0.1)))).method_8735(class_1959.class_1963.field_9382).method_8747(0.35f).method_8727(2.0f).method_30972();
    }

    private record SpawnCost(double charge, double energyBudget) {
        static SpawnCost of(double charge, double energyBudget) {
            return new SpawnCost(charge, energyBudget);
        }
    }
}

