/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.util;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.id.paradiselost.ParadiseLost;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5195;

public final class ParadiseLostSoundEvents {
    private static final Set<AbstractSoundEvent> SOUNDS = new HashSet<AbstractSoundEvent>();
    public static final class_3414 BLOCK_BLACKCURRANT_BUSH_PICK_BLUEBERRIES = ParadiseLostSoundEvents.childEvent("block.blackcurrant_bush.pick_blueberries", class_3417.field_17617);
    public static final class_3414 BLOCK_PORTAL_AMBIENT = ParadiseLostSoundEvents.event("block.portal.ambient");
    public static final class_3414 BLOCK_PORTAL_TRAVEL = ParadiseLostSoundEvents.event("block.portal.travel");
    public static final class_3414 BLOCK_PORTAL_TRIGGER = ParadiseLostSoundEvents.event("block.portal.trigger");
    public static final class_3414 BLOCK_ORANGE_LEAVES_BREAK = ParadiseLostSoundEvents.childEvent("block.orange_leaves.break", class_3417.field_28596);
    public static final class_3414 BLOCK_ORANGE_LEAVES_DROP_FRUIT = ParadiseLostSoundEvents.childEvent("block.orange_leaves.drop_fruit", class_3417.field_26954);
    public static final class_3414 BLOCK_ORANGE_LEAVES_BREAK_DIFFERENTLY = ParadiseLostSoundEvents.childEvent("block.orange_leaves.break_differently", class_3417.field_17610);
    public static final class_3414 BLOCK_LICHEN_SPREADS = ParadiseLostSoundEvents.childEvent("block.lichen.spreads", class_3417.field_14739);
    public static final class_3414 BLOCK_SPRING_WATER_AMBIENT = ParadiseLostSoundEvents.childEvent("block.spring_water.ambient", class_3417.field_15237);
    public static final class_3414 BLOCK_SPRING_WATER_AMBIENT_2 = ParadiseLostSoundEvents.childEvent("block.spring_water.ambient.2", class_3417.field_14650);
    public static final class_3414 MUSIC_PARADISE_LOST = ParadiseLostSoundEvents.music("cloud_ocean", "floating", "spirit_sunset", "constellation", "overcast", "sullen_lullaby");
    public static final class_3414 MISC_SILENCE = ParadiseLostSoundEvents.event("misc.silence", false);
    public static final class_3414 EFFECT_SIMMERING_SIMMER = ParadiseLostSoundEvents.childEvent("effect.simmering.simmer", class_3417.field_14650);
    public static final class_3414 ENTITY_HELLENROSE_DEATH = ParadiseLostSoundEvents.childEvent("entity.hellenrose.death", class_3417.field_14928);
    public static final class_3414 ENTITY_HELLENROSE_SHOOT = ParadiseLostSoundEvents.childEvent("entity.hellenrose.shoot", class_3417.field_14633);
    public static final class_3414 ENTITY_MOA_AMBIENT = ParadiseLostSoundEvents.childEvent("entity.moa.ambient", class_3417.field_15132);
    public static final class_3414 ENTITY_MOA_GLIDING = ParadiseLostSoundEvents.childEvent("entity.moa.gliding", class_3417.field_14869);
    public static final class_3414 ENTITY_MOA_DEATH = ParadiseLostSoundEvents.childEvent("entity.moa.death", class_3417.field_15234);
    public static final class_3414 ENTITY_MOA_HURT = ParadiseLostSoundEvents.childEvent("entity.moa.hurt", class_3417.field_14911);
    public static final class_3414 ENTITY_MOA_EAT = ParadiseLostSoundEvents.childEvent("entity.moa.eat", class_3417.field_14960);
    public static final class_3414 ENTITY_MOA_LAY_EGG = ParadiseLostSoundEvents.childEvent("entity.moa.lay_egg", class_3417.field_14634);
    public static final class_3414 ENTITY_MOA_EGG_HATCH = ParadiseLostSoundEvents.childEvent("entity.moa.egg_hatch", class_3417.field_14902);
    public static final class_3414 ENTITY_MOA_STEP = ParadiseLostSoundEvents.childEvent("entity.moa.step", class_3417.field_14894);
    public static final class_3414 ENTITY_PARADISE_HARE_SNIFF = ParadiseLostSoundEvents.childEvent("entity.corsican_hare.sniff", class_3417.field_18063);
    public static final class_3414 ENTITY_PARADISE_HARE_JUMP = ParadiseLostSoundEvents.childEvent("entity.corsican_hare.jump", class_3417.field_15091);
    public static final class_3414 ENTITY_PARADISE_HARE_HURT = ParadiseLostSoundEvents.childEvent("entity.corsican_hare.hurt", class_3417.field_15164);
    public static final class_3414 ENTITY_PARADISE_HARE_DEATH = ParadiseLostSoundEvents.childEvent("entity.corsican_hare.death", class_3417.field_14872);
    public static final class_3414 ENTITY_PARADISE_HARE_EAT = ParadiseLostSoundEvents.childEvent("entity.corsican_hare.eat", class_3417.field_14884);
    public static final class_3414 ENTITY_NIGHTMARE_HURT = ParadiseLostSoundEvents.event("entity.nightmare.hurt");
    public static final class_3414 ENTITY_NIGHTMARE_DEATH = ParadiseLostSoundEvents.event("entity.nightmare.death");
    public static final class_3414 ENTITY_NIGHTMARE_AMBIENT = ParadiseLostSoundEvents.event("entity.nightmare.ambient");
    public static final class_3414 ITEM_ARMOR_EQUIP_OLVITE = ParadiseLostSoundEvents.childEvent("item.armor.equip.olvite", class_3417.field_14862);
    public static final class_3414 ITEM_DART_SHOOTER_SHOOT = ParadiseLostSoundEvents.childEvent("item.dart_shooter.shoot", class_3417.field_15187);
    public static final class_3414 ITEM_BLOODSTONE_PRICK = ParadiseLostSoundEvents.childEvent("item.bloodstone.prick", class_3417.field_20606);
    private static final class_2960 RESOURCE_SOUNDS = ParadiseLost.locate("sounds.json");

    private ParadiseLostSoundEvents() {
        throw new RuntimeException();
    }

    private static class_3414 event(String name) {
        return ParadiseLostSoundEvents.event(name, true);
    }

    private static class_3414 event(class_3414 event) {
        return ParadiseLostSoundEvents.event(event.method_14833().toString(), true);
    }

    private static class_3414 event(String name, String ... sounds) {
        return ParadiseLostSoundEvents.event(name, true, sounds);
    }

    private static class_3414 event(String name, boolean subtitles) {
        return ParadiseLostSoundEvents.event(name, subtitles, name.replaceAll("\\.", "/"));
    }

    private static class_3414 event(String name, boolean subtitles, String ... sounds) {
        ParadiseLostSoundEvent event = new ParadiseLostSoundEvent(ParadiseLost.locate(name), subtitles ? "subtitles.paradise_lost." + name : null, Stream.of(sounds).map(ParadiseLost::locate).collect(Collectors.toUnmodifiableSet()));
        SOUNDS.add(event);
        return event;
    }

    private static class_3414 music(String ... songs) {
        MusicSoundEvent event = new MusicSoundEvent(Stream.of(songs).map(track -> ParadiseLost.locate("music/paradise_lost/" + track)).collect(Collectors.toUnmodifiableSet()));
        SOUNDS.add(event);
        return event;
    }

    private static class_3414 childEvent(String name, String parent) {
        return ParadiseLostSoundEvents.childEvent(name, true, parent);
    }

    private static class_3414 childEvent(String name, class_3414 parent) {
        return ParadiseLostSoundEvents.childEvent(name, true, parent.method_14833().toString());
    }

    private static class_3414 childEvent(String name, boolean subtitles, String parent) {
        ChildSoundEvent event = new ChildSoundEvent(ParadiseLost.locate(name), subtitles ? "subtitles.paradise_lost." + name : null, ParadiseLost.locate(parent));
        SOUNDS.add(event);
        return event;
    }

    public static void init() {
        SOUNDS.forEach(ParadiseLostSoundEvents::register);
        Music.init();
    }

    private static void register(class_3414 event) {
        class_2378.method_10230((class_2378)class_2378.field_11156, (class_2960)event.method_14833(), (Object)event);
    }

    public static class_3298 createResource() {
        StringBuilder builder = new StringBuilder("{");
        for (AbstractSoundEvent sound : SOUNDS) {
            builder.append(sound.toJson()).append(',');
        }
        builder.setLength(builder.length() - 1);
        builder.append('}');
        byte[] payload = builder.toString().getBytes(StandardCharsets.UTF_8);
        return new class_3298("Paradise Lost", () -> new ByteArrayInputStream(payload), () -> null);
    }

    private static final class ParadiseLostSoundEvent
    extends AbstractSoundEvent {
        private final Set<class_2960> sounds;

        private ParadiseLostSoundEvent(class_2960 id, String subtitle, Set<class_2960> sounds) {
            super(id, subtitle);
            this.sounds = sounds;
        }

        @Override
        public String toJson() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\"%s\":{".formatted(this.method_14833().method_12832()));
            if (this.subtitle != null) {
                stringBuilder.append("\"subtitle\":\"%s\",".formatted(this.subtitle));
            }
            stringBuilder.append("\"sounds\":[");
            for (class_2960 sound : this.sounds) {
                stringBuilder.append("\"%s\"".formatted(sound.toString()));
            }
            stringBuilder.append("]}");
            return stringBuilder.toString();
        }
    }

    private static final class MusicSoundEvent
    extends AbstractSoundEvent {
        private final Set<class_2960> tracks;

        private MusicSoundEvent(Set<class_2960> tracks) {
            super(ParadiseLost.locate("music.paradise_lost"), null);
            this.tracks = tracks;
        }

        @Override
        public String toJson() {
            StringBuilder builder = new StringBuilder();
            builder.append("\"music.paradise_lost\":{\"sounds\":[");
            for (class_2960 track : this.tracks) {
                builder.append("{\"name\":\"%s\",\"stream\":true},".formatted(track.toString()));
            }
            builder.setLength(builder.length() - 1);
            builder.append("]}");
            return builder.toString();
        }
    }

    private static final class ChildSoundEvent
    extends AbstractSoundEvent {
        private final class_2960 parent;

        private ChildSoundEvent(class_2960 id, String subtitle, class_2960 parent) {
            super(id, subtitle);
            this.parent = parent;
        }

        @Override
        public String toJson() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\"%s\":{".formatted(this.method_14833().method_12832()));
            if (this.subtitle != null) {
                stringBuilder.append("\"subtitle\":\"%s\",".formatted(this.subtitle));
            }
            stringBuilder.append("\"sounds\":[{\"name\":\"%s\",\"type\":\"event\"}]}".formatted(this.parent.toString()));
            return stringBuilder.toString();
        }
    }

    public static final class Music {
        public static final class_5195 PARADISE_LOST = new class_5195(MUSIC_PARADISE_LOST, 12000, 24000, false);

        private static void init() {
        }
    }

    private static abstract class AbstractSoundEvent
    extends class_3414 {
        protected final String subtitle;

        private AbstractSoundEvent(class_2960 id, String subtitle) {
            super(id);
            this.subtitle = subtitle;
        }

        public abstract String toJson();
    }
}

