/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.util;

import com.mojang.datafixers.util.Function5;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AStarManager {
    public static Builder createBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private BlockPosProvider start;
        private BlockPosProvider goal;
        private BiFunction<class_4538, class_2338, class_2338> checkAdjuster = a_noop;
        private BiPredicate<class_4538, class_2338> validator = v_alwaysTrue;
        private Function5<class_2338, class_2338, class_4538, class_2338, Double, Integer> costMapper = c_simple;
        private BiPredicate<class_4538, Optional<Node>> outputValidator = o_pass;
        private boolean allowDiagonalMovement;
        private boolean allowRecompute;
        private int expectedPathLength = 32;
        private double heuristic = 1.334;
        public static final BiFunction<class_4538, class_2338, class_2338> a_noop = (worldView, pos) -> pos;
        public static final BiFunction<class_4538, class_2338, class_2338> a_simpleGround = (worldView, pos) -> {
            if (worldView.method_22347(pos.method_10074())) {
                return pos.method_10074();
            }
            return pos;
        };
        public static final BiPredicate<class_4538, class_2338> v_alwaysTrue = (worldView, blockPos) -> true;
        public static final BiPredicate<class_4538, class_2338> v_replaceable = (worldView, blockPos) -> worldView.method_8320(blockPos).method_26207().method_15800();
        public static final BiPredicate<class_4538, class_2338> v_noFly = (worldView, blockPos) -> !worldView.method_22347(blockPos.method_10074());
        public static final Function5<class_2338, class_2338, class_4538, class_2338, Double, Integer> c_simple = (start, goal, worldView, current, heuristic) -> (int)((double)current.method_19455((class_2382)start) / heuristic + (double)current.method_19455((class_2382)goal));
        public static final Function5<class_2338, class_2338, class_4538, class_2338, Double, Integer> c_favorReplaceable = (start, goal, worldView, current, heuristic) -> (int)((double)current.method_19455((class_2382)start) / heuristic + (double)current.method_19455((class_2382)goal) + (double)(worldView.method_8320(current).method_26207().method_15800() ? 0 : 10));
        public static final BiPredicate<class_4538, Optional<Node>> o_pass = (worldView, node) -> true;
        public static final BiPredicate<class_4538, Optional<Node>> o_present = (worldView, node) -> node.isPresent();

        private Builder() {
        }

        public void checkAdjuster(@NotNull BiFunction<class_4538, class_2338, class_2338> checkAdjuster) {
            this.checkAdjuster = checkAdjuster;
        }

        public void validator(@NotNull BiPredicate<class_4538, class_2338> validator) {
            this.validator = validator;
        }

        public void costMapper(@NotNull Function5<class_2338, class_2338, class_4538, class_2338, Double, Integer> costMapper) {
            this.costMapper = costMapper;
        }

        public void outputValidator(@NotNull BiPredicate<class_4538, Optional<Node>> outputValidator) {
            this.outputValidator = outputValidator;
        }

        public void start(@NotNull BlockPosProvider start) {
            this.start = start;
        }

        public void goal(@NotNull BlockPosProvider goal) {
            this.goal = goal;
        }

        public void expectedLength(int expectedPathLength) {
            this.expectedPathLength = expectedPathLength;
        }

        public void heuristic(double heuristic) {
            this.heuristic = heuristic;
        }

        public void allowRecompute() {
            this.allowRecompute = true;
        }

        public void allowDiagonalMovement() {
            this.allowDiagonalMovement = true;
        }

        public APather build(@NotNull class_4538 world) {
            if (this.start == null) {
                throw new IllegalArgumentException("start must not be null");
            }
            if (this.goal == null) {
                throw new IllegalArgumentException("goal must not be null");
            }
            return new APather(world, this.start, this.goal, this.checkAdjuster, this.validator, this.costMapper, this.outputValidator, this.expectedPathLength, this.allowDiagonalMovement, this.allowRecompute, this.heuristic);
        }
    }

    @FunctionalInterface
    public static interface BlockPosProvider {
        @NotNull
        public class_2338 get(class_4538 var1);

        public static BlockPosProvider simple(class_2338 pos) {
            return world -> pos;
        }
    }

    public record PathingOutput(LinkedList<Node> path, class_2338 start, class_2338 goal, Set<class_2338> checkedBlocks) {
    }

    public record Node(class_2338 pos, int cost, @Nullable Node parent, boolean root) {
    }

    public static final class APather {
        private final PriorityQueue<Node> queue;
        private final class_4538 world;
        private final BlockPosProvider start;
        private final BlockPosProvider goal;
        private final BiFunction<class_4538, class_2338, class_2338> checkAdjuster;
        private final BiPredicate<class_4538, class_2338> validator;
        private final Function5<class_2338, class_2338, class_4538, class_2338, Double, Integer> costMapper;
        private final BiPredicate<class_4538, Optional<Node>> outputValidator;
        private final boolean allowRecompute;
        private final boolean allowDiagionalMovement;
        private final int expectedPathLength;
        private final double heuristic;
        private Optional<PathingOutput> lastOutput;
        private boolean complete;

        private APather(class_4538 world, BlockPosProvider start, BlockPosProvider goal, BiFunction<class_4538, class_2338, class_2338> checkAdjuster, BiPredicate<class_4538, class_2338> validator, Function5<class_2338, class_2338, class_4538, class_2338, Double, Integer> costMapper, BiPredicate<class_4538, Optional<Node>> outputValidator, int expectedPathLength, boolean allowDiagionalMovement, boolean allowRecompute, double heuristic) {
            this.heuristic = heuristic;
            Comparator<Node> comparator = Comparator.comparing(node -> node.cost);
            this.queue = new PriorityQueue<Node>(expectedPathLength, comparator);
            this.world = world;
            this.start = start;
            this.goal = goal;
            this.checkAdjuster = checkAdjuster;
            this.validator = validator;
            this.costMapper = costMapper;
            this.outputValidator = outputValidator;
            this.allowDiagionalMovement = allowDiagionalMovement;
            this.allowRecompute = allowRecompute;
            this.expectedPathLength = expectedPathLength;
        }

        public void compute() {
            if (this.complete && !this.allowRecompute) {
                throw new IllegalStateException("attempted to compute a completed path, did you forget to set allowRecompute?");
            }
            class_2338 rootPos = this.start.get(this.world);
            class_2338 goalPos = this.goal.get(this.world);
            Node root = new Node(rootPos, Integer.MIN_VALUE, null, true);
            Optional<Node> endNode = Optional.empty();
            HashSet<class_2338> pastNodes = new HashSet<class_2338>();
            this.queue.add(root);
            for (int iterations = 0; !this.queue.isEmpty() && iterations <= this.expectedPathLength * 20; ++iterations) {
                Node currentNode = this.queue.poll();
                pastNodes.add(currentNode.pos);
                if (currentNode.pos.equals((Object)goalPos)) {
                    endNode = Optional.of(currentNode);
                    break;
                }
                this.process(rootPos, goalPos, currentNode, pastNodes);
            }
            this.lastOutput = this.constructOutput(rootPos, goalPos, endNode, pastNodes);
            this.complete = true;
        }

        private void process(class_2338 start, class_2338 goal, Node current, Set<class_2338> pastNodes) {
            class_2338 curPos = current.pos;
            for (class_2350 direction : class_2350.values()) {
                class_2338 testPos = curPos.method_10093(direction);
                if (this.allowDiagionalMovement) {
                    for (class_2350 diagonal : class_2350.values()) {
                        class_2338 diagonalPos;
                        if (diagonal.method_10166() == direction.method_10166() || pastNodes.contains(diagonalPos = this.checkAdjuster.apply(this.world, testPos.method_10093(diagonal))) || !this.validator.test(this.world, diagonalPos)) continue;
                        Integer cost = (Integer)this.costMapper.apply((Object)start, (Object)goal, (Object)this.world, (Object)diagonalPos, (Object)this.heuristic);
                        this.queue.add(new Node(diagonalPos, cost, current, false));
                    }
                    continue;
                }
                if (pastNodes.contains(testPos = this.checkAdjuster.apply(this.world, testPos)) || !this.validator.test(this.world, testPos)) continue;
                Integer cost = (Integer)this.costMapper.apply((Object)start, (Object)goal, (Object)this.world, (Object)testPos, (Object)this.heuristic);
                this.queue.add(new Node(testPos, cost, current, false));
            }
        }

        private Optional<PathingOutput> constructOutput(class_2338 start, class_2338 goal, Optional<Node> endNode, Set<class_2338> pastNodes) {
            if (this.outputValidator.test(this.world, endNode) && endNode.isPresent()) {
                Node node = endNode.get();
                LinkedList<Node> path = new LinkedList<Node>();
                while (!node.root) {
                    path.add(node);
                    node = node.parent;
                }
                path.add(node);
                return Optional.of(new PathingOutput(path, start, goal, pastNodes));
            }
            return Optional.empty();
        }

        public boolean hasComputed() {
            return this.complete;
        }

        public Optional<PathingOutput> getLastOutput() {
            return this.lastOutput;
        }
    }
}

