/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.screen.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public interface FloatyDrawableHelper {
    default public void drawHorizontalLine(class_4587 matrices, float x1, float x2, float y, int color) {
        if (x2 < x1) {
            float i = x1;
            x1 = x2;
            x2 = i;
        }
        this.fill(matrices, x1, y, x2 + 1.0f, y + 1.0f, color);
    }

    default public void drawVerticalLine(class_4587 matrices, float x, float y1, float y2, int color) {
        if (y2 < y1) {
            float i = y1;
            y1 = y2;
            y2 = i;
        }
        this.fill(matrices, x, y1 + 1.0f, x + 1.0f, y2, color);
    }

    default public void fill(class_4587 matrices, float x1, float y1, float x2, float y2, int color) {
        this.fill(matrices.method_23760().method_23761(), x1, y1, x2, y2, color);
    }

    default public void fill(class_1159 matrix, float x1, float y1, float x2, float y2, int color) {
        float j;
        if (x1 < x2) {
            j = x1;
            x1 = x2;
            x2 = j;
        }
        if (y1 < y2) {
            j = y1;
            y1 = y2;
            y2 = j;
        }
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, x1, y2, 0.0f).method_22915(g, h, k, f).method_1344();
        bufferBuilder.method_22918(matrix, x2, y2, 0.0f).method_22915(g, h, k, f).method_1344();
        bufferBuilder.method_22918(matrix, x2, y1, 0.0f).method_22915(g, h, k, f).method_1344();
        bufferBuilder.method_22918(matrix, x1, y1, 0.0f).method_22915(g, h, k, f).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    default public void fillGradient(class_4587 matrices, float startX, float startY, float endX, float endY, int colorStart, int colorEnd) {
        this.fillGradient(matrices, startX, startY, endX, endY, colorStart, colorEnd, this.getZOffset());
    }

    default public void fillGradient(class_4587 matrices, float startX, float startY, float endX, float endY, int colorStart, int colorEnd, float z) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        this.fillGradient(matrices.method_23760().method_23761(), bufferBuilder, startX, startY, endX, endY, z, colorStart, colorEnd);
        tessellator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    default public void fillGradient(class_1159 matrix, class_287 bufferBuilder, float startX, float startY, float endX, float endY, float z, int colorStart, int colorEnd) {
        float f = (float)(colorStart >> 24 & 0xFF) / 255.0f;
        float g = (float)(colorStart >> 16 & 0xFF) / 255.0f;
        float h = (float)(colorStart >> 8 & 0xFF) / 255.0f;
        float i = (float)(colorStart & 0xFF) / 255.0f;
        float j = (float)(colorEnd >> 24 & 0xFF) / 255.0f;
        float k = (float)(colorEnd >> 16 & 0xFF) / 255.0f;
        float l = (float)(colorEnd >> 8 & 0xFF) / 255.0f;
        float m = (float)(colorEnd & 0xFF) / 255.0f;
        bufferBuilder.method_22918(matrix, endX, startY, z).method_22915(g, h, i, f).method_1344();
        bufferBuilder.method_22918(matrix, startX, startY, z).method_22915(g, h, i, f).method_1344();
        bufferBuilder.method_22918(matrix, startX, endY, z).method_22915(k, l, m, j).method_1344();
        bufferBuilder.method_22918(matrix, endX, endY, z).method_22915(k, l, m, j).method_1344();
    }

    default public void drawCenteredText(class_4587 matrices, class_327 textRenderer, String text, float centerX, float y, int color) {
        textRenderer.method_1720(matrices, text, centerX - (float)(textRenderer.method_1727(text) / 2), y, color);
    }

    default public void drawCenteredText(class_4587 matrices, class_327 textRenderer, class_2561 text, float centerX, float y, int color) {
        class_5481 orderedText = text.method_30937();
        textRenderer.method_27517(matrices, orderedText, centerX - (float)(textRenderer.method_30880(orderedText) / 2), y, color);
    }

    default public void drawCenteredTextWithShadow(class_4587 matrices, class_327 textRenderer, class_5481 text, float centerX, float y, int color) {
        textRenderer.method_27517(matrices, text, centerX - (float)(textRenderer.method_30880(text) / 2), y, color);
    }

    default public void drawStringWithShadow(class_4587 matrices, class_327 textRenderer, String text, float x, float y, int color) {
        textRenderer.method_1720(matrices, text, x, y, color);
    }

    default public void drawWithShadow(class_4587 matrices, class_327 textHandler, class_5481 text, float x, float y, int color) {
        textHandler.method_27517(matrices, text, x, y, color);
    }

    default public void drawTextWithShadow(class_4587 matrices, class_327 textRenderer, class_2561 text, float x, float y, int color) {
        textRenderer.method_30881(matrices, text, x, y, color);
    }

    default public void drawWithOutline(float x, float y, BiConsumer<Float, Float> renderAction) {
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        renderAction.accept(Float.valueOf(x + 1.0f), Float.valueOf(y));
        renderAction.accept(Float.valueOf(x - 1.0f), Float.valueOf(y));
        renderAction.accept(Float.valueOf(x), Float.valueOf(y + 1.0f));
        renderAction.accept(Float.valueOf(x), Float.valueOf(y - 1.0f));
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        renderAction.accept(Float.valueOf(x), Float.valueOf(y));
    }

    default public void drawSprite(class_4587 matrices, float x, float y, float z, float width, float height, class_1058 sprite) {
        this.drawTexturedQuad(matrices.method_23760().method_23761(), x, x + width, y, y + height, z, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575());
    }

    default public void drawTexture(class_4587 matrices, float x, float y, float u, float v, float width, float height) {
        this.drawTexture(matrices, x, y, this.getZOffset(), u, v, width, height, 256.0f, 256.0f);
    }

    default public void drawTexture(class_4587 matrices, float x, float y, float z, float u, float v, float width, float height, float textureHeight, float textureWidth) {
        this.drawTexture(matrices, x, x + width, y, y + height, z, width, height, u, v, textureWidth, textureHeight);
    }

    default public void drawTexture(class_4587 matrices, float x, float y, float width, float height, float u, float v, float regionWidth, float regionHeight, float textureWidth, float textureHeight) {
        this.drawTexture(matrices, x, x + width, y, y + height, 0.0f, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    default public void drawTexture(class_4587 matrices, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        this.drawTexture(matrices, x, y, width, height, u, v, width, height, textureWidth, textureHeight);
    }

    default public void drawTexture(class_4587 matrices, float x0, float y0, float x1, float y1, float z, float regionWidth, float regionHeight, float u, float v, float textureWidth, float textureHeight) {
        this.drawTexturedQuad(matrices.method_23760().method_23761(), x0, y0, x1, y1, z, (u + 0.0f) / textureWidth, (u + regionWidth) / textureWidth, (v + 0.0f) / textureHeight, (v + regionHeight) / textureHeight);
    }

    default public void drawTexturedQuad(class_1159 matrices, float x0, float x1, float y0, float y1, float z, float u0, float u1, float v0, float v1) {
        RenderSystem.setShader(class_757::method_34542);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrices, x0, y1, z).method_22913(u0, v1).method_1344();
        bufferBuilder.method_22918(matrices, x1, y1, z).method_22913(u1, v1).method_1344();
        bufferBuilder.method_22918(matrices, x1, y0, z).method_22913(u1, v0).method_1344();
        bufferBuilder.method_22918(matrices, x0, y0, z).method_22913(u0, v0).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    default public int getZOffset() {
        return 0;
    }
}

