/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.id.paradiselost.ParadiseLost;
import net.id.paradiselost.component.ParadiseLostComponents;
import net.id.paradiselost.lore.LoreState;
import net.id.paradiselost.lore.LoreStatus;
import net.id.paradiselost.lore.LoreType;
import net.id.paradiselost.registry.ParadiseLostRegistries;
import net.id.paradiselost.screen.handler.LoreHandler;
import net.id.paradiselost.screen.util.FloatyDrawableHelper;
import net.minecraft.class_1159;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class LoreScreen
extends class_465<LoreHandler> {
    public static final class_2960 WIDGET_TEXTURE = ParadiseLost.locate("textures/gui/lore/widgets.png");
    private static final LoreEntry LORE_TEST = new LoreEntry(0, 0, LoreType.NORMAL, (class_1935)class_1802.field_8477, class_2561.method_30163((String)"Test!"), class_2561.method_30163((String)"This is a test lore entry.\nWhat fun!"));
    private static final LoreEntry PARENT_TEST = new LoreEntry(64, 0, LoreType.RARE, (class_1935)class_1802.field_8687, class_2561.method_30163((String)"Parent Test"), class_2561.method_30163((String)"This is a test of the lineage system"), LORE_TEST);
    private final int viewportWidth = 200;
    private final int viewportHeight = 200;
    private final List<LoreEntry> loreEntries;
    private int scrollX = 0;
    private int scrollY = 0;
    private int scrollLimitX1 = 0;
    private int scrollLimitY1 = 0;
    private int scrollLimitX0 = 0;
    private int scrollLimitY0 = 0;
    private LoreEntry hoveredEntry = null;
    private int dragStartX;
    private int dragStartY;
    private int scrollStartX;
    private int scrollStartY;

    public LoreScreen(LoreHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 200;
        this.field_2779 = 200;
        LoreState state = (LoreState)ParadiseLostComponents.LORE_STATE.get((Object)class_310.method_1551().field_1724);
        this.loreEntries = ParadiseLostRegistries.LORE_REGISTRY.method_10220().map(entry -> {
            LoreStatus status = state.getLoreStatus((net.id.paradiselost.lore.LoreEntry<?>)entry);
            if (status == LoreStatus.FREE || status == LoreStatus.UNLOCKED || status == LoreStatus.COMPLETED) {
                return new LoreEntry((net.id.paradiselost.lore.LoreEntry<?>)entry);
            }
            return null;
        }).filter(Objects::nonNull).toList();
        LoreType coreLoreType = LoreType.NORMAL;
        this.scrollX = 200 - coreLoreType.getWidth() >> 2;
        this.scrollY = 200 - coreLoreType.getHeight() >> 1;
    }

    protected void method_25426() {
        super.method_25426();
        int scrollLimitX1 = 0;
        int scrollLimitY1 = 0;
        int scrollLimitX0 = 0;
        int scrollLimitY0 = 0;
        for (LoreEntry loreEntry : this.loreEntries) {
            scrollLimitX0 = Math.min(scrollLimitX0, loreEntry.x);
            scrollLimitY0 = Math.min(scrollLimitY0, loreEntry.y);
            scrollLimitX1 = Math.max(scrollLimitX1, loreEntry.x + loreEntry.type.getWidth());
            scrollLimitY1 = Math.max(scrollLimitY1, loreEntry.y + loreEntry.type.getHeight());
        }
        this.scrollLimitX0 = scrollLimitX0 - 100;
        this.scrollLimitY0 = scrollLimitY0 - 100;
        this.scrollLimitX1 = scrollLimitX1 + 100;
        this.scrollLimitY1 = scrollLimitY1 + 100;
        this.scrollX = class_3532.method_15340((int)this.scrollX, (int)scrollLimitX0, (int)scrollLimitX1);
        this.scrollY = class_3532.method_15340((int)this.scrollX, (int)scrollLimitY0, (int)scrollLimitY1);
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        matrices.method_22903();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)WIDGET_TEXTURE);
        this.drawFrame(matrices);
        double scaleFactor = class_310.method_1551().method_22683().method_4495();
        RenderSystem.enableScissor((int)((int)((double)this.field_2776 * scaleFactor)), (int)((int)((double)(this.field_22790 - this.field_2800 - this.field_2779) * scaleFactor)), (int)((int)((double)this.field_2792 * scaleFactor)), (int)((int)((double)this.field_2779 * scaleFactor)));
        var filterState = new Object(){
            int mouseX;
            int mouseY;
        };
        filterState.mouseX = mouseX - this.field_2776 - this.scrollX;
        filterState.mouseY = mouseY - this.field_2800 - this.scrollY;
        LoreEntry currentlyHovered = this.loreEntries.stream().filter(entry -> filterState.mouseX >= entry.x && filterState.mouseX <= entry.x + entry.type.getWidth() && filterState.mouseY >= entry.y && filterState.mouseY <= entry.y + entry.type.getHeight()).findFirst().orElse(null);
        if (this.hoveredEntry != currentlyHovered) {
            if (this.hoveredEntry != null) {
                this.hoveredEntry.setHovered(false);
            }
            this.hoveredEntry = currentlyHovered;
            if (this.hoveredEntry != null) {
                this.hoveredEntry.setHovered(true);
            }
        }
        int offsetX = this.field_2776 + this.scrollX;
        int offsetY = this.field_2800 + this.scrollY;
        this.loreEntries.forEach(entry -> entry.tick(delta));
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)WIDGET_TEXTURE);
        RenderSystem.enableBlend();
        this.drawBorder(matrices);
        this.loreEntries.forEach(entry -> entry.drawBackground(matrices, offsetX, offsetY));
        this.loreEntries.forEach(entry -> entry.drawForeground(matrices, offsetX, offsetY));
        this.method_25304(200);
        this.field_22788.field_4730 = 200.0f;
        RenderSystem.enableDepthTest();
        this.loreEntries.forEach(entry -> entry.drawStack(offsetX, offsetY));
        this.method_25304(0);
        this.field_22788.field_4730 = 0.0f;
        RenderSystem.disableDepthTest();
        RenderSystem.disableScissor();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.dragStartX = (int)mouseX;
        this.dragStartY = (int)mouseY;
        this.scrollStartX = this.scrollX;
        this.scrollStartY = this.scrollY;
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.scrollX = class_3532.method_15340((int)((int)((double)this.scrollStartX + mouseX - (double)this.dragStartX)), (int)this.scrollLimitX0, (int)this.scrollLimitX1);
        this.scrollY = class_3532.method_15340((int)((int)((double)this.scrollStartY + mouseY - (double)this.dragStartY)), (int)this.scrollLimitY0, (int)this.scrollLimitY1);
        return true;
    }

    private void drawFrame(class_4587 matrices) {
        int x = this.field_2776;
        int y = this.field_2800;
        int width = this.field_2792;
        int height = this.field_2779;
        matrices.method_22903();
        matrices.method_22904((double)x, (double)y, 0.0);
        LoreScreen.method_25293((class_4587)matrices, (int)-8, (int)-8, (int)8, (int)8, (float)0.0f, (float)0.0f, (int)8, (int)8, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)width, (int)-8, (int)8, (int)8, (float)9.0f, (float)0.0f, (int)8, (int)8, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)width, (int)height, (int)8, (int)8, (float)9.0f, (float)9.0f, (int)8, (int)8, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)-8, (int)height, (int)8, (int)8, (float)0.0f, (float)9.0f, (int)8, (int)8, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)0, (int)-8, (int)width, (int)8, (float)8.0f, (float)0.0f, (int)1, (int)8, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)-8, (int)0, (int)8, (int)height, (float)0.0f, (float)8.0f, (int)8, (int)1, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)width, (int)0, (int)8, (int)height, (float)9.0f, (float)8.0f, (int)8, (int)1, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)0, (int)height, (int)width, (int)8, (float)8.0f, (float)9.0f, (int)1, (int)8, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)0, (int)0, (int)width, (int)height, (float)8.0f, (float)8.0f, (int)1, (int)1, (int)256, (int)256);
        matrices.method_22909();
    }

    private void drawBorder(class_4587 matrices) {
        matrices.method_22903();
        matrices.method_22904((double)(this.field_2776 + this.scrollLimitX0 + this.scrollX - 69), (double)(this.field_2800 + this.scrollLimitX0 + this.scrollY - 5), 0.0);
        int width = this.scrollLimitX1 - this.scrollLimitX0 + 200;
        int height = this.scrollLimitY1 - this.scrollLimitY0 + 200;
        LoreScreen.method_25293((class_4587)matrices, (int)0, (int)0, (int)4, (int)4, (float)0.0f, (float)72.0f, (int)4, (int)4, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)(width - 4), (int)0, (int)4, (int)4, (float)5.0f, (float)72.0f, (int)4, (int)4, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)(width - 4), (int)(height - 4), (int)4, (int)4, (float)5.0f, (float)77.0f, (int)4, (int)4, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)0, (int)(height - 4), (int)4, (int)4, (float)0.0f, (float)77.0f, (int)4, (int)4, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)4, (int)0, (int)(width - 8), (int)4, (float)4.0f, (float)72.0f, (int)1, (int)4, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)0, (int)4, (int)4, (int)(height - 8), (float)0.0f, (float)76.0f, (int)4, (int)1, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)(width - 4), (int)4, (int)4, (int)(height - 8), (float)5.0f, (float)76.0f, (int)4, (int)1, (int)256, (int)256);
        LoreScreen.method_25293((class_4587)matrices, (int)4, (int)(height - 4), (int)(width - 8), (int)4, (float)4.0f, (float)77.0f, (int)1, (int)4, (int)256, (int)256);
        matrices.method_22909();
    }

    private static final class LoreEntry
    implements FloatyDrawableHelper {
        private static final int HOVER_LIMIT = 20;
        private final int x;
        private final int y;
        @NotNull
        private final LoreType type;
        @NotNull
        private final class_1799 stack;
        @NotNull
        private final class_2561 title;
        private final List<class_5481> description;
        @NotNull
        private final @NotNull Set<@NotNull LoreEntry> requirements;
        private final int width;
        private final int height;
        private boolean hover = false;
        private float hoverTime = 0.0f;

        private LoreEntry(int x, int y, @NotNull LoreType type, @NotNull class_1799 stack, @NotNull class_2561 title, @NotNull class_2561 description, @NotNull @NotNull Set<@NotNull LoreEntry> requirements) {
            Objects.requireNonNull(type, "type was null");
            Objects.requireNonNull(stack, "stack was null");
            Objects.requireNonNull(title, "title was null");
            Objects.requireNonNull(description, "description was null");
            Objects.requireNonNull(requirements, "requirements was null");
            this.x = x - (type.getWidth() >> 1);
            this.y = y - (type.getHeight() >> 1);
            this.type = type;
            this.stack = stack;
            if (title instanceof class_5250) {
                class_5250 mutableTitle = (class_5250)title;
                this.title = mutableTitle.method_10862(title.method_10866().method_10982(Boolean.valueOf(true)));
            } else {
                this.title = title;
            }
            this.requirements = requirements;
            class_327 textRenderer = class_310.method_1551().field_1772;
            this.width = Math.max(textRenderer.method_27525((class_5348)this.title), 100) + 2;
            this.description = textRenderer.method_1728((class_5348)description, this.width);
            this.height = 9 * (this.description.size() + 1);
        }

        private LoreEntry(int x, int y, @NotNull LoreType type, @NotNull class_1799 stack, @NotNull class_2561 title, @NotNull class_2561 description, LoreEntry ... requirements) {
            this(x, y, type, stack, title, description, Set.of(Objects.requireNonNull(requirements, "requirements was null")));
        }

        private LoreEntry(int x, int y, @NotNull LoreType type, @NotNull class_1935 item, @NotNull class_2561 title, @NotNull class_2561 description) {
            this(x, y, type, new class_1799(Objects.requireNonNull(item, "item was null")), title, description, Set.of());
        }

        private LoreEntry(int x, int y, @NotNull LoreType type, @NotNull class_1935 item, @NotNull class_2561 title, @NotNull class_2561 description, LoreEntry ... requirements) {
            this(x, y, type, new class_1799(Objects.requireNonNull(item, "item was null")), title, description, Set.of(Objects.requireNonNull(requirements, "requirements was null")));
        }

        LoreEntry(net.id.paradiselost.lore.LoreEntry<?> entry) {
            this(entry.x(), entry.y(), LoreType.NORMAL, entry.stack(), entry.getTitleText(), entry.getDescriptionText(), new LoreEntry[0]);
        }

        public void setHovered(boolean hovered) {
            this.hover = hovered;
        }

        public void tick(float delta) {
            if (this.hover) {
                if (this.hoverTime < 20.0f) {
                    this.hoverTime = Math.min(this.hoverTime + delta, 20.0f);
                }
            } else if (this.hoverTime > 0.0f) {
                this.hoverTime = Math.max(this.hoverTime - delta, 0.0f);
            }
        }

        private void drawLines(class_4587 matrices, class_4588 lineBuffer, int x, int y) {
            if (!this.requirements.isEmpty()) {
                int startX = this.x + x;
                int startY = this.y + y;
                class_4587.class_4665 entry = matrices.method_23760();
                class_1159 model = entry.method_23761();
                class_4581 normal = entry.method_23762();
                for (LoreEntry child : this.requirements) {
                    lineBuffer.method_22918(model, (float)startX, (float)startY, 0.0f).method_1336(1, 0, 1, 0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                    lineBuffer.method_22918(model, (float)(child.x + x), (float)(child.y + y), 0.0f).method_1336(1, 0, 1, 0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                }
            }
        }

        private void drawBackground(class_4587 matrices, int x, int y) {
            x += this.x;
            y += this.y;
            if (this.hover) {
                this.drawTexture(matrices, x, y, this.type.getU() + this.type.getWidth(), this.type.getV(), this.type.getWidth(), this.type.getHeight());
            } else {
                this.drawTexture(matrices, x, y, this.type.getU(), this.type.getV(), this.type.getWidth(), this.type.getHeight());
            }
            if (this.hoverTime > 0.0f) {
                float boxWidth = this.width;
                boxWidth *= Math.min(this.hoverTime / 20.0f, 20.0f);
                float boxHeight = this.height;
                boxHeight *= Math.min(this.hoverTime / 20.0f, 20.0f);
                matrices.method_22903();
                matrices.method_22904(0.0, 0.0, 1.0);
                this.drawFrame(matrices, x, y + this.type.getHeight(), boxWidth += 8.0f, boxHeight += 8.0f);
                matrices.method_22909();
            }
        }

        private void drawForeground(class_4587 matrices, int x, int y) {
            if (this.hoverTime > 0.0f) {
                matrices.method_22903();
                float scale = this.hoverTime / 20.0f;
                matrices.method_22904((double)(this.x + x + 4), (double)(this.y + y + this.type.getHeight() + 4), 1.0);
                matrices.method_22905(scale, scale, 1.0f);
                class_327 textRenderer = class_310.method_1551().field_1772;
                textRenderer.method_30881(matrices, this.title, 1.0f, 1.0f, 0xFFFFFF);
                int yOff = 10;
                for (class_5481 line : this.description) {
                    textRenderer.method_27517(matrices, line, 1.0f, (float)yOff, 0xFFFFFF);
                    yOff += 9;
                }
                matrices.method_22909();
            }
        }

        private void drawStack(int x, int y) {
            class_310 client = class_310.method_1551();
            class_918 itemRenderer = client.method_1480();
            class_327 textRenderer = client.field_1772;
            itemRenderer.method_4023(this.stack, x += this.x + this.type.getItemX(), y += this.y + this.type.getItemY());
            itemRenderer.method_4022(textRenderer, this.stack, x, y, "");
        }

        private void drawFrame(class_4587 matrices, int x, int y, float width, float height) {
            matrices.method_22903();
            matrices.method_22904((double)x, (double)y, 0.0);
            this.drawTexture(matrices, 0.0f, 0.0f, 4.0f, 4.0f, 17.0f, 0.0f, 4.0f, 4.0f, 256.0f, 256.0f);
            this.drawTexture(matrices, width - 4.0f, 0.0f, 4.0f, 4.0f, 22.0f, 0.0f, 4.0f, 4.0f, 256.0f, 256.0f);
            this.drawTexture(matrices, width - 4.0f, height - 4.0f, 4.0f, 4.0f, 22.0f, 5.0f, 4.0f, 4.0f, 256.0f, 256.0f);
            this.drawTexture(matrices, 0.0f, height - 4.0f, 4.0f, 4.0f, 17.0f, 5.0f, 4.0f, 4.0f, 256.0f, 256.0f);
            this.drawTexture(matrices, 4.0f, 0.0f, width - 8.0f, 4.0f, 21.0f, 0.0f, 1.0f, 4.0f, 256.0f, 256.0f);
            this.drawTexture(matrices, 0.0f, 4.0f, 4.0f, height - 8.0f, 17.0f, 4.0f, 4.0f, 1.0f, 256.0f, 256.0f);
            this.drawTexture(matrices, width - 4.0f, 4.0f, 4.0f, height - 8.0f, 22.0f, 4.0f, 4.0f, 1.0f, 256.0f, 256.0f);
            this.drawTexture(matrices, 4.0f, height - 4.0f, width - 8.0f, 4.0f, 21.0f, 5.0f, 1.0f, 4.0f, 256.0f, 256.0f);
            this.drawTexture(matrices, 4.0f, 4.0f, width - 8.0f, height - 8.0f, 21.0f, 4.0f, 1.0f, 1.0f, 256.0f, 256.0f);
            matrices.method_22909();
        }
    }
}

