/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.mixin.entity;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Optional;
import net.id.paradiselost.component.MoaGenes;
import net.id.paradiselost.entities.ParadiseLostEntityExtensions;
import net.id.paradiselost.entities.ParadiseLostEntityTypes;
import net.id.paradiselost.entities.misc.RookEntity;
import net.id.paradiselost.entities.passive.moa.MoaAttributes;
import net.id.paradiselost.entities.passive.moa.MoaEntity;
import net.id.paradiselost.tag.ParadiseLostItemTags;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements ParadiseLostEntityExtensions {
    private boolean flipped = false;
    private int gravFlipTime;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Override
    public boolean getFlipped() {
        return this.flipped;
    }

    @Override
    public void setFlipped() {
        this.flipped = true;
        this.gravFlipTime = 0;
    }

    @Shadow
    public abstract boolean method_6059(class_1291 var1);

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE_ASSIGN", ordinal=0, target="Lnet/minecraft/world/World;getFluidState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/fluid/FluidState;"))
    private double changeGravity(double gravity) {
        boolean isFalling;
        class_1309 entity = (class_1309)this;
        boolean bl = isFalling = this.method_18798().field_1351 <= 0.0;
        if (isFalling && !this.method_6059(class_1294.field_5906) && !this.method_5799() && !this.method_5715()) {
            boolean isWearingParachute;
            Optional componentOptional = TrinketsApi.getTrinketComponent((class_1309)entity);
            boolean bl2 = isWearingParachute = componentOptional.isPresent() && ((TrinketComponent)componentOptional.get()).isEquipped(e -> e.method_31573(ParadiseLostItemTags.PARACHUTES));
            if (isWearingParachute) {
                gravity -= 0.07;
                this.field_6017 = 0.0f;
            } else if (entity.method_5782() && entity.method_5685().stream().anyMatch(passenger -> passenger.method_5864().equals(ParadiseLostEntityTypes.PARADISE_HARE))) {
                gravity -= 0.05;
                this.field_6017 = 0.0f;
            }
        }
        return gravity;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if (this.flipped) {
            ++this.gravFlipTime;
            if (this.gravFlipTime > 20) {
                this.flipped = false;
                this.field_6017 = 0.0f;
            }
            if (!this.method_5740()) {
                class_243 antiGravity = new class_243(0.0, 0.12, 0.0);
                this.method_18799(this.method_18798().method_1019(antiGravity));
            }
        }
    }

    @Inject(method={"getMaxHealth"}, at={@At(value="HEAD")}, cancellable=true)
    private void getMoaMaxHealth(CallbackInfoReturnable<Float> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof MoaEntity) {
            MoaEntity moa = (MoaEntity)((Object)livingEntityMixin);
            MoaGenes genes = moa.getGenes();
            cir.setReturnValue((Object)Float.valueOf(genes.isInitialized() ? genes.getAttribute(MoaAttributes.MAX_HEALTH) : 40.0f));
            cir.cancel();
        }
    }

    @Inject(method={"addDeathParticles"}, at={@At(value="HEAD")}, cancellable=true)
    private void applyCustomDeathParticles(CallbackInfo ci) {
        if ((class_1309)this instanceof RookEntity) {
            for (int i = 0; i < 20 + this.field_5974.method_43048(20); ++i) {
                double d = this.field_5974.method_43059() * 0.02;
                double e = this.field_5974.method_43059() * 0.02;
                double f = this.field_5974.method_43059() * 0.02;
                if (this.field_5974.method_43048(3) == 0) {
                    this.field_6002.method_8406((class_2394)class_2398.field_11237, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), d, e, f);
                } else {
                    this.field_6002.method_8406((class_2394)class_2398.field_11251, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), d, e, f);
                }
                if (this.field_5974.method_43048(3) != 0) continue;
                this.field_6002.method_8406((class_2394)class_2398.field_17430, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), d / 3.0, e, f / 3.0);
            }
            ci.cancel();
        }
    }
}

