/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.lore;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.id.paradiselost.ParadiseLost;
import net.id.paradiselost.component.ParadiseLostComponents;
import net.id.paradiselost.items.ParadiseLostItems;
import net.id.paradiselost.lore.LoreEntry;
import net.id.paradiselost.lore.LoreState;
import net.id.paradiselost.lore.LoreStatus;
import net.id.paradiselost.lore.LoreTriggerType;
import net.id.paradiselost.registry.ParadiseLostRegistries;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public final class ParadiseLostLore {
    private static final Map<LoreTriggerType, Set<LoreEntry<?>>> TRIGGER_MAP = new Object2ObjectOpenHashMap();
    public static final LoreEntry<Void> ROOT = ParadiseLostLore.register("root", new LoreEntry(0, 0, (class_1935)ParadiseLostItems.LORE_BOOK, new LoreEntry[0]));
    public static final LoreEntry<class_1799> ITEM_TEST = ParadiseLostLore.register("item_test", new LoreEntry<class_1799>(0, 0, (class_1935)class_1802.field_8477, LoreTriggerType.ITEM, stack -> stack.method_7909().equals(class_1802.field_8477), new LoreEntry[0]));

    public static void init() {
    }

    private static <T> LoreEntry<T> register(@NotNull String name, @NotNull LoreEntry<T> lore) {
        return ParadiseLostLore.register(ParadiseLost.locate(name), lore);
    }

    public static <T> LoreEntry<T> register(@NotNull class_2960 id, @NotNull LoreEntry<T> lore) {
        Objects.requireNonNull(id, "id was null");
        Objects.requireNonNull(lore, "lore was null");
        TRIGGER_MAP.computeIfAbsent(lore.triggerType(), key -> new HashSet()).add(lore);
        return (LoreEntry)class_2378.method_10230(ParadiseLostRegistries.LORE_REGISTRY, (class_2960)id, lore);
    }

    public static <T> void trigger(@NotNull LoreTriggerType triggerType, @NotNull class_3222 player, @NotNull T object) {
        LoreState state = (LoreState)ParadiseLostComponents.LORE_STATE.get((Object)player);
        for (LoreEntry lore : TRIGGER_MAP.getOrDefault((Object)triggerType, Set.of())) {
            class_2960 id = lore.getId();
            LoreStatus status = state.getLoreStatus(id);
            if (status != LoreStatus.LOCKED || !lore.trigger().test(object)) continue;
            state.setLoreStatus(id, LoreStatus.COMPLETED);
        }
    }
}

