/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.lore;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;

public enum LoreStatus {
    HIDDEN,
    LOCKED,
    FREE,
    UNLOCKED,
    COMPLETED;

    private final String name = this.name().toLowerCase(Locale.ROOT);
    private static final Map<String, LoreStatus> VALUES;

    public String getName() {
        return this.name;
    }

    public static LoreStatus ofValue(String string) {
        LoreStatus status = VALUES.get(string);
        if (status == null) {
            throw new IllegalArgumentException("Unknown lore status: " + string);
        }
        return status;
    }

    public static LoreStatus ofValue(int ordinal) {
        LoreStatus[] values = LoreStatus.values();
        if (ordinal >= values.length || ordinal < 0) {
            throw new IllegalArgumentException("Unknown lore status ordinal: " + ordinal);
        }
        return values[ordinal];
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (LoreStatus status : LoreStatus.values()) {
            builder.put((Object)status.name, (Object)status);
        }
        VALUES = builder.build();
    }
}

