/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.lore;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.id.paradiselost.component.ParadiseLostComponents;
import net.id.paradiselost.lore.LoreEntry;
import net.id.paradiselost.lore.LoreStatus;
import net.id.paradiselost.lore.ParadiseLostLore;
import net.id.paradiselost.mixin.util.NbtCompoundAccessor;
import net.id.paradiselost.registry.ParadiseLostRegistries;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;

public interface LoreState
extends AutoSyncedComponent {
    @NotNull
    default public LoreStatus getLoreStatus(@NotNull class_2960 id) {
        Objects.requireNonNull(id, "Identifier was null");
        LoreEntry lore = (LoreEntry)ParadiseLostRegistries.LORE_REGISTRY.method_10223(id);
        if (lore == null) {
            throw new RuntimeException("Unknown lore entry: " + id);
        }
        return this.getLoreStatus(lore);
    }

    default public void setLoreStatus(@NotNull class_2960 id, @NotNull LoreStatus status) {
        Objects.requireNonNull(id, "id was null");
        Objects.requireNonNull(status, "status was null");
        LoreEntry lore = (LoreEntry)ParadiseLostRegistries.LORE_REGISTRY.method_10223(id);
        if (lore == null) {
            throw new RuntimeException("Unknown lore entry: " + id);
        }
        this.setLoreStatus(lore, status);
    }

    @NotNull
    public LoreStatus getLoreStatus(@NotNull LoreEntry<?> var1);

    public void setLoreStatus(@NotNull LoreEntry<?> var1, @NotNull LoreStatus var2);

    public static class ToastTriggerer {
        @Environment(value=EnvType.CLIENT)
        public static void triggerToast(class_2960 id) {
            ParadiseLostRegistries.LORE_REGISTRY.method_17966(id).ifPresent(lore -> class_310.method_1551().method_1566().method_1999(new class_368((LoreEntry)lore){
                final /* synthetic */ LoreEntry val$lore;
                {
                    this.val$lore = loreEntry;
                }

                public class_368.class_369 method_1986(class_4587 matrices, class_374 manager, long startTime) {
                    RenderSystem.setShader(class_757::method_34542);
                    RenderSystem.setShaderTexture((int)0, (class_2960)field_2207);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    manager.method_25302(matrices, 0, 0, 0, 0, this.method_29049(), this.method_29050());
                    List list = manager.method_1995().field_1772.method_1728((class_5348)this.val$lore.getTitleText(), 125);
                    int color = 0xFFFF00;
                    if (list.size() == 1) {
                        manager.method_1995().field_1772.method_30883(matrices, class_2561.method_30163((String)"TODO"), 30.0f, 7.0f, color | 0xFF000000);
                        manager.method_1995().field_1772.method_27528(matrices, (class_5481)list.get(0), 30.0f, 18.0f, -1);
                    } else if (startTime < 1500L) {
                        int l = class_3532.method_15375((float)(class_3532.method_15363((float)((float)(1500L - startTime) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
                        manager.method_1995().field_1772.method_30883(matrices, class_2561.method_30163((String)"TODO"), 30.0f, 11.0f, color | l);
                    } else {
                        int l = class_3532.method_15375((float)(class_3532.method_15363((float)((float)(startTime - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
                        int var10000 = this.method_29050() / 2;
                        int var10001 = list.size();
                        Objects.requireNonNull(manager.method_1995().field_1772);
                        int m = var10000 - var10001 * 9 / 2;
                        for (class_5481 orderedText : list) {
                            manager.method_1995().field_1772.method_27528(matrices, orderedText, 30.0f, (float)m, 0xFFFFFF | l);
                            Objects.requireNonNull(manager.method_1995().field_1772);
                            m += 9;
                        }
                    }
                    manager.method_1995().method_1480().method_27953(this.val$lore.stack(), 8, 8);
                    return startTime >= 5000L ? class_368.class_369.field_2209 : class_368.class_369.field_2210;
                }
            }));
        }
    }

    public static final class Impl
    implements LoreState {
        private final Map<LoreEntry<?>, LoreStatus> loreStates = new Object2ObjectOpenHashMap();
        private final Set<LoreEntry<?>> dirtyLore = new HashSet();
        private final class_1657 player;
        private final boolean isClient;
        private static final Map<class_2960, Set<LoreEntry<?>>> CHILDREN = new HashMap();

        public Impl(class_1657 player) {
            this.player = player;
            this.isClient = player.field_6002.method_8608();
        }

        public void readFromNbt(class_2487 tag) {
            class_2487 statuses = tag.method_10562("statuses");
            this.loreStates.clear();
            ((NbtCompoundAccessor)statuses).getEntries().forEach((key, value) -> this.loreStates.put((LoreEntry)ParadiseLostRegistries.LORE_REGISTRY.method_10223(new class_2960(key)), LoreStatus.ofValue(value.method_10714())));
            this.dirtyLore.addAll(this.loreStates.keySet());
            this.validate();
        }

        private void validate() {
        }

        public void writeToNbt(class_2487 tag) {
            class_2487 statuses = new class_2487();
            this.loreStates.forEach((key, value) -> statuses.method_10582(key.toString(), value.getName()));
        }

        public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
            buf.method_10804(this.dirtyLore.size());
            for (LoreEntry<?> lore : this.dirtyLore) {
                buf.method_10812(lore.getId());
                buf.method_10804(this.loreStates.getOrDefault(lore, LoreStatus.HIDDEN).ordinal());
            }
            this.dirtyLore.clear();
        }

        public void applySyncPacket(class_2540 buf) {
            int count = buf.method_10816();
            for (int i = 0; i < count; ++i) {
                class_2960 id = buf.method_10810();
                LoreStatus status = LoreStatus.ofValue(buf.method_10816());
                LoreStatus oldStatus = this.loreStates.put((LoreEntry)ParadiseLostRegistries.LORE_REGISTRY.method_10223(id), status);
                if (!this.isClient || oldStatus == status || status != LoreStatus.COMPLETED) continue;
                ToastTriggerer.triggerToast(id);
            }
        }

        @Override
        @NotNull
        public LoreStatus getLoreStatus(@NotNull LoreEntry<?> lore) {
            if (lore.equals(ParadiseLostLore.ROOT)) {
                return LoreStatus.COMPLETED;
            }
            return this.loreStates.getOrDefault(lore, LoreStatus.HIDDEN);
        }

        @Override
        public void setLoreStatus(@NotNull LoreEntry<?> lore, @NotNull LoreStatus status) {
            Objects.requireNonNull(lore, "lore was null");
            Objects.requireNonNull(status, "status was null");
            if (!this.isClient) {
                throw new IllegalStateException("setLoreStatus was called on the client");
            }
            LoreStatus existing = this.loreStates.put(lore, status);
            if (existing != status) {
                this.dirtyLore.add(lore);
                if (status == LoreStatus.COMPLETED) {
                    this.getChildren(lore).forEach(child -> {
                        if (this.getLoreStatus((LoreEntry<?>)child) == LoreStatus.HIDDEN) {
                            this.setLoreStatus((LoreEntry<?>)child, LoreStatus.LOCKED);
                        }
                    });
                }
                ParadiseLostComponents.LORE_STATE.sync((Object)this.player);
            }
        }

        public Set<LoreEntry<?>> getChildren(LoreEntry<?> lore) {
            Set<LoreEntry<Object>> children = CHILDREN.get(lore.getId());
            if (children != null) {
                return children;
            }
            HashSet newChildren = new HashSet();
            ParadiseLostRegistries.LORE_REGISTRY.forEach(entry -> {
                if (entry.prerequisites().contains(lore)) {
                    newChildren.add(entry);
                }
            });
            children = newChildren.isEmpty() ? Set.of() : Collections.unmodifiableSet(newChildren);
            CHILDREN.put(lore.getId(), children);
            return children;
        }
    }
}

