/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.entities.passive.moa;

import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.id.paradiselost.blocks.blockentity.FoodBowlBlockEntity;
import net.id.paradiselost.component.MoaGenes;
import net.id.paradiselost.entities.ParadiseLostEntityTypes;
import net.id.paradiselost.entities.passive.moa.MoaAttributes;
import net.id.paradiselost.entities.util.SaddleMountEntity;
import net.id.paradiselost.items.ParadiseLostItems;
import net.id.paradiselost.items.tools.bloodstone.BloodstoneItem;
import net.id.paradiselost.screen.handler.MoaScreenHandler;
import net.id.paradiselost.tag.ParadiseLostItemTags;
import net.id.paradiselost.util.ParadiseLostSoundEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1265;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1316;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1367;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_4538;
import net.minecraft.class_4739;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6025;
import net.minecraft.class_7248;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoaEntity
extends SaddleMountEntity
implements class_1316,
class_6025,
class_1265,
class_7248 {
    private static final class_1277 DUMMY = new class_1277(0);
    public static final class_2940<Integer> AIR_TICKS = class_2945.method_12791(MoaEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_1799> CHEST = class_2945.method_12791(MoaEntity.class, (class_2941)class_2943.field_13322);
    public float curWingRoll;
    public float curWingYaw;
    public float curLegPitch;
    public float jumpStrength;
    public boolean isInAir;
    protected int secsUntilEgg;
    private MoaGenes genes;
    @NotNull
    private class_1277 inventory = DUMMY;

    public MoaEntity(class_1299<? extends MoaEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6013 = 1.0f;
        this.secsUntilEgg = this.getRandomEggTime();
        this.refreshChest(false);
    }

    public static class_5132.class_5133 createMoaAttributes() {
        return MoaEntity.method_26828().method_26868(class_5134.field_23716, 35.0).method_26868(class_5134.field_23719, 1.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new MoaEscapeDangerGoal((class_1314)this, 2.0));
        this.field_6201.method_6277(2, (class_1352)new EatFromBowlGoal(1.0, 24, 16));
        this.field_6201.method_6277(3, (class_1352)new class_1341((class_1429)this, 0.25));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.0, class_1856.method_8106(ParadiseLostItemTags.MOA_TEMPTABLES), false));
        this.field_6201.method_6277(5, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, (double)0.4f));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 4.5f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        if (!this.genes.isInitialized()) {
            this.genes.initMoa(this);
            this.method_6033(this.genes.getAttribute(MoaAttributes.MAX_HEALTH));
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public void method_5784(class_1313 movement, class_243 motion) {
        super.method_5784(movement, motion);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(AIR_TICKS, (Object)0);
        this.field_6011.method_12784(CHEST, (Object)class_1799.field_8037);
    }

    public class_1799 getChest() {
        return (class_1799)this.field_6011.method_12789(CHEST);
    }

    public boolean hasChest() {
        return !this.getChest().method_7960();
    }

    public void setChest(class_1799 stack) {
        class_1747 blockItem;
        class_1792 class_17922;
        if (!(stack.method_7960() || (class_17922 = stack.method_7909()) instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof class_4739)) {
            throw new IllegalArgumentException("Can not set a Moa chest to be a non-chest or empty item stack!");
        }
        this.field_6011.method_12778(CHEST, (Object)stack);
        this.refreshChest(true);
    }

    public void refreshChest(boolean scatterItems) {
        if (this.hasChest()) {
            if (this.inventory.method_5439() != 20) {
                this.inventory = new class_1277(20);
                this.inventory.method_5489((class_1265)this);
            }
        } else if (this.inventory.method_5439() != 0) {
            this.inventory.method_5488((class_1265)this);
            if (scatterItems && !this.field_6002.field_9236) {
                class_1264.method_5452((class_1937)this.field_6002, (class_1297)this, (class_1263)this.inventory);
            }
            this.inventory.method_5448();
            this.inventory = DUMMY;
        }
    }

    @Override
    protected void method_16078() {
        super.method_16078();
        if (this.hasChest()) {
            if (!this.field_6002.field_9236) {
                this.method_5775(this.getChest());
            }
            this.setChest(class_1799.field_8037);
        }
    }

    public float getWingRoll() {
        if (!this.isGliding()) {
            float baseWingRoll = 1.39626f;
            float lDif = -baseWingRoll - this.curWingRoll;
            if (Math.abs(lDif) > 0.005f) {
                this.curWingRoll += lDif / 6.0f;
            }
        } else {
            this.curWingRoll = class_3532.method_15374((float)((float)this.field_6012 / 1.75f)) * 0.725f + 0.1f;
        }
        return this.curWingRoll;
    }

    public float getWingYaw() {
        float baseWingYaw = this.isGliding() ? 0.95626f : 0.174533f;
        float lDif = -baseWingYaw - this.curWingYaw;
        if (Math.abs(lDif) > 0.005f) {
            this.curWingYaw = (float)((double)this.curWingYaw + (double)lDif / 12.75);
        }
        return this.curWingYaw;
    }

    public float getLegPitch() {
        float baseLegPitch = this.isGliding() ? -1.5708f : 0.0174533f;
        float lDif = -baseLegPitch - this.curLegPitch;
        if (Math.abs(lDif) > 0.005f) {
            this.curLegPitch += lDif / 6.0f;
        }
        return this.curLegPitch;
    }

    public int getRandomEggTime() {
        return 775 + this.field_5974.method_43048(50);
    }

    protected void method_6013(class_1282 source) {
        this.field_6002.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), ParadiseLostSoundEvents.ENTITY_MOA_HURT, class_3419.field_15254, 0.225f, class_3532.method_15363((float)this.field_5974.method_43057(), (float)0.5f, (float)0.7f) + class_3532.method_15363((float)this.field_5974.method_43057(), (float)0.0f, (float)0.15f));
    }

    public void method_5773() {
        super.method_5773();
        boolean bl = this.isInAir = !this.field_5952;
        if (this.isInAir) {
            this.field_6011.method_12778(AIR_TICKS, (Object)((Integer)this.field_6011.method_12789(AIR_TICKS) + 1));
        } else {
            this.field_6011.method_12778(AIR_TICKS, (Object)0);
        }
        if (this.field_6012 % 15 == 0) {
            if (this.isGliding()) {
                this.field_6002.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), ParadiseLostSoundEvents.ENTITY_MOA_GLIDING, class_3419.field_15254, 4.5f, class_3532.method_15363((float)this.field_5974.method_43057(), (float)0.85f, (float)1.2f) + class_3532.method_15363((float)this.field_5974.method_43057(), (float)0.0f, (float)0.35f));
            } else if (this.field_5974.method_43057() < 0.057334f) {
                this.field_6002.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), ParadiseLostSoundEvents.ENTITY_MOA_AMBIENT, class_3419.field_15254, 1.5f + this.field_5974.method_43057() * 2.0f, class_3532.method_15363((float)this.field_5974.method_43057(), (float)0.55f, (float)0.7f) + class_3532.method_15363((float)this.field_5974.method_43057(), (float)0.0f, (float)0.25f));
            }
        }
        if (this.field_6282) {
            this.method_18799(this.method_18798().method_1031(0.0, 0.05, 0.0));
        }
        this.fall();
        if (this.method_5782()) {
            this.method_31748().forEach(entity -> {
                entity.field_6017 = 0.0f;
            });
        }
        MoaGenes genes = this.getGenes();
        float hunger = genes.getHunger();
        if (genes.isTamed() && this.field_5974.method_43056()) {
            genes.setHunger(hunger - 8.333333E-5f);
        }
        if (this.method_6032() < this.method_6063() && hunger > 65.0f && this.field_6002.method_8510() % 20L == 0L && this.field_5974.method_43056()) {
            this.method_6025(1.0f);
            genes.setHunger(hunger - 0.5f);
        }
        if (hunger < 20.0f && this.field_6002.method_8510() % 10L == 0L) {
            this.produceParticlesServer((class_2394)class_2398.field_11231, this.field_5974.method_43048(3), 1, 0.0f);
            if (hunger < 10.0f && this.method_5782()) {
                this.method_5772();
                this.method_5783(ParadiseLostSoundEvents.ENTITY_MOA_DEATH, 1.0f, 1.5f + this.field_5974.method_43057() * 0.5f);
            }
        }
        if (this.getGenes().getRace().legendary() && this.method_18798().method_1027() <= 0.02 && this.field_5974.method_43057() < 0.1f && this.field_5974.method_43056()) {
            this.produceParticles((class_2394)this.getGenes().getRace().particles(), 5, 0.25f);
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected class_2561 method_23315() {
        return class_2561.method_43469((String)this.getGenes().getRace().getTranslationKey(), (Object[])new Object[]{"Moa"});
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return 0;
    }

    public boolean isGliding() {
        return !this.method_5799() && (Integer)this.field_6011.method_12789(AIR_TICKS) > 20;
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return stack.method_7909() == ParadiseLostItems.ORANGE;
    }

    @Override
    public boolean method_6765() {
        return this.getGenes().isTamed() && super.method_6765();
    }

    @Override
    public boolean canBeControlledByRider() {
        return this.method_6725();
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_5805()) {
            class_1309 livingEntity = (class_1309)this.method_5642();
            if (this.method_5782() && livingEntity != null && this.canBeControlledByRider()) {
                this.field_5982 = this.method_36454();
                this.method_36456(livingEntity.method_36454());
                this.method_36457(livingEntity.method_36455() * 0.5f);
                this.method_5710(this.method_36454(), this.method_36455());
                this.field_6241 = this.field_6283 = this.method_36454();
                float f = livingEntity.field_6212 * 0.5f;
                float g = livingEntity.field_6250;
                if (g <= 0.0f) {
                    g *= 0.25f;
                }
                if (this.jumpStrength > 0.0f && !this.isInAir && this.field_5952) {
                    double d = (double)0.1f * (double)this.jumpStrength * (double)this.method_23313();
                    double h = this.method_6059(class_1294.field_5913) ? d + (double)((float)(this.method_6112(class_1294.field_5913).method_5578() + 1) * 0.1f) : d;
                    class_243 vec3d = this.method_18798();
                    this.method_18800(vec3d.field_1352, h, vec3d.field_1350);
                    this.field_6007 = true;
                    if (g > 0.0f) {
                        float adjVel = this.jumpStrength / 2.0f;
                        float i = class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)));
                        float j = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)));
                        this.method_18799(this.method_18798().method_1031((double)(-0.4f * i * adjVel), 0.0, (double)(0.4f * j * adjVel)));
                    }
                    this.jumpStrength = 0.0f;
                }
                if (this.jumpStrength <= 0.01f && this.field_5952) {
                    this.jumpStrength = 0.0f;
                    this.field_6282 = false;
                    this.isInAir = false;
                }
                this.field_6281 = this.getFlyingSpeed();
                if (this.method_5787()) {
                    this.method_6125(this.getMountedMoveSpeed());
                    super.method_6091(new class_243((double)f, movementInput.field_1351, (double)g));
                } else if (livingEntity instanceof class_1657) {
                    this.method_18799(class_243.field_1353);
                }
                this.method_29242((class_1309)this, false);
            } else {
                this.field_6281 = this.getFlyingSpeed();
                super.method_6091(movementInput);
            }
            if (this.getGenes().getRace().legendary() && this.method_18798().method_1027() > 0.02 && this.field_5974.method_43057() < 0.55f) {
                this.produceParticles((class_2394)this.getGenes().getRace().particles(), 3, 0.25f);
            }
        }
    }

    @Override
    public float getMountedMoveSpeed() {
        return this.method_6029() * 0.75f;
    }

    @Override
    public float method_6029() {
        return this.getGenes().getAttribute(MoaAttributes.GROUND_SPEED) * 0.65f;
    }

    public float getFlyingSpeed() {
        return this.isGliding() ? this.getGenes().getAttribute(MoaAttributes.GLIDING_SPEED) * 0.8f : this.method_6029() * 0.1f;
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (player.method_5998(hand).method_7909() instanceof BloodstoneItem) {
            return class_1269.field_5811;
        }
        if (!this.field_6002.method_8608()) {
            class_1799 heldStack = player.method_5998(hand);
            if (this.getGenes().isTamed()) {
                class_1747 blockItem;
                if (player.method_5715()) {
                    this.method_6722(player);
                    return class_1269.field_5812;
                }
                if (heldStack.method_7960()) {
                    return super.method_5992(player, hand);
                }
                class_1792 item = heldStack.method_7909();
                if (item.method_19263() && item.method_19264().method_19232()) {
                    this.feedMob(heldStack);
                    return class_1269.method_29236((boolean)this.field_6002.method_8608());
                }
                if (!this.hasChest() && item instanceof class_1747 && (blockItem = (class_1747)item).method_7711() instanceof class_4739) {
                    class_1799 chestStack = heldStack.method_7972();
                    chestStack.method_7939(1);
                    if (!player.method_7337()) {
                        heldStack.method_7934(1);
                    }
                    this.setChest(heldStack);
                    return class_1269.method_29236((boolean)this.field_6002.field_9236);
                }
            } else if (heldStack.method_7909() != ParadiseLostItems.ORANGE && heldStack.method_31573(ParadiseLostItemTags.MOA_TEMPTABLES)) {
                this.method_6475(player, hand, heldStack);
                this.method_5783(ParadiseLostSoundEvents.ENTITY_MOA_EAT, 1.0f, 0.5f + this.field_5974.method_43057() / 3.0f);
                this.produceParticlesServer((class_2394)new class_2392(class_2398.field_11218, heldStack), 2 + this.field_5974.method_43048(4), 7, 0.0f);
                float f = this.field_5974.method_43057();
                int n = heldStack.method_19267() ? heldStack.method_7909().method_19264().method_19230() : 2;
                if (f < 0.04f * (float)n) {
                    this.getGenes().tame(player.method_5667());
                    this.method_5783(ParadiseLostSoundEvents.ENTITY_MOA_AMBIENT, 2.0f, 0.75f);
                    this.produceParticlesServer((class_2394)class_2398.field_11211, 2 + this.field_5974.method_43048(4), 7, 0.0f);
                    if (player instanceof class_3222) {
                        class_174.field_1201.method_9132((class_3222)player, (class_1429)this);
                    }
                }
                return class_1269.field_21466;
            }
        }
        return super.method_5992(player, hand);
    }

    private void feedMob(class_1799 heldStack) {
        float hungerRestored = heldStack.method_7909().method_19264().method_19230() * 4;
        float satiation = this.getGenes().getHunger();
        float hunger = 100.0f - satiation;
        if (hunger > 1.0f) {
            int consumption = Math.min((int)Math.ceil(hunger / hungerRestored), heldStack.method_7947());
            this.method_6098(heldStack, 10 + this.field_5974.method_43048(consumption * 2 + 1));
            heldStack.method_7934(consumption);
            this.getGenes().setHunger(satiation + (float)consumption * hungerRestored);
            this.method_5783(ParadiseLostSoundEvents.ENTITY_MOA_EAT, 1.5f, 0.8f);
            this.produceParticles((class_2394)class_2398.field_11211);
        }
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("airTicks", ((Integer)this.field_6011.method_12789(AIR_TICKS)).intValue());
        compound.method_10566("chest", (class_2520)((class_1799)this.field_6011.method_12789(CHEST)).method_7953(new class_2487()));
        if (this.inventory != DUMMY) {
            compound.method_10566("chestContents", (class_2520)this.inventory.method_7660());
        }
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(AIR_TICKS, (Object)compound.method_10550("airTicks"));
        this.field_6011.method_12778(CHEST, (Object)class_1799.method_7915((class_2487)compound.method_10562("chest")));
        this.refreshChest(false);
        if (this.inventory != DUMMY) {
            this.inventory.method_7659(compound.method_10554("chestContents", 10));
        }
    }

    public boolean method_27298() {
        return Math.abs(this.method_18798().method_18805(1.0, 0.0, 1.0).method_1033()) > 0.0 && !this.method_5799() && !this.isGliding();
    }

    public void method_24650(class_3218 world, class_1429 other) {
        MoaGenes genes = this.getGenes();
        if (genes.getHunger() > 80.0f) {
            class_1799 egg = genes.getEggForBreeding(((MoaEntity)other).genes, (class_1937)world, this.method_24515());
            this.method_5783(ParadiseLostSoundEvents.ENTITY_MOA_LAY_EGG, 0.8f, 1.5f);
            class_1264.method_5449((class_1937)world, (double)this.method_23317(), (double)this.method_23318(), (double)this.method_23321(), (class_1799)egg);
            this.method_5614(6000);
            other.method_5614(6000);
            this.method_6477();
            other.method_6477();
            world.method_8421((class_1297)this, (byte)18);
            if (world.method_8450().method_8355(class_1928.field_19391)) {
                world.method_8649((class_1297)new class_1303((class_1937)world, this.method_23317(), this.method_23318(), this.method_23321(), this.method_6051().method_43048(16) + 4));
            }
            this.produceParticlesServer((class_2394)class_2398.field_11211, 6 + this.field_5974.method_43048(7), 1, 0.0f);
            ((MoaEntity)other).produceParticlesServer((class_2394)class_2398.field_11211, 6 + this.field_5974.method_43048(7), 1, 0.0f);
        }
    }

    protected void method_5712(class_2338 posIn, class_2680 stateIn) {
        this.field_6002.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), ParadiseLostSoundEvents.ENTITY_MOA_STEP, class_3419.field_15254, 0.15f, 1.0f);
    }

    public void fall() {
        if (this.method_18798().field_1351 < 0.0 && !this.method_5715()) {
            this.method_18799(this.method_18798().method_18805(1.0, this.isGliding() ? (double)this.getGenes().getAttribute(MoaAttributes.GLIDING_DECAY) * 1.4 : 1.0, 1.0));
        }
    }

    public void method_6100(boolean jump) {
        super.method_6100(jump);
    }

    public double method_5621() {
        return 1.03;
    }

    @Override
    public class_1296 method_5613(class_3218 world, class_1296 matingAnimal) {
        if (!(matingAnimal instanceof MoaEntity)) {
            return null;
        }
        MoaEntity matingMoa = (MoaEntity)matingAnimal;
        MoaGenes genesA = this.getGenes();
        MoaGenes genesB = matingMoa.getGenes();
        class_1799 eggStack = genesA.getEggForBreeding(genesB, (class_1937)world, this.method_24515());
        MoaEntity baby = (MoaEntity)ParadiseLostEntityTypes.MOA.method_5883((class_1937)world);
        if (baby == null) {
            return null;
        }
        MoaGenes babyGenes = baby.getGenes();
        babyGenes.readFromNbt(eggStack.method_7911("genes"));
        return baby;
    }

    public class_2960 method_5991() {
        return null;
    }

    protected void method_16077(class_1282 source, boolean causedByPlayer) {
        this.method_5775(new class_1799((class_1935)ParadiseLostItems.MOA_MEAT, (int)Math.round(0.337 + (double)(this.field_5974.method_43057() * this.getGenes().getAttribute(MoaAttributes.DROP_MULTIPLIER)))));
        if (this.field_5974.method_43056()) {
            this.method_5775(new class_1799((class_1935)class_1802.field_8153, (int)(Math.round(0.337 + (double)(this.field_5974.method_43057() * this.getGenes().getAttribute(MoaAttributes.DROP_MULTIPLIER))) / 2L)));
        }
    }

    public void method_6154(int strength) {
        if (this.method_6725()) {
            if (strength < 0) {
                strength = 0;
            } else {
                this.field_6282 = true;
            }
            this.jumpStrength = (float)strength * this.getGenes().getAttribute(MoaAttributes.JUMPING_STRENGTH) * 0.95f;
        }
    }

    public boolean method_6153() {
        return this.method_6725();
    }

    public void method_6155(int height) {
        this.field_6282 = true;
        this.field_6002.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), ParadiseLostSoundEvents.ENTITY_MOA_GLIDING, class_3419.field_15254, 7.5f, class_3532.method_15363((float)this.field_5974.method_43057(), (float)0.55f, (float)0.8f));
    }

    public void method_6156() {
    }

    public MoaGenes getGenes() {
        if (this.genes == null) {
            this.genes = MoaGenes.get(this);
        }
        return this.genes;
    }

    @Nullable
    public UUID method_6139() {
        return this.getGenes().getOwner();
    }

    @Nullable
    public class_1297 method_35057() {
        return Optional.ofNullable(this.method_6139()).map(arg_0 -> ((class_1937)this.field_6002).method_18470(arg_0)).orElse(null);
    }

    public void method_5453(class_1263 sender) {
    }

    public void method_6722(class_1657 player) {
        if (!this.field_6002.field_9236 && (!this.method_5782() || this.method_5626((class_1297)player)) && this.getGenes().isTamed()) {
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                public class_2561 method_5476() {
                    return class_2561.method_43471((String)"container.paradise_lost.moa");
                }

                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return new MoaScreenHandler(syncId, inv, (class_1263)MoaEntity.this.inventory, MoaEntity.this);
                }

                public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                    buf.method_10804(MoaEntity.this.method_5628());
                }
            });
        }
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    private class MoaEscapeDangerGoal
    extends class_1374 {
        MoaEscapeDangerGoal(class_1314 mob, double speed) {
            super(mob, speed);
        }

        public boolean method_6264() {
            boolean ownerNear = MoaEntity.this.method_6065() != MoaEntity.this.method_35057();
            return ownerNear && super.method_6264();
        }
    }

    public class EatFromBowlGoal
    extends class_1367 {
        protected int timer;

        public EatFromBowlGoal(double speed, int range, int maxYDifference) {
            super((class_1314)MoaEntity.this, speed, range, maxYDifference);
        }

        public double getDesiredSquaredDistanceToTarget() {
            return 2.0;
        }

        public boolean method_6294() {
            return this.field_6517 % 100 == 0;
        }

        protected boolean method_6296(class_4538 world, class_2338 pos) {
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof FoodBowlBlockEntity) {
                FoodBowlBlockEntity foodBowl = (FoodBowlBlockEntity)class_25862;
                class_1799 foodStack = foodBowl.method_5438(0);
                return foodStack.method_19267() && foodStack.method_7909().method_19264().method_19232();
            }
            return false;
        }

        public void method_6268() {
            if (this.method_6295()) {
                if (this.timer >= 20) {
                    this.tryEat();
                } else {
                    ++this.timer;
                }
            } else if (!this.method_6295() && MoaEntity.this.field_5974.method_43057() < 0.025f) {
                MoaEntity.this.method_5783(ParadiseLostSoundEvents.ENTITY_MOA_DEATH, 0.5f, 2.0f);
            }
            super.method_6268();
        }

        protected void tryEat() {
            FoodBowlBlockEntity foodBowl;
            class_1799 foodStack;
            class_2586 class_25862 = MoaEntity.this.field_6002.method_8321(this.field_6512);
            if (class_25862 instanceof FoodBowlBlockEntity && (foodStack = (foodBowl = (FoodBowlBlockEntity)class_25862).method_5438(0)).method_19267() && foodStack.method_7909().method_19264().method_19232()) {
                MoaEntity.this.feedMob(foodStack);
            }
        }

        public boolean method_6264() {
            return MoaEntity.this.getGenes().getHunger() < 80.0f && super.method_6264();
        }

        public boolean method_6266() {
            return MoaEntity.this.getGenes().getHunger() < 98.0f && super.method_6266();
        }

        public void method_6269() {
            this.timer = 0;
            super.method_6269();
        }
    }
}

