/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.entities.passive.moa;

import net.id.paradiselost.component.MoaGenes;
import net.id.paradiselost.entities.passive.moa.MoaEntity;

public enum MoaAttributes {
    GROUND_SPEED(0.24f, 1.0f, 0.152f),
    GLIDING_SPEED(0.055f, 0.25f, 0.039f),
    GLIDING_DECAY(0.9f, 0.5f, 0.08f),
    JUMPING_STRENGTH(0.25f, 0.15f, 0.02f),
    DROP_MULTIPLIER(1.0f, 6.0f, 1.0f),
    MAX_HEALTH(10.0f, 40.0f, 6.0f);

    public final float min;
    public final float max;
    public final float gradeInterval;

    private MoaAttributes(float min, float max, float gradeInterval) {
        this.min = min;
        this.max = max;
        this.gradeInterval = gradeInterval;
    }

    public String getRatingTierTranslationKey(MoaEntity moa) {
        if (this.min > this.max) {
            return this.getRatingTierInverse(moa);
        }
        float attribute = this.getAttribute(moa);
        if (attribute <= this.min) {
            return this.getRatingTierTranslationKey(1);
        }
        if (attribute >= this.max) {
            return this.getRatingTierTranslationKey(7);
        }
        double out = (attribute - this.min) / this.gradeInterval;
        return this.getRatingTierTranslationKey((int)(out + 2.0));
    }

    private String getRatingTierTranslationKey(int tier) {
        return "moa.attribute.tier." + tier;
    }

    public String getRatingTierInverse(MoaEntity moa) {
        float attribute = this.getAttribute(moa);
        if (attribute <= this.min) {
            return this.getRatingTierTranslationKey(1);
        }
        if (attribute >= this.max) {
            return this.getRatingTierTranslationKey(7);
        }
        double out = (attribute - this.min) / this.gradeInterval;
        return this.getRatingTierTranslationKey((int)(out + 1.0));
    }

    public float getAttribute(MoaEntity moa) {
        return moa.getGenes().getAttribute(this);
    }

    public float fromBreeding(MoaGenes parentA, MoaGenes parentB, boolean increase) {
        float stat = parentA.getAttribute(this) / 2.0f + parentB.getAttribute(this) / 2.0f;
        if (parentA.getAffinity() == this) {
            stat += this.gradeInterval / 3.0f;
        }
        if (parentB.getAffinity() == this) {
            stat += this.gradeInterval / 3.0f;
        }
        if (increase) {
            stat += this.gradeInterval / 4.0f;
        }
        return stat;
    }

    public String getTranslationKey() {
        return "moa.attribute." + this.name().toLowerCase();
    }
}

