/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.entities.passive.ambyst;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import net.id.paradiselost.blocks.ParadiseLostBlocks;
import net.id.paradiselost.entities.ParadiseLostEntityTypes;
import net.minecraft.class_1429;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;

public class FindLogSensor
extends class_4148<class_1429> {
    private final int range;

    public FindLogSensor(int range, int updateInterval) {
        super(updateInterval);
        this.range = range;
    }

    protected void sense(class_3218 world, class_1429 entity) {
        class_4095 brain = entity.method_18868();
        Optional previousOpenPos = brain.method_18904(ParadiseLostEntityTypes.LOG_OPENING_MEMORY);
        Optional previousLogPos = brain.method_18904(ParadiseLostEntityTypes.LOG_MEMORY);
        if (previousOpenPos.isPresent() && FindLogSensor.isValidOpening(world, (class_2338)previousOpenPos.get()) && previousLogPos.isPresent() && FindLogSensor.isLog(world, (class_2338)previousLogPos.get())) {
            return;
        }
        for (class_2338 testLogPos : class_2338.method_25996((class_2338)entity.method_24515(), (int)this.range, (int)this.range, (int)this.range)) {
            if (!FindLogSensor.isLog(world, testLogPos)) continue;
            class_2680 logState = world.method_8320(testLogPos);
            class_2350 logDir = class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)logState.method_11654((class_2769)class_2465.field_11459)), (class_2350.class_2352)class_2350.class_2352.field_11056);
            class_2338 openingPos = this.getLogOpening(world, logDir, testLogPos);
            if (openingPos == null) {
                logDir = logDir.method_10153();
                openingPos = this.getLogOpening(world, logDir, testLogPos);
            }
            if (openingPos == null) continue;
            class_2338 foundLogPos = openingPos.method_10093(logDir.method_10153());
            entity.method_18868().method_18878(ParadiseLostEntityTypes.LOG_MEMORY, (Object)foundLogPos);
            entity.method_18868().method_18878(ParadiseLostEntityTypes.LOG_OPENING_MEMORY, (Object)openingPos);
            break;
        }
    }

    public class_2338 getLogOpening(class_3218 world, class_2350 dir, class_2338 pos) {
        class_2338 newPos = pos.method_10093(dir);
        if (FindLogSensor.isLogSameRotation(world, newPos, dir)) {
            return this.getLogOpening(world, dir, newPos);
        }
        if (FindLogSensor.isValidOpening(world, newPos)) {
            return newPos;
        }
        return null;
    }

    public static boolean isLog(class_3218 world, class_2338 testPos) {
        return world.method_8320(testPos).method_27852((class_2248)ParadiseLostBlocks.MOTTLED_AUREL_FALLEN_LOG) && world.method_8320(testPos).method_11654((class_2769)class_2465.field_11459) != class_2350.class_2351.field_11052;
    }

    public static boolean isLogSameRotation(class_3218 world, class_2338 testPos, class_2350 dir) {
        return world.method_8320(testPos).method_27852((class_2248)ParadiseLostBlocks.MOTTLED_AUREL_FALLEN_LOG) && world.method_8320(testPos).method_11654((class_2769)class_2465.field_11459) == dir.method_10166();
    }

    public static boolean isValidOpening(class_3218 world, class_2338 testPos) {
        return !world.method_8320(testPos).method_26207().method_15799() && !world.method_8320(testPos).method_26212((class_1922)world, testPos);
    }

    public Set<class_4140<?>> method_19099() {
        return ImmutableSet.of(ParadiseLostEntityTypes.LOG_MEMORY, ParadiseLostEntityTypes.LOG_OPENING_MEMORY);
    }
}

