/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.entities.block;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.id.incubus_core.blocklikeentities.api.BlockLikeEntity;
import net.id.paradiselost.api.FloatingBlockHelper;
import net.id.paradiselost.entities.ParadiseLostEntityTypes;
import net.id.paradiselost.tag.ParadiseLostBlockTags;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public class FloatingBlockEntity
extends BlockLikeEntity {
    private Supplier<Boolean> dropState = () -> FloatingBlockHelper.DEFAULT_DROP_STATE.apply(this);
    private boolean dropping = false;
    private BiConsumer<Double, Boolean> onEndFloating;
    public double lastYVelocity;

    public FloatingBlockEntity(class_1299<? extends BlockLikeEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.onEndFloating = (f, b) -> {};
        this.lastYVelocity = 0.0;
    }

    public FloatingBlockEntity(class_1937 world, double x, double y, double z, class_2680 floatingBlockState) {
        super(ParadiseLostEntityTypes.FLOATING_BLOCK, world, x, y, z, floatingBlockState);
        this.onEndFloating = (f, b) -> {};
        this.lastYVelocity = 0.0;
        this.setHurtEntities(floatingBlockState.method_26164(ParadiseLostBlockTags.HURTABLE_FLOATERS));
    }

    public FloatingBlockEntity(class_1937 world, class_2338 pos, class_2680 floatingBlockState, boolean partOfSet) {
        super(ParadiseLostEntityTypes.FLOATING_BLOCK, world, pos, floatingBlockState, partOfSet);
        this.onEndFloating = (f, b) -> {};
        this.lastYVelocity = 0.0;
        this.setHurtEntities(floatingBlockState.method_26164(ParadiseLostBlockTags.HURTABLE_FLOATERS));
    }

    public void postTickMoveEntities() {
        if (class_2346.method_10128((class_2680)this.blockState)) {
            return;
        }
        List otherEntities = this.field_6002.method_8335((class_1297)this, this.method_5829().method_991(this.method_5829().method_989(0.0, 3.0 * (this.field_6036 - this.method_23318()), 0.0)));
        for (class_1297 entity : otherEntities) {
            if (!(entity instanceof BlockLikeEntity) && !entity.field_5960 && this.collides) {
                entity.method_5784(class_1313.field_6306, this.method_18798());
                entity.method_24830(true);
                entity.method_5814(entity.method_23317(), this.method_5829().field_1325, entity.method_23321());
                entity.field_6017 = 0.0f;
            }
            this.postTickEntityCollision(entity);
        }
    }

    public void postTickMovement() {
        this.method_18799(this.method_18798().method_1021(0.98));
        this.lastYVelocity = this.method_18798().field_1351;
        if (!this.method_5740()) {
            if (!this.isDropping() && !this.shouldBeginDropping()) {
                if (this.isFastFloater()) {
                    this.method_18799(this.method_18798().method_1031(0.0, 0.05, 0.0));
                } else {
                    this.method_18799(this.method_18798().method_1031(0.0, 0.03, 0.0));
                }
            } else {
                this.setDropping(true);
                this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
            }
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    public boolean shouldCease() {
        return super.shouldCease() || this.method_24828() && (this.isDropping() || this.method_18798().method_10214() == 0.0) || this.field_5992 && !this.field_5952;
    }

    public Supplier<Boolean> getDropState() {
        return this.dropState;
    }

    public void setDropState(Supplier<Boolean> supplier) {
        this.dropState = supplier;
    }

    public boolean shouldBeginDropping() {
        return this.getDropState().get();
    }

    public boolean isDropping() {
        return this.dropping;
    }

    public void setDropping(boolean dropping) {
        this.dropping = dropping;
    }

    public BiConsumer<Double, Boolean> getOnEndFloating() {
        return this.onEndFloating;
    }

    public void setOnEndFloating(BiConsumer<Double, Boolean> consumer) {
        this.onEndFloating = consumer;
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Dropping", this.isDropping());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10573("Dropping", 99)) {
            this.setDropping(compound.method_10577("Dropping"));
        }
    }

    public boolean trySetBlock() {
        if (super.trySetBlock()) {
            this.getOnEndFloating().accept(Math.abs(this.lastYVelocity), true);
            return true;
        }
        return false;
    }

    public void breakApart() {
        super.breakApart();
        this.getOnEndFloating().accept(Math.abs(this.lastYVelocity), false);
    }

    public boolean isFastFloater() {
        return this.getBlockState().method_26164(ParadiseLostBlockTags.FAST_FLOATERS) && !this.partOfSet;
    }

    public void alignWith(BlockLikeEntity other, class_2382 offset) {
        super.alignWith(other, offset);
        if (other instanceof FloatingBlockEntity) {
            FloatingBlockEntity fbe = (FloatingBlockEntity)other;
            this.setDropping(fbe.isDropping());
        }
    }
}

