/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.id.paradiselost.component.ParadiseLostComponents;
import net.id.paradiselost.lore.LoreState;
import net.id.paradiselost.lore.LoreStatus;
import net.id.paradiselost.registry.ParadiseLostRegistries;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

final class LoreCommand {
    private static final SuggestionProvider<class_2168> LORE_SUGGESTER = (context, builder) -> {
        ParadiseLostRegistries.LORE_REGISTRY.method_10235().forEach(id -> builder.suggest(id.toString()));
        return builder.buildFuture();
    };

    private LoreCommand() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"paradiseLostLore").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"grant").then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(LORE_SUGGESTER).executes(context -> LoreCommand.executeGrant((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"id")))))).then(class_2170.method_9247((String)"revoke").then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(LORE_SUGGESTER).executes(context -> LoreCommand.executeRevoke((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"id")))))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(LORE_SUGGESTER).executes(context -> LoreCommand.executeGet((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"id"))))));
    }

    private static int executeGrant(class_2168 source, class_2960 id) throws CommandSyntaxException {
        class_3222 player = source.method_44023();
        LoreState state = (LoreState)ParadiseLostComponents.LORE_STATE.get((Object)player);
        LoreStatus status = state.getLoreStatus(id);
        if (status == LoreStatus.UNLOCKED) {
            state.setLoreStatus(id, LoreStatus.COMPLETED);
            return 1;
        }
        return 0;
    }

    private static int executeRevoke(class_2168 source, class_2960 id) throws CommandSyntaxException {
        class_3222 player = source.method_44023();
        LoreState state = (LoreState)ParadiseLostComponents.LORE_STATE.get((Object)player);
        LoreStatus status = state.getLoreStatus(id);
        if (status == LoreStatus.COMPLETED) {
            state.setLoreStatus(id, LoreStatus.UNLOCKED);
            return 1;
        }
        return 0;
    }

    private static int executeGet(class_2168 source, class_2960 id) throws CommandSyntaxException {
        class_3222 player = source.method_44023();
        LoreState state = (LoreState)ParadiseLostComponents.LORE_STATE.get((Object)player);
        LoreStatus status = state.getLoreStatus(id);
        String sourceStr = status.getName();
        source.method_9226((class_2561)class_2561.method_43471((String)("commands.paradise_lost.lore.get." + sourceStr)), false);
        return status.ordinal();
    }
}

