/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.client.rendering.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.id.incubus_core.condition.api.Severity;
import net.id.paradiselost.ParadiseLost;
import net.id.paradiselost.items.tools.bloodstone.AbstentineBloodstoneItem;
import net.id.paradiselost.items.tools.bloodstone.BloodstoneCapturedData;
import net.id.paradiselost.items.tools.bloodstone.BloodstoneItem;
import net.id.paradiselost.items.tools.bloodstone.CherineBloodstoneItem;
import net.id.paradiselost.items.tools.bloodstone.GravititeBloodstoneItem;
import net.id.paradiselost.items.tools.bloodstone.OlviteBloodstoneItem;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3966;
import net.minecraft.class_4074;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class BloodstoneHUDRenderer {
    public static void render(class_4587 matrixStack, float delta) {
        class_2487 nbt;
        class_746 player = class_310.method_1551().field_1724;
        class_1799 stack = player.method_6047();
        if (stack.method_7909() instanceof BloodstoneItem && (nbt = stack.method_7948()).method_10545("capturedEntityData")) {
            class_310 client = class_310.method_1551();
            BloodstoneCapturedData capturedData = BloodstoneCapturedData.fromNBT(nbt.method_10562("capturedEntityData"));
            if (client.field_1755 == null && BloodstoneHUDRenderer.isLookingAtMatchingEntity(client, capturedData) || BloodstoneHUDRenderer.doUUIDMatch((class_1309)player, capturedData)) {
                matrixStack.method_22903();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                matrixStack.method_22904((double)((float)client.method_22683().method_4486() / 2.0f), (double)((float)client.method_22683().method_4502() / 2.0f), 0.0);
                if (stack.method_7909() instanceof CherineBloodstoneItem) {
                    BloodstoneHUDRenderer.renderCherine(matrixStack, client, capturedData);
                } else if (stack.method_7909() instanceof OlviteBloodstoneItem) {
                    BloodstoneHUDRenderer.renderOlvite(matrixStack, client, capturedData);
                } else if (stack.method_7909() instanceof GravititeBloodstoneItem) {
                    BloodstoneHUDRenderer.renderGravitite(matrixStack, client, capturedData);
                } else if (stack.method_7909() instanceof AbstentineBloodstoneItem) {
                    BloodstoneHUDRenderer.renderAbstentine(matrixStack, client, capturedData);
                }
                RenderSystem.disableBlend();
                matrixStack.method_22909();
            }
        }
    }

    private static boolean isLookingAtMatchingEntity(class_310 client, BloodstoneCapturedData capturedData) {
        if (client.field_1765 == null || client.field_1765.method_17783() != class_239.class_240.field_1331 || !(((class_3966)client.field_1765).method_17782() instanceof class_1309)) {
            return false;
        }
        class_1297 class_12972 = ((class_3966)client.field_1765).method_17782();
        if (class_12972 instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            return BloodstoneHUDRenderer.doUUIDMatch(entity, capturedData);
        }
        return false;
    }

    private static boolean doUUIDMatch(class_1309 entity, BloodstoneCapturedData capturedData) {
        return capturedData.uuid.equals(entity.method_5667());
    }

    private static void renderCherine(class_4587 matrixStack, class_310 client, BloodstoneCapturedData bloodstoneCapturedData) {
        class_4074 statusEffectSpriteManager = client.method_18505();
        BloodstoneHUDRenderer.renderRing(matrixStack, 0, 0);
        BloodstoneHUDRenderer.renderText(matrixStack, client, bloodstoneCapturedData.name, 0, -80);
        BloodstoneHUDRenderer.renderIconWText(matrixStack, client, statusEffectSpriteManager.method_18663(class_1294.field_5924), (class_2561)class_2561.method_43470((String)bloodstoneCapturedData.HP), 0, 80);
        BloodstoneHUDRenderer.renderIconWText(matrixStack, client, statusEffectSpriteManager.method_18663(class_1294.field_5907), (class_2561)class_2561.method_43470((String)bloodstoneCapturedData.DF), -80, 0);
        BloodstoneHUDRenderer.renderIconWText(matrixStack, client, statusEffectSpriteManager.method_18663(class_1294.field_5898), (class_2561)class_2561.method_43470((String)bloodstoneCapturedData.TF), 80, 0);
    }

    private static void renderOlvite(class_4587 matrixStack, class_310 client, BloodstoneCapturedData bloodstoneCapturedData) {
        class_4074 statusEffectSpriteManager = client.method_18505();
        class_1058 affinitySprite = statusEffectSpriteManager.method_18663(class_1294.field_16595).method_24119().method_4608(ParadiseLost.locate("hud/bloodstone/affinity"));
        class_1058 raceSprite = statusEffectSpriteManager.method_18663(class_1294.field_16595).method_24119().method_4608(ParadiseLost.locate("hud/bloodstone/race"));
        BloodstoneHUDRenderer.renderRing(matrixStack, 0, 0);
        BloodstoneHUDRenderer.renderText(matrixStack, client, bloodstoneCapturedData.name, 0, -80);
        BloodstoneHUDRenderer.renderIconWText(matrixStack, client, affinitySprite, (class_2561)class_2561.method_43471((String)bloodstoneCapturedData.Affinity), 76, -25);
        BloodstoneHUDRenderer.renderIconWText(matrixStack, client, statusEffectSpriteManager.method_18663(class_1294.field_5905), (class_2561)class_2561.method_43470((String)bloodstoneCapturedData.Owner), 47, 65);
        BloodstoneHUDRenderer.renderIconWText(matrixStack, client, statusEffectSpriteManager.method_18663(class_1294.field_5903), (class_2561)class_2561.method_43470((String)bloodstoneCapturedData.Hunger), -47, 65);
        BloodstoneHUDRenderer.renderIconWText(matrixStack, client, raceSprite, (class_2561)class_2561.method_43471((String)bloodstoneCapturedData.Race), -76, -25);
    }

    private static void renderGravitite(class_4587 matrixStack, class_310 client, BloodstoneCapturedData bloodstoneCapturedData) {
        BloodstoneHUDRenderer.renderRing(matrixStack, 0, 0);
        BloodstoneHUDRenderer.renderText(matrixStack, client, bloodstoneCapturedData.name, 0, -80);
        BloodstoneHUDRenderer.renderText(matrixStack, client, (class_2561)class_2561.method_43471((String)"moa.attribute.ground_speed").method_27693(": ").method_10852(bloodstoneCapturedData.getRatingWithColor(bloodstoneCapturedData.GROUND_SPEED)), 63, -50);
        BloodstoneHUDRenderer.renderText(matrixStack, client, (class_2561)class_2561.method_43471((String)"moa.attribute.gliding_speed").method_27693(": ").method_10852(bloodstoneCapturedData.getRatingWithColor(bloodstoneCapturedData.GLIDING_SPEED)), 80, 0);
        BloodstoneHUDRenderer.renderText(matrixStack, client, (class_2561)class_2561.method_43471((String)"moa.attribute.gliding_decay").method_27693(": ").method_10852(bloodstoneCapturedData.getRatingWithColor(bloodstoneCapturedData.GLIDING_DECAY)), 63, 50);
        BloodstoneHUDRenderer.renderText(matrixStack, client, (class_2561)class_2561.method_43471((String)"moa.attribute.jumping_strength").method_27693(": ").method_10852(bloodstoneCapturedData.getRatingWithColor(bloodstoneCapturedData.JUMPING_STRENGTH)), -63, -50);
        BloodstoneHUDRenderer.renderText(matrixStack, client, (class_2561)class_2561.method_43471((String)"moa.attribute.drop_multiplier").method_27693(": ").method_10852(bloodstoneCapturedData.getRatingWithColor(bloodstoneCapturedData.DROP_MULTIPLIER)), -80, 0);
        BloodstoneHUDRenderer.renderText(matrixStack, client, (class_2561)class_2561.method_43471((String)"moa.attribute.max_health").method_27693(": ").method_10852(bloodstoneCapturedData.getRatingWithColor(bloodstoneCapturedData.MAX_HEALTH)), -63, 50);
    }

    private static void renderAbstentine(class_4587 matrixStack, class_310 client, BloodstoneCapturedData bloodstoneCapturedData) {
        BloodstoneHUDRenderer.renderRing(matrixStack, 0, 0);
        BloodstoneHUDRenderer.renderText(matrixStack, client, bloodstoneCapturedData.name, 0, -80);
        for (int i = 0; i < bloodstoneCapturedData.conditionDataList.size(); ++i) {
            class_3545<Integer, Integer> offset = BloodstoneHUDRenderer.getCircularPosition(80, i + 1, bloodstoneCapturedData.conditionDataList.size());
            BloodstoneHUDRenderer.renderCondition(matrixStack, client, bloodstoneCapturedData.conditionDataList.get(i), (Integer)offset.method_15442(), (Integer)offset.method_15441());
        }
    }

    private static void renderCondition(class_4587 matrixStack, class_310 client, BloodstoneCapturedData.ConditionData conditionData, int offsetX, int offsetY) {
        if (offsetX == 0) {
            offsetX = 54;
        } else if (offsetX < 0) {
            offsetX -= 54;
        }
        int renderWidth = (int)class_3532.method_15363((float)(94.0f * conditionData.severity()), (float)0.0f, (float)94.0f);
        matrixStack.method_22903();
        matrixStack.method_22904((double)offsetX, (double)offsetY, 0.0);
        matrixStack.method_22904(-54.5, -6.0, 0.0);
        matrixStack.method_22905(1.15f, 1.15f, 1.0f);
        matrixStack.method_22904(54.5, 6.0, 0.0);
        RenderSystem.setShaderTexture((int)0, (class_2960)ParadiseLost.locate("textures/hud/bloodstone/" + conditionData.id() + "_bar.png"));
        class_332.method_25290((class_4587)matrixStack, (int)-7, (int)-7, (float)0.0f, (float)0.0f, (int)(15 + renderWidth), (int)12, (int)109, (int)12);
        RenderSystem.setShaderTexture((int)0, (class_2960)ParadiseLost.locate("textures/hud/bloodstone/condition_bar.png"));
        class_332.method_25290((class_4587)matrixStack, (int)-7, (int)-7, (float)0.0f, (float)0.0f, (int)109, (int)12, (int)109, (int)12);
        matrixStack.method_22909();
        class_5250 title = class_2561.method_43471((String)("condition.condition." + conditionData.id())).method_27693(" - ").method_10852(BloodstoneHUDRenderer.getSeverityWithColor(Float.valueOf(conditionData.severity())));
        BloodstoneHUDRenderer.renderText(matrixStack, client, (class_2561)title, offsetX + 17, offsetY - 9);
    }

    public static class_2561 getSeverityWithColor(Float rawSeverity) {
        Severity sev = Severity.getSeverity((float)rawSeverity.floatValue());
        class_5250 text = class_2561.method_43471((String)sev.getTranslationKey());
        return switch (sev) {
            default -> throw new IncompatibleClassChangeError();
            case Severity.EXTREME -> text.method_27692(class_124.field_1080);
            case Severity.DIRE -> text.method_27692(class_124.field_1061);
            case Severity.ACUTE -> text.method_27692(class_124.field_1054);
            case Severity.MILD -> text.method_27692(class_124.field_1060);
            case Severity.NEGLIGIBLE -> text.method_27692(class_124.field_1075);
        };
    }

    private static void renderRing(class_4587 matrixStack, int offsetX, int offsetY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)ParadiseLost.locate("textures/hud/bloodstone/bloodstone_ring.png"));
        class_332.method_25290((class_4587)matrixStack, (int)(offsetX - 75), (int)(offsetY - 75), (float)0.0f, (float)0.0f, (int)150, (int)150, (int)150, (int)150);
    }

    private static void renderIconWText(class_4587 matrixStack, class_310 client, class_1058 sprite, class_2561 text, int offsetX, int offsetY) {
        int totalWidth = sprite.method_4578() + 2 + client.field_1772.method_27525((class_5348)text);
        Objects.requireNonNull(client.field_1772);
        int totalHeight = 9 / 2;
        int startX = offsetX;
        if (offsetX == 0) {
            startX = offsetX - totalWidth / 2;
        } else if (offsetX < 0) {
            startX = offsetX - totalWidth;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_24119().method_24106());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_332.method_25298((class_4587)matrixStack, (int)startX, (int)(offsetY - 9), (int)client.field_1705.method_25305(), (int)18, (int)18, (class_1058)sprite);
        client.field_1772.method_30881(matrixStack, text, (float)(startX + sprite.method_4578() + 2), (float)(offsetY - totalHeight), 0xE0E0E0);
    }

    private static void renderText(class_4587 matrixStack, class_310 client, class_2561 text, int offsetX, int offsetY) {
        int totalWidth = client.field_1772.method_27525((class_5348)text);
        Objects.requireNonNull(client.field_1772);
        int totalHeight = 9 / 2;
        int startX = offsetX;
        if (offsetX == 0) {
            startX = offsetX - totalWidth / 2;
        } else if (offsetX < 0) {
            startX = offsetX - totalWidth;
        }
        client.field_1772.method_30881(matrixStack, text, (float)startX, (float)(offsetY - totalHeight), 0xE0E0E0);
    }

    private static class_3545<Integer, Integer> getCircularPosition(int radius, int itemNum, int totalItems) {
        if (totalItems < 5) {
            return switch (itemNum) {
                case 0 -> new class_3545((Object)0, (Object)-80);
                case 1 -> new class_3545((Object)80, (Object)0);
                case 2 -> new class_3545((Object)-80, (Object)0);
                case 3 -> new class_3545((Object)0, (Object)80);
                default -> new class_3545((Object)0, (Object)0);
            };
        }
        double angle = Math.PI * 2 / (double)totalItems * (double)itemNum;
        int y = (int)Math.round(Math.cos(angle) * (double)radius);
        int x = (int)Math.round(Math.sin(angle) * (double)radius);
        return new class_3545((Object)x, (Object)(-y));
    }
}

