/*
 * Decompiled with CFR 0.152.
 */
package timefall.mcsa.items.armor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import timefall.mcsa.Mcsa;
import timefall.mcsa.blocks.CarvedWhitePumpkinBlock;
import timefall.mcsa.configs.ArmorStats;
import timefall.mcsa.configs.McsaConfig;
import timefall.mcsa.init.BlocksInit;
import timefall.mcsa.items.armor.ArmorSets;

public class ArmorSetItem
extends class_1738 {
    private static final Map<ArmorSets, class_1293> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ArmorSets.MAGNUS, (Object)new class_1293(class_1294.field_5923, 200, 0)).put((Object)ArmorSets.PRISMARINE, (Object)new class_1293(class_1294.field_5923, 200, 0)).build();
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    protected final Multimap<class_1320, class_1322> attributeModifiers;
    protected final ArmorSets set;

    public ArmorSetItem(ArmorSets set, class_1304 slot) {
        super((class_1741)set, slot, new class_1792.class_1793().method_7892(Mcsa.MCSA_TAB));
        this.set = set;
        int protection = set.method_7697(slot);
        float toughness = set.method_7700();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIERS[slot.method_5927()];
        builder.put((Object)class_5134.field_23724, (Object)new class_1322(uuid, "Armor modifier", (double)protection, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23725, (Object)new class_1322(uuid, "Armor toughness", (double)toughness, class_1322.class_1323.field_6328));
        if (this.field_21976 > 0.0f) {
            builder.put((Object)class_5134.field_23718, (Object)new class_1322(uuid, "Armor knockback resistance", (double)this.field_21976, class_1322.class_1323.field_6328));
        }
        ArmorStats armorStats = McsaConfig.config.armorStats.get((Object)set);
        this.attributeModifiers = builder.build();
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == this.field_7880 ? this.attributeModifiers : super.method_7844(slot);
    }

    public class_1814 method_7862(class_1799 itemStack) {
        return this.set.getRarity();
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 playerEntity;
        if (!world.field_9236 && entity instanceof class_1657 && this.hasFullSetOfArmorOn(playerEntity = (class_1657)entity)) {
            this.checkArmorEffects(playerEntity);
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    private void checkArmorEffects(class_1657 playerEntity) {
        for (Map.Entry<ArmorSets, class_1293> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ArmorSets mapArmorSets = entry.getKey();
            class_1293 mapStatusEffect = entry.getValue();
            if (!this.hasCorrectArmorOn(mapArmorSets, playerEntity)) continue;
            this.addStatusEffectForArmorSet(playerEntity, mapArmorSets, mapStatusEffect);
        }
    }

    private void addStatusEffectForArmorSet(class_1657 playerEntity, ArmorSets mapArmorSets, class_1293 mapStatusEffect) {
        boolean hasPlayerEffect = playerEntity.method_6059(mapStatusEffect.method_5579());
        if (this.hasCorrectArmorOn(mapArmorSets, playerEntity) && !hasPlayerEffect) {
            playerEntity.method_6092(new class_1293(mapStatusEffect.method_5579(), mapStatusEffect.method_5584(), mapStatusEffect.method_5578(), true, false));
        }
    }

    private boolean hasFullSetOfArmorOn(class_1657 playerEntity) {
        class_1799 bootsStack = playerEntity.method_31548().method_7372(0);
        class_1799 leggingsStack = playerEntity.method_31548().method_7372(1);
        class_1799 chestplateStack = playerEntity.method_31548().method_7372(2);
        class_1799 helmetStack = playerEntity.method_31548().method_7372(3);
        return !helmetStack.method_7960() && !chestplateStack.method_7960() && !leggingsStack.method_7960() && !bootsStack.method_7960();
    }

    private boolean hasCorrectArmorOn(ArmorSets armorSet, class_1657 playerEntity) {
        class_1792 class_17922;
        if (!playerEntity.method_6118(class_1304.field_6169).method_31574(((CarvedWhitePumpkinBlock)((Object)BlocksInit.CARVED_WHITE_PUMPKIN_BLOCK.get())).method_8389()) && (class_17922 = playerEntity.method_31548().method_7372(0).method_7909()) instanceof ArmorSetItem) {
            ArmorSetItem bootsStack = (ArmorSetItem)class_17922;
            class_1792 class_17923 = playerEntity.method_31548().method_7372(1).method_7909();
            if (class_17923 instanceof ArmorSetItem) {
                ArmorSetItem leggingsStack = (ArmorSetItem)class_17923;
                class_1792 class_17924 = playerEntity.method_31548().method_7372(2).method_7909();
                if (class_17924 instanceof ArmorSetItem) {
                    ArmorSetItem chestplateStack = (ArmorSetItem)class_17924;
                    class_1792 class_17925 = playerEntity.method_31548().method_7372(3).method_7909();
                    if (class_17925 instanceof ArmorSetItem) {
                        ArmorSetItem helmetStack = (ArmorSetItem)class_17925;
                        return helmetStack.method_7686() == armorSet && chestplateStack.method_7686() == armorSet && leggingsStack.method_7686() == armorSet && bootsStack.method_7686() == armorSet;
                    }
                }
            }
        }
        return false;
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        super.method_7851(itemStack, world, tooltip, tooltipContext);
        String setId = this.set.getSetName();
        String translationKey = String.format("item.mcsa.%s.tooltip_", setId);
        int i = 1;
        while (class_1074.method_4663((String)(translationKey + i))) {
            tooltip.add((class_2561)class_2561.method_43471((String)(translationKey + i)).method_27692(class_124.field_1056));
            ++i;
        }
        if (McsaConfig.config.enableArmorSetBonusTooltips) {
            translationKey = String.format("item.mcsa.%s.effect.tooltip_", setId);
            i = 1;
            if (McsaConfig.config.enableArmorEffectTooltip.get((Object)this.set).booleanValue() && McsaConfig.config.enableArmorEffectOfSet.get((Object)this.set).booleanValue()) {
                while (class_1074.method_4663((String)(translationKey + i))) {
                    class_5250 class_52502 = class_2561.method_43471((String)(translationKey + i));
                    tooltip.add((class_2561)class_52502.method_27692(switch (this.set) {
                        case ArmorSets.GOLDEN_GOLIATH -> class_124.field_1065;
                        case ArmorSets.REDSTONE_RIOT -> class_124.field_1061;
                        case ArmorSets.ENDER_DEFENDER -> class_124.field_1075;
                        case ArmorSets.SWORDBREAKER, ArmorSets.STAR_SHIELD -> class_124.field_1078;
                        case ArmorSets.SHIELD_OF_INFINITY -> class_124.field_1076;
                        case ArmorSets.DRAGONSBANE -> class_124.field_1064;
                        case ArmorSets.ADAMANTIUM -> class_124.field_1054;
                        default -> class_124.field_1080;
                    }));
                    ++i;
                }
            }
        }
    }
}

