/*
 * Decompiled with CFR 0.152.
 */
package timefall.mcsa.configs;

import java.util.EnumMap;
import java.util.EnumSet;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_1304;
import timefall.mcsa.configs.ArmorStats;
import timefall.mcsa.items.armor.ArmorSets;

@Config(name="mcsa")
public class McsaConfig
implements ConfigData {
    public static final McsaConfig config;
    @Comment(value="Character Armor Spawn Rate")
    public int characterArmorSpawnRate = 15;
    @Comment(value="Stronghold Armor Spawn Rate")
    public int strongholdArmorSpawnRate = 10;
    @Comment(value="Temple Armor Spawn Rate")
    public int templeArmorSpawnRate = 10;
    @Comment(value="Armorer Hero of the Village Gift Rate")
    public int hovArmorSpawnRate = 15;
    @Comment(value="Enable Villager Armor Trades")
    public boolean enableVillagerArmorTrades = false;
    @Comment(value="Enable Armor Set Bonus Tooltips")
    public boolean enableArmorSetBonusTooltips = true;
    @Comment(value="You may wish to disable Infinite Defense in a PvP Environment, as it can be quite powerful.\nAdamantine Guard, Adamantine Impervium: Reduce all damage to 10% of incoming damage\nBlade Shatter, Swordbreaker: Can only be damaged by non-sword type weapons, axe type weapons do extra damage\nBlasting Crew, Magnus Armor: Protection from explosions, reducing damage by half\nDragon Slayer, Dragonsbane: Immunity to the Ender Dragon's breath attack, 25% extra damage to the Ender Dragon\nInfinite Defense, Shield of Defense: A high chance to negate all incoming damage from all sources\nLiberator of the End, Ender Defender: 50% extra damage to Endermen\nPraise the Sun, Golden Goliath: When it is day or a full moon, and you can see the sky, you deal double damage and set enemies on fire. Otherwise, you deal half damage\nRedstone Engineering, Redstone Riot: Reduce all damage to 25% of incoming damage\nUniversal Protection, Star Shield: You can only be damaged by Netherite Weapons")
    public EnumMap<ArmorSets, Boolean> enableArmorEffectOfSet = new EnumMap(ArmorSets.class);
    public EnumMap<ArmorSets, Boolean> enableArmorEffectTooltip = new EnumMap(ArmorSets.class);
    public final EnumMap<ArmorSets, Boolean> ENABLE_ARMOR_SET = new EnumMap(ArmorSets.class);
    public EnumMap<ArmorSets, ArmorStats> armorStats = new EnumMap(ArmorSets.class);

    public int getCharacterArmorSpawnRate() {
        return this.characterArmorSpawnRate;
    }

    public int getStrongholdArmorSpawnRate() {
        return this.strongholdArmorSpawnRate;
    }

    public int getTempleArmorSpawnRate() {
        return this.templeArmorSpawnRate;
    }

    public int getHovArmorSpawnRate() {
        return this.hovArmorSpawnRate;
    }

    protected ArmorStats setProtection(int head, int chest, int legs, int feet, ArmorSets set) {
        return this.armorStats.get((Object)set).setProtection(head, chest, legs, feet);
    }

    public McsaConfig() {
        for (ArmorSets armorSet : ArmorSets.values()) {
            this.enableArmorEffectOfSet.put(armorSet, true);
            this.enableArmorEffectTooltip.put(armorSet, true);
            if (!this.enableArmorEffectOfSet.get((Object)armorSet).booleanValue()) {
                this.enableArmorEffectTooltip.replace(armorSet, false);
            }
            this.ENABLE_ARMOR_SET.put(armorSet, true);
            ArmorStats stats = new ArmorStats();
            stats.protection = new EnumMap(class_1304.class);
            for (class_1304 slot : EnumSet.of(class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166)) {
                stats.protection.put(slot, 0);
            }
            this.armorStats.put(armorSet, stats);
        }
        this.setProtection(4, 9, 7, 4, ArmorSets.ADAMANTIUM).setToughness(3.0f).setKnockbackRes(0.3f);
        this.setProtection(4, 9, 7, 4, ArmorSets.CHAMPION_PETRA).setToughness(2.0f).setKnockbackRes(0.2f);
        this.setProtection(4, 9, 7, 4, ArmorSets.DRAGONSBANE).setToughness(2.0f).setKnockbackRes(0.5f);
        this.setProtection(3, 8, 6, 3, ArmorSets.ELLEGAARD).setToughness(2.0f);
        this.setProtection(4, 9, 7, 4, ArmorSets.ENDER_DEFENDER).setToughness(2.0f);
        this.setProtection(3, 8, 6, 3, ArmorSets.ENDERMAN_SOREN);
        this.setProtection(3, 8, 6, 3, ArmorSets.GABRIEL).setToughness(2.0f);
        this.setProtection(4, 9, 7, 4, ArmorSets.GOLDEN_GOLIATH).setToughness(2.0f);
        this.setProtection(4, 9, 7, 4, ArmorSets.GOLDEN_GOLIATH_CIRCUITRY).setToughness(2.0f);
        this.setProtection(4, 9, 7, 4, ArmorSets.HARPERS_HEADSET).setToughness(2.0f);
        this.setProtection(3, 8, 6, 3, ArmorSets.IVOR).setToughness(2.0f);
        this.setProtection(3, 8, 6, 3, ArmorSets.LUKAS).setToughness(2.0f);
        this.setProtection(3, 8, 6, 3, ArmorSets.MAGNUS).setToughness(2.0f);
        this.setProtection(3, 8, 6, 3, ArmorSets.NINJA_IVOR_ARMOR).setToughness(1.0f);
        this.setProtection(3, 8, 6, 3, ArmorSets.OLIVIA).setToughness(2.0f);
        this.setProtection(3, 8, 6, 3, ArmorSets.PETRA).setToughness(2.0f);
        this.setProtection(3, 8, 6, 3, ArmorSets.PRISMARINE).setToughness(2.0f);
        this.setProtection(4, 9, 7, 4, ArmorSets.REDSTONE_RIOT).setToughness(3.0f).setKnockbackRes(0.2f);
        this.setProtection(4, 9, 7, 4, ArmorSets.SHIELD_OF_INFINITY).setToughness(3.0f).setKnockbackRes(0.2f);
        this.setProtection(3, 8, 6, 3, ArmorSets.SOREN).setToughness(2.0f);
        this.setProtection(4, 9, 7, 4, ArmorSets.STAR_SHIELD).setToughness(3.0f).setKnockbackRes(0.2f);
        this.setProtection(4, 9, 7, 4, ArmorSets.SWORDBREAKER).setToughness(2.0f).setKnockbackRes(0.5f);
        this.setProtection(3, 8, 6, 3, ArmorSets.TIMS_ARMOR).setToughness(2.0f);
    }

    static {
        AutoConfig.register(McsaConfig.class, JanksonConfigSerializer::new);
        config = (McsaConfig)AutoConfig.getConfigHolder(McsaConfig.class).getConfig();
    }
}

