/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.boss.render;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.boss.animation.IAnimationTimer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lnet/barribob/boss/render/FrameLimiter;", "", "", "canDoFrame", "()Z", "", "minimumFrameDelta", "F", "", "previousTime", "D", "getPreviousTime", "()D", "setPreviousTime", "(D)V", "Lnet/barribob/boss/animation/IAnimationTimer;", "timer", "Lnet/barribob/boss/animation/IAnimationTimer;", "framesPerUnit", "<init>", "(FLnet/barribob/boss/animation/IAnimationTimer;)V", "BOMD"})
public final class FrameLimiter {
    @NotNull
    private final IAnimationTimer timer;
    private final float minimumFrameDelta;
    private double previousTime;

    public FrameLimiter(float framesPerUnit, @NotNull IAnimationTimer timer) {
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        this.timer = timer;
        this.minimumFrameDelta = 1.0f / framesPerUnit;
    }

    public final double getPreviousTime() {
        return this.previousTime;
    }

    public final void setPreviousTime(double d) {
        this.previousTime = d;
    }

    public final boolean canDoFrame() {
        double currentTick = this.timer.getCurrentTick();
        double frameDelta = currentTick - this.previousTime;
        if (frameDelta >= (double)this.minimumFrameDelta) {
            this.previousTime = currentTick;
            return true;
        }
        return false;
    }
}

