/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.boss.item;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.maelstrom.static_utilities.MathUtils;
import net.barribob.maelstrom.static_utilities.VecUtilsKt;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b \u0010!J!\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ3\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00168\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0018R\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Lnet/barribob/boss/item/WallTeleport;", "", "Lnet/barribob/boss/item/WallTeleport$Context;", "context", "Lnet/minecraft/class_2338;", "startPos", "getTeleportEnd", "(Lnet/barribob/boss/item/WallTeleport$Context;Lnet/minecraft/class_2338;)Lnet/minecraft/class_2338;", "getTeleportStart", "(Lnet/barribob/boss/item/WallTeleport$Context;)Lnet/minecraft/class_2338;", "teleportPos", "", "teleportTo", "(Lnet/minecraft/class_2338;)V", "Lnet/minecraft/class_243;", "direction", "position", "Lkotlin/Function1;", "action", "", "tryTeleport", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;Lkotlin/jvm/functions/Function1;)Z", "", "endRange", "D", "Lnet/minecraft/class_1297;", "entity", "Lnet/minecraft/class_1297;", "startRange", "Lnet/minecraft/class_3218;", "world", "Lnet/minecraft/class_3218;", "<init>", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_1297;)V", "Context", "BOMD"})
public final class WallTeleport {
    @NotNull
    private final class_3218 world;
    @NotNull
    private final class_1297 entity;
    private final double startRange;
    private final double endRange;

    public WallTeleport(@NotNull class_3218 world, @NotNull class_1297 entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.world = world;
        this.entity = entity;
        this.startRange = 3.0;
        this.endRange = 20.0;
    }

    public final boolean tryTeleport(@NotNull class_243 direction, @NotNull class_243 position, @NotNull Function1<? super class_2338, Unit> action) {
        class_2338 teleportEnd;
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Context context = new Context(direction, position);
        class_2338 teleportStart = this.getTeleportStart(context);
        if (teleportStart != null && (teleportEnd = this.getTeleportEnd(context, teleportStart)) != null) {
            action.invoke((Object)teleportEnd);
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean tryTeleport$default(WallTeleport wallTeleport, class_243 class_2432, class_243 class_2433, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = (Function1)new Function1<class_2338, Unit>((Object)wallTeleport){

                public final void invoke(@NotNull class_2338 p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    WallTeleport.access$teleportTo((WallTeleport)this.receiver, p0);
                }
            };
        }
        return wallTeleport.tryTeleport(class_2432, class_2433, (Function1<? super class_2338, Unit>)function1);
    }

    private final class_2338 getTeleportStart(Context context) {
        class_2338 startPos = new class_2338(context.getPosition());
        class_2338 endPos = new class_2338(context.getPosition().method_1019(context.getDirection().method_1021(this.startRange)));
        List blocksToCheck = MathUtils.INSTANCE.getBlocksInLine(startPos, endPos);
        for (class_2338 pos : blocksToCheck) {
            if (!this.world.method_8320(pos).method_26212((class_1922)this.world, pos)) continue;
            return pos;
        }
        return null;
    }

    private final class_2338 getTeleportEnd(Context context, class_2338 startPos) {
        class_2338 endPos = startPos.method_10081((class_2382)new class_2338(context.getDirection().method_1021(this.endRange)));
        Intrinsics.checkNotNullExpressionValue((Object)endPos, (String)"endPos");
        List blocksToCheck = MathUtils.INSTANCE.getBlocksInLine(startPos, endPos);
        for (class_2338 pos : blocksToCheck) {
            class_2680 blockState = this.world.method_8320(pos);
            if (blockState.method_26215() && this.world.method_8320(pos.method_10084()).method_26215()) {
                return pos;
            }
            if (!(blockState.method_26204().method_36555() < 0.0f)) continue;
            return null;
        }
        return null;
    }

    private final void teleportTo(class_2338 teleportPos) {
        class_243 pos = VecUtilsKt.asVec3d((class_2338)teleportPos).method_1019(new class_243(0.5, 0.0, 0.5));
        this.entity.method_5859(pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public static final /* synthetic */ void access$teleportTo(WallTeleport $this, class_2338 teleportPos) {
        $this.teleportTo(teleportPos);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J$\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0014\u001a\u0004\b\u0015\u0010\u0004R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0014\u001a\u0004\b\u0016\u0010\u0004\u00a8\u0006\u0019"}, d2={"Lnet/barribob/boss/item/WallTeleport$Context;", "", "Lnet/minecraft/class_243;", "component1", "()Lnet/minecraft/class_243;", "component2", "direction", "position", "copy", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;)Lnet/barribob/boss/item/WallTeleport$Context;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_243;", "getDirection", "getPosition", "<init>", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;)V", "BOMD"})
    private static final class Context {
        @NotNull
        private final class_243 direction;
        @NotNull
        private final class_243 position;

        public Context(@NotNull class_243 direction, @NotNull class_243 position) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            this.direction = direction;
            this.position = position;
        }

        @NotNull
        public final class_243 getDirection() {
            return this.direction;
        }

        @NotNull
        public final class_243 getPosition() {
            return this.position;
        }

        @NotNull
        public final class_243 component1() {
            return this.direction;
        }

        @NotNull
        public final class_243 component2() {
            return this.position;
        }

        @NotNull
        public final Context copy(@NotNull class_243 direction, @NotNull class_243 position) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            return new Context(direction, position);
        }

        public static /* synthetic */ Context copy$default(Context context, class_243 class_2432, class_243 class_2433, int n, Object object) {
            if ((n & 1) != 0) {
                class_2432 = context.direction;
            }
            if ((n & 2) != 0) {
                class_2433 = context.position;
            }
            return context.copy(class_2432, class_2433);
        }

        @NotNull
        public String toString() {
            return "Context(direction=" + this.direction + ", position=" + this.position + ')';
        }

        public int hashCode() {
            int result = this.direction.hashCode();
            result = result * 31 + this.position.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.direction, (Object)context.direction)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.position, (Object)context.position);
        }
    }
}

