/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.boss.animation;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.boss.animation.IAnimationTimer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0007\u0010\tR\u0016\u0010\n\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\u000bR\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0011"}, d2={"Lnet/barribob/boss/animation/PauseAnimationTimer;", "Lnet/barribob/boss/animation/IAnimationTimer;", "", "getCurrentTick", "()D", "Lkotlin/Function0;", "", "isPaused", "Lkotlin/jvm/functions/Function0;", "()Lkotlin/jvm/functions/Function0;", "pauseStart", "D", "pauseTime", "sysTimeProvider", "getSysTimeProvider", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "BOMD"})
public final class PauseAnimationTimer
implements IAnimationTimer {
    @NotNull
    private final Function0<Double> sysTimeProvider;
    @NotNull
    private final Function0<Boolean> isPaused;
    private double pauseTime;
    private double pauseStart;

    public PauseAnimationTimer(@NotNull Function0<Double> sysTimeProvider, @NotNull Function0<Boolean> isPaused) {
        Intrinsics.checkNotNullParameter(sysTimeProvider, (String)"sysTimeProvider");
        Intrinsics.checkNotNullParameter(isPaused, (String)"isPaused");
        this.sysTimeProvider = sysTimeProvider;
        this.isPaused = isPaused;
    }

    @NotNull
    public final Function0<Double> getSysTimeProvider() {
        return this.sysTimeProvider;
    }

    @NotNull
    public final Function0<Boolean> isPaused() {
        return this.isPaused;
    }

    @Override
    public double getCurrentTick() {
        double sysTime = ((Number)this.sysTimeProvider.invoke()).doubleValue();
        if (((Boolean)this.isPaused.invoke()).booleanValue()) {
            if (this.pauseStart == 0.0) {
                this.pauseStart = sysTime;
            }
            return this.pauseStart - this.pauseTime;
        }
        if (!(this.pauseStart == 0.0)) {
            double timeElapsed = sysTime - this.pauseStart;
            this.pauseTime += timeElapsed;
            this.pauseStart = 0.0;
        }
        return sysTime - this.pauseTime;
    }
}

