/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.world.inventory;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.core.ModServices;
import fuzs.easyanvils.init.ModRegistry;
import fuzs.easyanvils.mixin.accessor.AnvilMenuAccessor;
import fuzs.easyanvils.mixin.accessor.ItemCombinerMenuAccessor;
import fuzs.easyanvils.mixin.accessor.SlotAccessor;
import fuzs.easyanvils.util.ComponentDecomposer;
import fuzs.easyanvils.world.inventory.AnvilMenuState;
import fuzs.easyanvils.world.inventory.BuiltInAnvilMenu;
import fuzs.easyanvils.world.inventory.VanillaAnvilMenu;
import fuzs.easyanvils.world.level.block.entity.AnvilBlockEntity;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1706;
import net.minecraft.class_1712;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3917;

public class ModAnvilMenu
extends class_1706
implements class_1712 {
    private final AnvilMenuState builtInAnvilState;
    private final AnvilMenuState vanillaAnvilState;

    public ModAnvilMenu(int id, class_1661 inventory) {
        super(id, inventory);
        this.builtInAnvilState = new BuiltInAnvilMenu(inventory);
        this.vanillaAnvilState = new VanillaAnvilMenu(inventory);
    }

    public ModAnvilMenu(int id, class_1661 inventory, class_1263 inputSlots, class_3914 containerLevelAccess) {
        super(id, inventory, containerLevelAccess);
        this.updateInputSlots(inputSlots);
        this.method_7596(this);
        this.builtInAnvilState = new BuiltInAnvilMenu(inventory);
        this.vanillaAnvilState = new VanillaAnvilMenu(inventory);
    }

    private void updateInputSlots(class_1263 inputSlots) {
        ((ItemCombinerMenuAccessor)((Object)this)).setInputSlots(inputSlots);
        ((SlotAccessor)this.field_7761.get(0)).setContainer(inputSlots);
        ((SlotAccessor)this.field_7761.get(1)).setContainer(inputSlots);
    }

    protected void method_24923(class_1657 player, class_1799 stack) {
        super.method_24923(player, stack);
        this.field_22481.method_17393((level, pos) -> {
            class_2586 patt2870$temp = level.method_8321(pos);
            if (patt2870$temp instanceof AnvilBlockEntity) {
                AnvilBlockEntity blockEntity = (AnvilBlockEntity)patt2870$temp;
                this.updateInputSlots(blockEntity);
            }
        });
    }

    public class_3917<?> method_17358() {
        return (class_3917)ModRegistry.ANVIL_MENU_TYPE.get();
    }

    public boolean method_7597(class_1657 player) {
        return this.field_22480.method_5443(player);
    }

    protected boolean method_24927(class_1657 player, boolean hasStack) {
        return (player.method_31549().field_7477 || player.field_7520 >= this.method_17369()) && this.method_17369() >= 0;
    }

    public void method_24928() {
        if (this.builtInAnvilState == null || this.vanillaAnvilState == null) {
            return;
        }
        class_1799 left = this.field_22480.method_5438(0);
        class_1799 right = this.field_22480.method_5438(1);
        String itemName = ((AnvilMenuAccessor)((Object)this)).easyanvils$getItemName();
        this.builtInAnvilState.init(left, right, itemName);
        this.vanillaAnvilState.init(left, right, itemName);
        this.builtInAnvilState.fillResultSlots();
        this.vanillaAnvilState.fillResultSlots();
        if (!AnvilMenuState.equals(this.builtInAnvilState, this.vanillaAnvilState)) {
            super.method_24928();
        } else {
            this.createResult(left, right, itemName);
        }
    }

    private void createResult(class_1799 left, class_1799 right, String itemName) {
        this.setCost(1);
        if (left.method_7960()) {
            this.field_22479.method_5447(0, class_1799.field_8037);
            this.setCost(0);
        } else {
            int allOperationsCost;
            class_1799 output = left.method_7972();
            Map map = class_1890.method_8222((class_1799)output);
            int baseRepairCost = left.method_7928() + (right.method_7960() ? 0 : right.method_7928());
            baseRepairCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.operator.applyAsInt(baseRepairCost);
            this.setRepairItemCountCost(0);
            boolean isBook = false;
            int repairOperationCost = 0;
            int enchantOperationCost = 0;
            int renameOperationCost = 0;
            int maxAnvilRepairCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).tooExpensiveLimit;
            if (!right.method_7960()) {
                boolean bl = isBook = right.method_7909() == class_1802.field_8598 && !class_1772.method_7806((class_1799)right).isEmpty();
                if (output.method_7963() && output.method_7909().method_7878(left, right)) {
                    int repairMaterials;
                    int l2 = Math.min(output.method_7919(), output.method_7936() / 4);
                    if (l2 <= 0) {
                        this.field_22479.method_5447(0, class_1799.field_8037);
                        this.setCost(0);
                        return;
                    }
                    for (repairMaterials = 0; l2 > 0 && repairMaterials < right.method_7947(); ++repairMaterials) {
                        int j3 = output.method_7919() - l2;
                        output.method_7974(j3);
                        repairOperationCost += ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithMaterialUnitCost;
                        l2 = Math.min(output.method_7919(), output.method_7936() / 4);
                    }
                    this.setRepairItemCountCost(repairMaterials);
                } else {
                    if (!(isBook || output.method_31574(right.method_7909()) && output.method_7963())) {
                        this.field_22479.method_5447(0, class_1799.field_8037);
                        this.setCost(0);
                        return;
                    }
                    if (output.method_7963() && !isBook) {
                        int l = left.method_7936() - left.method_7919();
                        int i1 = right.method_7936() - right.method_7919();
                        int j1 = i1 + output.method_7936() * 12 / 100;
                        int k1 = l + j1;
                        int l1 = output.method_7936() - k1;
                        if (l1 < 0) {
                            l1 = 0;
                        }
                        if (l1 < output.method_7919()) {
                            output.method_7974(l1);
                            repairOperationCost += ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithOtherItemCost;
                        }
                    }
                    Map map1 = class_1890.method_8222((class_1799)right);
                    boolean flag2 = false;
                    boolean flag3 = false;
                    for (class_1887 enchantment1 : map1.keySet()) {
                        Integer oldEnchantmentLevel;
                        int rarityCostMultiplier;
                        int enchantmentLevel;
                        if (enchantment1 == null) continue;
                        int otherEnchantmentLevel = map.getOrDefault(enchantment1, 0);
                        enchantmentLevel = otherEnchantmentLevel == (enchantmentLevel = ((Integer)map1.get(enchantment1)).intValue()) ? enchantmentLevel + 1 : Math.max(enchantmentLevel, otherEnchantmentLevel);
                        boolean compatibleWithItem = enchantment1.method_8192(left);
                        if (this.field_22482.method_31549().field_7477 || left.method_31574(class_1802.field_8598)) {
                            compatibleWithItem = true;
                        }
                        for (class_1887 enchantment : map.keySet()) {
                            if (enchantment == enchantment1 || enchantment1.method_8188(enchantment)) continue;
                            compatibleWithItem = false;
                            ++enchantOperationCost;
                        }
                        if (!compatibleWithItem) {
                            if (repairOperationCost > 0) continue;
                            flag3 = true;
                            continue;
                        }
                        flag2 = true;
                        if (enchantmentLevel > enchantment1.method_8183()) {
                            enchantmentLevel = enchantment1.method_8183();
                        }
                        int maxLevel = Math.max(map.getOrDefault(enchantment1, 0), (Integer)map1.get(enchantment1));
                        if ((maxLevel = Math.max(maxLevel, enchantmentLevel)) != enchantmentLevel) {
                            enchantmentLevel = maxLevel;
                        }
                        switch (enchantment1.method_8186()) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case field_9087: {
                                int n = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.commonEnchantmentMultiplier;
                                break;
                            }
                            case field_9090: {
                                int n = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.uncommonEnchantmentMultiplier;
                                break;
                            }
                            case field_9088: {
                                int n = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.rareEnchantmentMultiplier;
                                break;
                            }
                            case field_9091: {
                                int n = rarityCostMultiplier = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.veryRareEnchantmentMultiplier;
                            }
                        }
                        if (isBook && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.halvedBookCosts) {
                            rarityCostMultiplier = Math.max(1, rarityCostMultiplier / 2);
                        }
                        if ((oldEnchantmentLevel = map.put(enchantment1, enchantmentLevel)) == null || oldEnchantmentLevel != enchantmentLevel) {
                            enchantOperationCost += rarityCostMultiplier * enchantmentLevel;
                        }
                        if (left.method_7947() <= 1 || this.field_22482.method_31549().field_7477) continue;
                        this.field_22479.method_5447(0, class_1799.field_8037);
                        this.setCost(-1);
                        return;
                    }
                    if (flag3 && !flag2) {
                        this.field_22479.method_5447(0, class_1799.field_8037);
                        this.setCost(0);
                        return;
                    }
                }
            }
            boolean hasRenamedItem = false;
            if (ComponentDecomposer.getStringLength(itemName) == 0) {
                if (left.method_7938()) {
                    renameOperationCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).freeRenames.filter.test(left) ? 0 : 1;
                    hasRenamedItem = true;
                    output.method_7925();
                }
            } else if (!itemName.equals(ComponentDecomposer.toFormattedString(left.method_7964()))) {
                renameOperationCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).freeRenames.filter.test(left) ? 0 : 1;
                hasRenamedItem = true;
                output.method_7977(ComponentDecomposer.toFormattedComponent(itemName));
            }
            if (isBook && !ModServices.ABSTRACTIONS.isBookEnchantable(output, right)) {
                output = class_1799.field_8037;
            }
            if ((allOperationsCost = enchantOperationCost + repairOperationCost + renameOperationCost) == 0) {
                this.setCost(0);
                if (!hasRenamedItem) {
                    output = class_1799.field_8037;
                }
            } else if (enchantOperationCost == 0 && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).renameAndRepairCosts == ServerConfig.RenameAndRepairCost.FIXED) {
                this.setCost(allOperationsCost);
            } else {
                this.setCost(baseRepairCost + allOperationsCost);
            }
            if (enchantOperationCost == 0 && this.method_17369() >= maxAnvilRepairCost && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).renameAndRepairCosts == ServerConfig.RenameAndRepairCost.LIMITED) {
                if (maxAnvilRepairCost == -1) {
                    this.setCost(39);
                } else {
                    this.setCost(maxAnvilRepairCost - 1);
                }
            }
            if (this.method_17369() >= maxAnvilRepairCost && maxAnvilRepairCost != -1 && !this.field_22482.method_31549().field_7477) {
                output = class_1799.field_8037;
            }
            if (!output.method_7960()) {
                int outputRepairCost = output.method_7928();
                if (!right.method_7960() && outputRepairCost < right.method_7928()) {
                    outputRepairCost = right.method_7928();
                }
                if (!(allOperationsCost <= 0 || enchantOperationCost <= 0 && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).penaltyFreeRenamesAndRepairs)) {
                    outputRepairCost = class_1706.method_20398((int)outputRepairCost);
                }
                if (outputRepairCost > 0) {
                    output.method_7927(outputRepairCost);
                }
                class_1890.method_8214((Map)map, (class_1799)output);
            }
            this.field_22479.method_5447(0, output);
            this.method_7623();
        }
    }

    public void setCost(int cost) {
        this.method_7606(0, cost);
    }

    public void setRepairItemCountCost(int repairItemCountCost) {
        ((AnvilMenuAccessor)((Object)this)).easyanvils$setRepairItemCountCost(repairItemCountCost);
    }

    public void method_7595(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_1799 itemstack = this.method_34255();
            if (!itemstack.method_7960()) {
                if (player.method_5805() && !serverPlayer.method_14239()) {
                    player.method_31548().method_7398(itemstack);
                } else {
                    player.method_7328(itemstack, false);
                }
                this.method_34254(class_1799.field_8037);
            }
        }
        this.method_7603(this);
    }

    public void method_7625(String newName) {
        ((AnvilMenuAccessor)((Object)this)).easyanvils$setItemName(newName);
        if (this.method_7611(2).method_7681()) {
            class_1799 itemStack = this.method_7611(2).method_7677();
            class_2561 component = ComponentDecomposer.toFormattedComponent(newName);
            if (component.getString().isEmpty()) {
                itemStack.method_7925();
            } else {
                itemStack.method_7977(component);
            }
        }
        this.method_24928();
    }

    public void method_7635(class_1703 containerToSend, int dataSlotIndex, class_1799 stack) {
        if (containerToSend == this && dataSlotIndex >= 0 && dataSlotIndex < 2) {
            this.method_7609(this.field_22480);
        }
    }

    public void method_7633(class_1703 containerMenu, int dataSlotIndex, int value) {
    }

    public static int repairCostToRepairs(int repairCost) {
        ++repairCost;
        int repairs = 0;
        while (repairCost >= 2) {
            repairCost /= 2;
            ++repairs;
        }
        return repairs;
    }
}

