/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_5224;
import net.minecraft.class_5225;
import net.minecraft.class_5481;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class FormattedStringDecomposer {
    public static int stringWidth(class_327 font, @Nullable String content, int skip) {
        if (content == null) {
            return 0;
        }
        MutableFloat mutableFloat = new MutableFloat();
        FormattedStringDecomposer.iterateFormatted(content, class_2583.field_24360, (index, style, j) -> {
            if (index >= skip) {
                mutableFloat.add(font.method_27527().method_30875(class_5481.method_30747((String)Character.toString(j), (class_2583)style)));
            }
            return true;
        });
        return class_3532.method_15386((float)mutableFloat.floatValue());
    }

    public static boolean isAllowedChatCharacter(char character) {
        return character >= ' ' && character != '\u007f';
    }

    public static String filterText(String input) {
        return FormattedStringDecomposer.filterText(input, false);
    }

    public static String filterText(String string, boolean keepLinesBreaks) {
        char[] var3;
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : var3 = string.toCharArray()) {
            if (FormattedStringDecomposer.isAllowedChatCharacter(c)) {
                stringBuilder.append(c);
                continue;
            }
            if (!keepLinesBreaks || c != '\n') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static int plainIndexAtWidth(class_327 font, String content, int skip, int maxWidth, class_2583 style) {
        WidthLimitedCharSink widthLimitedCharSink = new WidthLimitedCharSink(font.method_27527(), maxWidth, skip);
        FormattedStringDecomposer.iterateFormatted(content, style, widthLimitedCharSink);
        return widthLimitedCharSink.getPosition();
    }

    public static String plainHeadByWidth(class_327 font, String content, int skip, int maxWidth, class_2583 style) {
        return content.substring(skip, FormattedStringDecomposer.plainIndexAtWidth(font, content, skip, maxWidth, style));
    }

    public static String plainTailByWidth(class_327 font, String content, int maxWidth, class_2583 style) {
        MutableFloat mutableFloat = new MutableFloat();
        MutableInt mutableInt = new MutableInt(content.length());
        FormattedStringDecomposer.iterateFormattedBackwards(content, style, (j, stylex, k) -> {
            float stringWidth = font.method_27527().method_30875(class_5481.method_30747((String)Character.toString(k), (class_2583)stylex));
            float f = mutableFloat.addAndGet(stringWidth);
            if (f > (float)maxWidth) {
                return false;
            }
            mutableInt.setValue(j);
            return true;
        });
        return content.substring(mutableInt.intValue());
    }

    public static boolean iterateFormatted(String text, class_2583 defaultStyle, class_5224 sink) {
        int textLength = text.length();
        class_2583 currentStyle = defaultStyle;
        for (int position = 0; position < textLength; ++position) {
            char character = text.charAt(position);
            if (character == '\u00a7') {
                if (position + 1 < textLength) {
                    char d = text.charAt(position + 1);
                    class_124 chatFormatting = class_124.method_544((char)d);
                    if (chatFormatting != null) {
                        class_2583 class_25832 = currentStyle = chatFormatting == class_124.field_1070 ? defaultStyle : currentStyle.method_27707(chatFormatting);
                    }
                    if (FormattedStringDecomposer.feedChar(text, defaultStyle, sink, position, character, textLength) == -1) {
                        return false;
                    }
                    if (FormattedStringDecomposer.feedChar(text, defaultStyle, sink, ++position, text.charAt(position), textLength) != -1) continue;
                    return false;
                }
                return FormattedStringDecomposer.feedChar(text, defaultStyle, sink, position, character, textLength) != -1;
            }
            if ((position = FormattedStringDecomposer.feedChar(text, currentStyle, sink, position, character, textLength)) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean iterateFormattedBackwards(String text, class_2583 defaultStyle, class_5224 sink) {
        ArrayList list = Lists.newArrayList();
        FormattedStringDecomposer.iterateFormatted(text, defaultStyle, (index, style, j) -> {
            list.add(class_5481.method_30747((String)Character.toString(j), (class_2583)style));
            return true;
        });
        for (int i = list.size() - 1; i >= 0; --i) {
            if (((class_5481)list.get(i)).accept(sink)) continue;
            return false;
        }
        return true;
    }

    private static int feedChar(String text, class_2583 style, class_5224 sink, int position, char character, int textLength) {
        if (Character.isHighSurrogate(character)) {
            if (position + 1 >= textLength) {
                if (!sink.accept(position, style, 65533)) {
                    return -1;
                }
                return textLength;
            }
            char d = text.charAt(position + 1);
            if (Character.isLowSurrogate(d)) {
                if (!sink.accept(position, style, Character.toCodePoint(character, d))) {
                    return -1;
                }
                ++position;
            } else if (!sink.accept(position, style, 65533)) {
                return -1;
            }
        } else if (!FormattedStringDecomposer.feedChar(style, sink, position, character)) {
            return -1;
        }
        return position;
    }

    private static boolean feedChar(class_2583 style, class_5224 sink, int position, char character) {
        return Character.isSurrogate(character) ? sink.accept(position, style, 65533) : sink.accept(position, style, (int)character);
    }

    private static class WidthLimitedCharSink
    implements class_5224 {
        private final class_5225 splitter;
        private float maxWidth;
        private final int skip;
        private int position;

        public WidthLimitedCharSink(class_5225 splitter, float f, int skip) {
            this.splitter = splitter;
            this.maxWidth = f;
            this.skip = skip;
        }

        public boolean accept(int i, class_2583 style, int j) {
            if (i >= this.skip) {
                this.maxWidth -= this.splitter.method_30875(class_5481.method_30747((String)Character.toString(j), (class_2583)style));
            }
            if (this.maxWidth >= 0.0f) {
                this.position = i + Character.charCount(j);
                return true;
            }
            return false;
        }

        public int getPosition() {
            return this.position;
        }

        public void resetPosition() {
            this.position = 0;
        }
    }

    public static class LengthLimitedCharSink
    implements class_5224 {
        private final int skip;
        private int maxLength;

        public LengthLimitedCharSink(int maxLength, int skip) {
            this.maxLength = maxLength;
            this.skip = skip;
        }

        public boolean accept(int i, class_2583 style, int j) {
            if (i >= this.skip) {
                this.maxLength -= Character.charCount(j);
            } else {
                return false;
            }
            return this.maxLength >= 0;
        }
    }
}

