/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client.gui.components;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.easyanvils.client.gui.components.TypeActionManager;
import fuzs.easyanvils.util.ComponentDecomposer;
import fuzs.easyanvils.util.FormattedStringDecomposer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public class OpenEditBox
extends class_342 {
    private final class_327 font;
    String value = "";
    private int maxLength = 32;
    private int frame;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private boolean shiftPressed;
    int displayPos;
    int cursorPos;
    int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    @Nullable
    private String suggestion;
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, class_5481> formatter = (formatterValue, position) -> {
        ArrayList list = Lists.newArrayList();
        FormattedStringDecomposer.LengthLimitedCharSink sink = new FormattedStringDecomposer.LengthLimitedCharSink(formatterValue.length(), (int)position);
        FormattedStringDecomposer.iterateFormatted(this.value, class_2583.field_24360, (index, style, j) -> {
            if (sink.accept(index, style, j)) {
                list.add(formattedCharSink -> formattedCharSink.accept(index, style, j));
            }
            return true;
        });
        return class_5481.method_30749((List)list);
    };
    private long lastClickTime;
    private int lastClickButton;
    private boolean doubleClick;
    public TypeActionManager typeActionManager = new TypeActionManager();

    public OpenEditBox(class_327 font, int i, int j, int k, int l, class_2561 component) {
        this(font, i, j, k, l, null, component);
    }

    public OpenEditBox(class_327 font, int i, int j, int k, int l, @Nullable OpenEditBox editBox, class_2561 component) {
        super(font, i, j, k, l, (class_342)editBox, component);
        this.font = font;
        if (editBox != null) {
            this.method_1852(editBox.method_1882());
        }
    }

    public void method_1863(Consumer<String> responder) {
        this.responder = responder;
    }

    public void method_1854(BiFunction<String, Integer, class_5481> textFormatter) {
        this.formatter = textFormatter;
    }

    public void method_1865() {
        ++this.frame;
    }

    protected class_5250 method_25360() {
        class_2561 component = this.method_25369();
        return class_2561.method_43469((String)"gui.narrate.editBox", (Object[])new Object[]{component, this.value});
    }

    public void method_1852(String text) {
        if (this.filter.test(text)) {
            int aboveMaxLength = ComponentDecomposer.getStringLength(text) - this.maxLength;
            this.value = aboveMaxLength > 0 ? ComponentDecomposer.removeLast(text, aboveMaxLength) : text;
            this.method_1872();
            this.method_1884(this.cursorPos);
            this.onValueChange(text);
        }
    }

    public String method_1882() {
        return this.value;
    }

    public String method_1866() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public boolean hasHighlighted() {
        return this.highlightPos != this.cursorPos;
    }

    public void method_1890(Predicate<String> validator) {
        this.filter = validator;
    }

    public void method_1867(String textToWrite) {
        String string2;
        String string;
        int j;
        int i = Math.min(this.cursorPos, this.highlightPos);
        String string3 = new StringBuilder(this.value).replace(i, j = Math.max(this.cursorPos, this.highlightPos), string = FormattedStringDecomposer.filterText(textToWrite)).toString();
        int stringLength = ComponentDecomposer.getStringLength(string3) - this.maxLength;
        if (stringLength > 0) {
            string = ComponentDecomposer.removeLast(textToWrite, stringLength);
        }
        if (this.filter.test(string2 = new StringBuilder(this.value).replace(i, j, string).toString())) {
            this.value = string2;
            int l = string.length();
            this.method_1875(i + l);
            this.method_1884(this.cursorPos);
            this.onValueChange(this.value);
        }
    }

    private void onValueChange(String newText) {
        this.typeActionManager.trySave(this);
        if (this.responder != null) {
            this.responder.accept(newText);
        }
    }

    private void deleteText(int count) {
        if (class_437.method_25441()) {
            this.method_1878(this.cursorPos);
        } else if (class_437.method_25443()) {
            this.method_1877(count);
        } else {
            this.method_1878(count);
        }
    }

    public void method_1877(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.method_1867("");
            } else {
                this.method_1878(this.method_1853(num) - this.cursorPos);
            }
        }
    }

    public void method_1878(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.method_1867("");
            } else {
                String string;
                int k;
                int i = this.getCursorPos(num);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos)) && this.filter.test(string = new StringBuilder(this.value).delete(j, k).toString())) {
                    this.value = string;
                    this.method_1883(j);
                }
            }
        }
    }

    public int method_1853(int numWords) {
        return this.getWordPosition(numWords, this.method_1881());
    }

    private int getWordPosition(int n, int pos) {
        return this.getWordPosition(n, pos, true);
    }

    private int getWordPosition(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean backwards = n < 0;
        int skippedWords = Math.abs(n);
        for (int k = 0; k < skippedWords; ++k) {
            if (!backwards) {
                int l = this.value.length();
                while (skipWs && i == pos && i < l && this.value.charAt(i) == ' ') {
                    ++i;
                    ++pos;
                }
                while (i < l && this.value.charAt(i) != ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i == pos && i > 0 && this.value.charAt(i - 1) == ' ') {
                --i;
                --pos;
            }
            while (i > 0 && this.value.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void method_1855(int delta) {
        this.method_1883(this.getCursorPos(delta));
    }

    private int getCursorPos(int delta) {
        return class_156.method_27761((String)this.value, (int)this.cursorPos, (int)delta);
    }

    public void method_1883(int pos) {
        this.method_1875(pos);
        if (!this.shiftPressed) {
            this.method_1884(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void method_1875(int pos) {
        this.cursorPos = class_3532.method_15340((int)pos, (int)0, (int)this.value.length());
        this.setDisplayPosition(this.cursorPos);
    }

    public void method_1870() {
        this.method_1883(0);
    }

    public void method_1872() {
        this.method_1883(this.value.length());
    }

    public static boolean isUndo(int keyCode) {
        return keyCode == 89 && class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443();
    }

    public static boolean isRedo(int keyCode) {
        return keyCode == 89 && class_437.method_25441() && class_437.method_25442() && !class_437.method_25443();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.method_20315()) {
            return false;
        }
        this.shiftPressed = class_437.method_25442();
        if (class_437.method_25439((int)keyCode)) {
            this.method_1872();
            this.method_1884(0);
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.method_1866());
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            if (this.isEditable) {
                this.method_1867(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.method_1866());
            if (this.isEditable) {
                this.method_1867("");
            }
            return true;
        }
        if (OpenEditBox.isUndo(keyCode)) {
            this.typeActionManager.undo(this);
            return true;
        }
        if (OpenEditBox.isRedo(keyCode)) {
            this.typeActionManager.redo(this);
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            case 262: {
                boolean canMove = true;
                if (!this.shiftPressed && this.hasHighlighted()) {
                    this.method_1875(Math.max(this.method_1881(), this.highlightPos));
                    this.method_1884(this.method_1881());
                    canMove = false;
                }
                if (class_437.method_25441()) {
                    this.method_1872();
                } else if (class_437.method_25443()) {
                    this.method_1883(this.method_1853(1));
                } else if (canMove) {
                    this.method_1855(1);
                }
                return true;
            }
            case 263: {
                boolean canMove = true;
                if (!this.shiftPressed && this.hasHighlighted()) {
                    this.method_1875(Math.min(this.method_1881(), this.highlightPos));
                    this.method_1884(this.method_1881());
                    canMove = false;
                }
                if (class_437.method_25441()) {
                    this.method_1870();
                } else if (class_437.method_25443()) {
                    this.method_1883(this.method_1853(-1));
                } else if (canMove) {
                    this.method_1855(-1);
                }
                return true;
            }
            case 268: {
                this.method_1870();
                return true;
            }
            case 269: 
        }
        this.method_1872();
        return true;
    }

    public boolean method_20315() {
        return this.method_1885() && this.method_25370() && this.isEditable();
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (!this.method_20315()) {
            return false;
        }
        if (FormattedStringDecomposer.isAllowedChatCharacter(codePoint)) {
            if (this.isEditable) {
                this.method_1867(Character.toString(codePoint));
            }
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean bl;
        if (!this.method_1885()) {
            return false;
        }
        boolean bl2 = bl = mouseX >= (double)this.field_22760 && mouseX < (double)(this.field_22760 + this.field_22758) && mouseY >= (double)this.field_22761 && mouseY < (double)(this.field_22761 + this.field_22759);
        if (this.canLoseFocus) {
            this.method_1876(bl);
        }
        if (this.method_25370() && bl) {
            if (button == 0) {
                int i = class_3532.method_15357((double)mouseX) - this.field_22760;
                if (this.bordered) {
                    i -= 4;
                }
                this.shiftPressed = class_437.method_25442();
                String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, this.method_1859(), class_2583.field_24360);
                this.method_1883(FormattedStringDecomposer.plainHeadByWidth(this.font, string, 0, i, class_2583.field_24360).length() + this.displayPos);
                long millis = class_156.method_658();
                boolean tripleClick = this.doubleClick;
                boolean bl3 = this.doubleClick = millis - this.lastClickTime < 250L && this.lastClickButton == button;
                if (tripleClick &= this.doubleClick) {
                    this.method_1872();
                    this.method_1884(0);
                } else if (this.doubleClick) {
                    this.shiftPressed = false;
                    this.method_1883(this.getWordPosition(1, this.method_1881(), false));
                    this.shiftPressed = true;
                    this.method_1883(this.getWordPosition(-1, this.method_1881(), false));
                    this.shiftPressed = class_437.method_25442();
                }
                this.lastClickTime = millis;
                this.lastClickButton = button;
                return true;
            }
            if (button == 1) {
                this.method_1852("");
            }
            return false;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean bl;
        if (!this.method_1885()) {
            return false;
        }
        boolean bl2 = bl = mouseX >= (double)this.field_22760 && mouseX < (double)(this.field_22760 + this.field_22758) && mouseY >= (double)this.field_22761 && mouseY < (double)(this.field_22761 + this.field_22759);
        if (this.method_25370() && bl && button == 0) {
            int i = class_3532.method_15357((double)mouseX) - this.field_22760;
            if (this.bordered) {
                i -= 4;
            }
            this.shiftPressed = true;
            String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, this.method_1859(), class_2583.field_24360);
            this.method_1883(FormattedStringDecomposer.plainHeadByWidth(this.font, string, 0, i, class_2583.field_24360).length() + this.displayPos);
            this.shiftPressed = class_437.method_25442();
            return true;
        }
        return false;
    }

    public void method_1876(boolean isFocused) {
        this.method_25365(isFocused);
    }

    public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.method_1885()) {
            int i;
            if (this.isBordered()) {
                i = this.method_25370() ? -1 : -6250336;
                OpenEditBox.method_25294((class_4587)poseStack, (int)(this.field_22760 - 1), (int)(this.field_22761 - 1), (int)(this.field_22760 + this.field_22758 + 1), (int)(this.field_22761 + this.field_22759 + 1), (int)i);
                OpenEditBox.method_25294((class_4587)poseStack, (int)this.field_22760, (int)this.field_22761, (int)(this.field_22760 + this.field_22758), (int)(this.field_22761 + this.field_22759), (int)-16777216);
            }
            i = this.isEditable ? this.textColor : this.textColorUneditable;
            int j = this.cursorPos - this.displayPos;
            int k = this.highlightPos - this.displayPos;
            String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, this.method_1859(), class_2583.field_24360);
            boolean bl = j >= 0 && j <= string.length();
            boolean bl2 = this.method_25370() && this.frame / 6 % 2 == 0 && bl;
            int l = this.bordered ? this.field_22760 + 4 : this.field_22760;
            int m = this.bordered ? this.field_22761 + (this.field_22759 - 8) / 2 : this.field_22761;
            int n = l;
            if (k > string.length()) {
                k = string.length();
            }
            if (!string.isEmpty()) {
                String string2 = bl ? string.substring(0, j) : string;
                n = this.font.method_27517(poseStack, this.formatter.apply(string2, this.displayPos), (float)l, (float)m, i);
            }
            boolean bl3 = this.cursorPos < this.value.length() || ComponentDecomposer.getStringLength(this.value) >= this.getMaxLength();
            int o = n;
            if (!bl) {
                o = j > 0 ? l + this.field_22758 : l;
            } else if (!string.isEmpty()) {
                o = n - 1;
                --n;
            }
            if (!string.isEmpty() && bl && j < string.length()) {
                this.font.method_27517(poseStack, this.formatter.apply(string.substring(j), this.cursorPos), (float)n, (float)m, i);
            }
            if (!bl3 && this.suggestion != null) {
                this.font.method_1720(poseStack, this.suggestion, (float)(o - 1), (float)m, -8355712);
            }
            if (bl2 && k == j) {
                if (!string.isEmpty()) {
                    class_332.method_25294((class_4587)poseStack, (int)o, (int)(m - 1), (int)(o + 1), (int)(m + 1 + 9), (int)-3092272);
                } else {
                    this.font.method_1720(poseStack, "_", (float)o, (float)m, i);
                }
            }
            if (k != j) {
                int p = l + FormattedStringDecomposer.stringWidth(this.font, this.value.substring(0, this.highlightPos), this.displayPos);
                this.renderHighlight(o, m - 1, p - 1, m + 1 + 9);
            }
        }
    }

    private void renderHighlight(int startX, int startY, int endX, int endY) {
        int i;
        if (startX < endX) {
            i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            i = startY;
            startY = endY;
            endY = i;
        }
        if (endX > this.field_22760 + this.field_22758) {
            endX = this.field_22760 + this.field_22758;
        }
        if (startX > this.field_22760 + this.field_22758) {
            startX = this.field_22760 + this.field_22758;
        }
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22912((double)startX, (double)endY, 0.0).method_1344();
        bufferBuilder.method_22912((double)endX, (double)endY, 0.0).method_1344();
        bufferBuilder.method_22912((double)endX, (double)startY, 0.0).method_1344();
        bufferBuilder.method_22912((double)startX, (double)startY, 0.0).method_1344();
        tesselator.method_1350();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public void method_1880(int length) {
        this.maxLength = length;
        if (this.value.length() > length) {
            this.value = this.value.substring(0, length);
            this.onValueChange(this.value);
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int method_1881() {
        return this.cursorPos;
    }

    private boolean isBordered() {
        return this.bordered;
    }

    public void method_1858(boolean enableBackgroundDrawing) {
        this.bordered = enableBackgroundDrawing;
    }

    public void method_1868(int color) {
        this.textColor = color;
    }

    public void method_1860(int color) {
        this.textColorUneditable = color;
    }

    public boolean method_25407(boolean focus) {
        return this.field_22764 && this.isEditable ? super.method_25407(focus) : false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && mouseX >= (double)this.field_22760 && mouseX < (double)(this.field_22760 + this.field_22758) && mouseY >= (double)this.field_22761 && mouseY < (double)(this.field_22761 + this.field_22759);
    }

    protected void method_25363(boolean focused) {
        if (focused) {
            this.frame = 0;
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void method_1888(boolean enabled) {
        this.isEditable = enabled;
    }

    public int method_1859() {
        return this.isBordered() ? this.field_22758 - 8 : this.field_22758;
    }

    public void method_1884(int position) {
        this.highlightPos = class_3532.method_15340((int)position, (int)0, (int)this.value.length());
    }

    public void setDisplayPosition(int position) {
        if (this.font != null) {
            int i = this.value.length();
            if (this.displayPos > i) {
                this.displayPos = i;
            }
            int j = this.method_1859();
            String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, j, class_2583.field_24360);
            int k = string.length() + this.displayPos;
            if (position == this.displayPos) {
                this.displayPos -= FormattedStringDecomposer.plainTailByWidth(this.font, this.value, j, class_2583.field_24360).length();
            }
            if (position > k) {
                this.displayPos += position - k;
            } else if (position <= this.displayPos) {
                this.displayPos -= this.displayPos - position;
            }
            this.displayPos = class_3532.method_15340((int)this.displayPos, (int)0, (int)i);
        }
    }

    public void method_1856(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    public boolean method_1885() {
        return this.field_22764;
    }

    public void method_1862(boolean isVisible) {
        this.field_22764 = isVisible;
    }

    public void method_1887(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    public int method_1889(int charNum) {
        return charNum > this.value.length() ? this.field_22760 : this.field_22760 + FormattedStringDecomposer.stringWidth(this.font, this.value.substring(0, charNum), 0);
    }

    public void method_16872(int x) {
        this.field_22760 = x;
    }

    public void method_37020(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43469((String)"narration.edit_box", (Object[])new Object[]{this.method_1882()}));
    }
}

