/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.network;

import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.map.CustomDataHolder;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1806;
import net.minecraft.class_22;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_330;

public class ClientBoundSyncCustomMapDecorationMessage
implements Message {
    private final int mapId;
    private final byte scale;
    private final boolean locked;
    private final CustomMapDecoration[] customDecorations;
    private final CustomDataHolder.Instance<?>[] customData;

    public ClientBoundSyncCustomMapDecorationMessage(int mapId, byte pScale, boolean pLocked, CustomMapDecoration[] customDecorations, CustomDataHolder.Instance<?>[] customData) {
        this.mapId = mapId;
        this.scale = pScale;
        this.locked = pLocked;
        this.customData = customData;
        this.customDecorations = customDecorations;
    }

    @Override
    public void writeToBuffer(class_2540 buffer) {
        buffer.method_10804(this.mapId);
        buffer.writeByte((int)this.scale);
        buffer.writeBoolean(this.locked);
        buffer.method_10804(this.customDecorations.length);
        for (CustomMapDecoration decoration : this.customDecorations) {
            buffer.method_10812(Utils.getID(decoration.getType()));
            decoration.saveToBuffer(buffer);
        }
        buffer.method_10804(this.customData.length);
        for (CustomDataHolder.Instance<?> data : this.customData) {
            buffer.method_10814(data.getType().id().toString());
            data.saveToBuffer(buffer);
        }
    }

    public ClientBoundSyncCustomMapDecorationMessage(class_2540 pBuffer) {
        Object type;
        int m;
        this.mapId = pBuffer.method_10816();
        this.scale = pBuffer.readByte();
        this.locked = pBuffer.readBoolean();
        this.customDecorations = new CustomMapDecoration[pBuffer.method_10816()];
        for (m = 0; m < this.customDecorations.length; ++m) {
            type = MapDecorationRegistry.get(pBuffer.method_10810());
            if (type == null) continue;
            this.customDecorations[m] = ((MapDecorationType)type).loadDecorationFromBuffer(pBuffer);
        }
        this.customData = new CustomDataHolder.Instance[pBuffer.method_10816()];
        for (m = 0; m < this.customData.length; ++m) {
            type = MapDecorationRegistry.CUSTOM_MAP_DATA_TYPES.getOrDefault(new class_2960(pBuffer.method_19772()), null);
            if (type == null) continue;
            this.customData[m] = ((CustomDataHolder)type).createFromBuffer(pBuffer);
        }
    }

    @Override
    public void handle(ChannelHandler.Context context) {
        if (context.getDirection() == NetworkDir.PLAY_TO_CLIENT) {
            class_330 mapRenderer = class_310.method_1551().field_1773.method_3194();
            int i = this.getMapId();
            String s = class_1806.method_17440((int)i);
            class_22 mapData = class_310.method_1551().field_1687.method_17891(s);
            if (mapData != null) {
                this.applyToMap(mapData);
                mapRenderer.method_1769(i, mapData);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public int getMapId() {
        return this.mapId;
    }

    @Environment(value=EnvType.CLIENT)
    public void applyToMap(class_22 data) {
        if (data instanceof ExpandedMapData) {
            ExpandedMapData mapData = (ExpandedMapData)data;
            Map<String, CustomMapDecoration> decorations = mapData.getCustomDecorations();
            decorations.clear();
            for (int i = 0; i < this.customDecorations.length; ++i) {
                CustomMapDecoration customDecoration = this.customDecorations[i];
                if (customDecoration != null) {
                    decorations.put("icon-" + i, customDecoration);
                    continue;
                }
                Moonlight.LOGGER.warn("Failed to load custom map decoration, skipping");
            }
            Map<class_2960, CustomDataHolder.Instance<?>> customData = mapData.getCustomData();
            customData.clear();
            for (CustomDataHolder.Instance<?> instance : this.customData) {
                if (instance != null) {
                    customData.put(instance.getType().id(), instance);
                    continue;
                }
                Moonlight.LOGGER.warn("Failed to load custom map data, skipping");
            }
        }
    }
}

