/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.VillagerAIInternal;
import net.mehvahdjukaar.moonlight.core.mixins.accessor.BrainAccessor;
import net.minecraft.class_1646;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4171;
import net.minecraft.class_4831;

public class VillagerBrainEventInternal {
    private TreeMap<Integer, class_4168> scheduleBuilder = null;
    private final class_4095<class_1646> brain;
    private final class_1646 villager;

    public VillagerBrainEventInternal(class_4095<class_1646> brain, class_1646 villager) {
        this.brain = brain;
        this.villager = villager;
    }

    public class_1646 getVillager() {
        return this.villager;
    }

    public Map<class_4140<?>, Optional<? extends class_4831<?>>> getMemories() {
        return this.brain.method_35058();
    }

    public void addOrReplaceActivity(class_4168 activity, ImmutableList<? extends Pair<Integer, ? extends class_4097<? super class_1646>>> activityPackage) {
        this.brain.method_18881(activity, activityPackage);
    }

    public void scheduleActivity(class_4168 activity, int startTime, int endTime) {
        if (this.scheduleBuilder == null) {
            this.scheduleBuilder = this.makeDefaultSchedule(this.villager);
        }
        TreeMap<Integer, class_4168> newSchedule = new TreeMap<Integer, class_4168>();
        newSchedule.put(startTime, activity);
        class_4168 previousActivity = this.scheduleBuilder.lastEntry().getValue();
        for (Map.Entry<Integer, class_4168> e : this.scheduleBuilder.entrySet()) {
            int key = e.getKey();
            if (key < endTime) {
                previousActivity = e.getValue();
            }
            if (startTime < endTime) {
                if (key >= startTime && key <= endTime) continue;
                newSchedule.put(key, e.getValue());
                continue;
            }
            if (key <= endTime || key >= startTime) continue;
            newSchedule.put(key, e.getValue());
        }
        newSchedule.put(endTime, previousActivity);
        this.scheduleBuilder = newSchedule;
    }

    public void addSensor(class_4149<? extends class_4148<class_1646>> newSensor) {
        try {
            Map sensors = ((BrainAccessor)this.brain).getSensors();
            class_4148 sensorInstance = newSensor.method_19102();
            sensors.put(newSensor, sensorInstance);
            Map memories = this.brain.method_35058();
            for (class_4140 memoryModuleType : sensorInstance.method_19099()) {
                memories.put(memoryModuleType, Optional.empty());
            }
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("failed to register pumpkin sensor type for villagers: " + e);
        }
    }

    public <P extends Pair<Integer, ? extends class_4097<class_1646>>> boolean addTaskToActivity(class_4168 activity, P task) {
        try {
            Map map = ((BrainAccessor)this.brain).getAvailableBehaviorsByPriority();
            Map tasksWithSamePriority = map.computeIfAbsent((Integer)task.getFirst(), m -> Maps.newHashMap());
            Set activityTaskSet = tasksWithSamePriority.computeIfAbsent(activity, a -> Sets.newLinkedHashSet());
            activityTaskSet.add((class_4097)task.getSecond());
            return true;
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("failed to add task for activity {} for villagers: {}", (Object)activity, (Object)e);
            return false;
        }
    }

    private TreeMap<Integer, class_4168> makeDefaultSchedule(class_1646 villager) {
        TreeMap<Integer, class_4168> map = new TreeMap<Integer, class_4168>();
        if (villager.method_6109()) {
            map.put(10, class_4168.field_18595);
            map.put(3000, class_4168.field_18885);
            map.put(6000, class_4168.field_18595);
            map.put(10000, class_4168.field_18885);
            map.put(12000, class_4168.field_18597);
        } else {
            map.put(10, class_4168.field_18595);
            map.put(2000, class_4168.field_18596);
            map.put(9000, class_4168.field_18598);
            map.put(11000, class_4168.field_18595);
            map.put(12000, class_4168.field_18597);
        }
        return map;
    }

    class_4170 buildFinalizedSchedule() {
        class_4171 builder = new class_4171(VillagerAIInternal.CUSTOM_VILLAGER_SCHEDULE.get());
        for (Map.Entry<Integer, class_4168> e : this.scheduleBuilder.entrySet()) {
            builder.method_19221(e.getKey().intValue(), e.getValue());
        }
        return builder.method_19220();
    }

    boolean hasCustomSchedule() {
        return this.scheduleBuilder != null;
    }
}

