/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundSyncConfigsMessage;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_437;
import net.minecraft.server.MinecraftServer;

public abstract class ConfigSpec {
    protected static final Map<String, Map<ConfigType, ConfigSpec>> CONFIG_STORAGE = new ConcurrentHashMap<String, Map<ConfigType, ConfigSpec>>();
    private final String fileName;
    private final String modId;
    private final Path filePath;
    private final ConfigType type;
    private final boolean synced;
    @Nullable
    private final Runnable changeCallback;

    public static void addTrackedSpec(ConfigSpec spec) {
        Map map = CONFIG_STORAGE.computeIfAbsent(spec.getModId(), n -> new HashMap());
        map.put(spec.getConfigType(), spec);
    }

    @Nullable
    public static ConfigSpec getSpec(String modId, ConfigType type) {
        Map<ConfigType, ConfigSpec> map = CONFIG_STORAGE.get(modId);
        if (map != null) {
            return map.getOrDefault((Object)type, null);
        }
        return null;
    }

    protected ConfigSpec(class_2960 name, Path configDirectory, ConfigType type) {
        this(name, configDirectory, type, false, null);
    }

    protected ConfigSpec(class_2960 name, Path configDirectory, ConfigType type, boolean synced, @Nullable Runnable changeCallback) {
        this.fileName = name.method_12836() + "-" + name.method_12832() + ".json";
        this.modId = name.method_12836();
        this.filePath = configDirectory.resolve(this.fileName);
        this.type = type;
        this.synced = synced;
        this.changeCallback = changeCallback;
    }

    protected void onRefresh() {
        if (this.changeCallback != null) {
            this.changeCallback.run();
        }
    }

    public boolean isLoaded() {
        return true;
    }

    public abstract void loadFromFile();

    public abstract void register();

    public ConfigType getConfigType() {
        return this.type;
    }

    public String getModId() {
        return this.modId;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Path getFullPath() {
        return this.filePath;
    }

    public abstract void loadFromBytes(InputStream var1);

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public class_437 makeScreen(class_437 parent) {
        return this.makeScreen(parent, null);
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public abstract class_437 makeScreen(class_437 var1, @Nullable class_2960 var2);

    public abstract boolean hasConfigScreen();

    public void syncConfigsToPlayer(class_3222 player) {
        if (this.getConfigType() == ConfigType.COMMON && this.isSynced()) {
            try {
                byte[] configData = Files.readAllBytes(this.getFullPath());
                ModMessages.CHANNEL.sendToClientPlayer(player, new ClientBoundSyncConfigsMessage(configData, this.getFileName(), this.getModId()));
            }
            catch (IOException e) {
                Moonlight.LOGGER.error("Failed to sync common configs {}", (Object)this.getFileName(), (Object)e);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void sendSyncedConfigsToAllPlayers() {
        if (this.getConfigType() == ConfigType.COMMON && this.isSynced()) {
            MinecraftServer currentServer = PlatformHelper.getCurrentServer();
            if (currentServer != null) {
                class_3324 playerList = currentServer.method_3760();
                for (class_3222 player : playerList.method_14571()) {
                    this.syncConfigsToPlayer(player);
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

