/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.markers.GenericMapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3825;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class SimpleDecorationType
extends MapDecorationType<CustomMapDecoration, GenericMapBlockMarker<CustomMapDecoration>> {
    @Nullable
    private final class_3825 target;
    @Nullable
    private final String name;
    @Nullable
    private final class_2960 structureId;
    private final float rotation;
    public static final Codec<SimpleDecorationType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_3825.field_25012.optionalFieldOf("target_block").forGetter(SimpleDecorationType::getTarget), (App)Codec.STRING.optionalFieldOf("name").forGetter(SimpleDecorationType::getName), (App)Codec.FLOAT.optionalFieldOf("rotation").forGetter(SimpleDecorationType::getRotation), (App)class_2960.field_25139.optionalFieldOf("structure").forGetter(SimpleDecorationType::getStructure)).apply((Applicative)instance, SimpleDecorationType::new));

    public SimpleDecorationType(Optional<class_3825> target) {
        this(target, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public SimpleDecorationType(Optional<class_3825> target, Optional<String> name, Optional<Float> rotation, Optional<class_2960> structure) {
        this.target = target.orElse(null);
        this.name = name.orElse(null);
        this.rotation = rotation.orElse(Float.valueOf(0.0f)).floatValue();
        this.structureId = structure.orElse(null);
    }

    public Optional<class_3825> getTarget() {
        return Optional.ofNullable(this.target);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<Float> getRotation() {
        return Optional.of(Float.valueOf(this.rotation));
    }

    public Optional<class_2960> getStructure() {
        return Optional.ofNullable(this.structureId);
    }

    @Override
    public boolean hasMarker() {
        return this.target != null;
    }

    public class_2960 getId() {
        return Utils.getID(this);
    }

    @Override
    @Nullable
    public CustomMapDecoration loadDecorationFromBuffer(class_2540 buffer) {
        try {
            return new CustomMapDecoration(this, buffer);
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load custom map decoration for decoration type" + this.getId() + ": " + e);
            return null;
        }
    }

    @Override
    @Nullable
    public GenericMapBlockMarker<CustomMapDecoration> loadMarkerFromNBT(class_2487 compound) {
        if (this.hasMarker()) {
            GenericMapBlockMarker<CustomMapDecoration> marker = new GenericMapBlockMarker<CustomMapDecoration>(this);
            try {
                marker.loadFromNBT(compound);
                return marker;
            }
            catch (Exception e) {
                Moonlight.LOGGER.warn("Failed to load world map marker for decoration type" + this.getId() + ": " + e);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public GenericMapBlockMarker<CustomMapDecoration> getWorldMarkerFromWorld(class_1922 reader, class_2338 pos) {
        if (this.target != null && this.target.method_16768(reader.method_8320(pos), class_5819.method_43047())) {
            return new GenericMapBlockMarker<CustomMapDecoration>(this, pos);
        }
        return null;
    }
}

