/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class CustomDecorationType<D extends CustomMapDecoration, M extends MapBlockMarker<D>>
extends MapDecorationType<D, M> {
    public static final Codec<CustomDecorationType<?, ?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("custom").forGetter(MapDecorationType::getCustomFactoryID)).apply((Applicative)instance, c -> MapDecorationRegistry.CODE_TYPES_FACTORIES.get(c).get()));
    protected final Supplier<M> markerFactory;
    protected final BiFunction<class_1922, class_2338, M> markerFromWorldFactory;
    protected final BiFunction<MapDecorationType<?, ?>, class_2540, D> decorationFactory;
    protected final boolean hasMarker;
    private final class_2960 factoryID;

    public CustomDecorationType(class_2960 factoryID, Supplier<M> markerFactory, BiFunction<class_1922, class_2338, M> markerFromWorldFactory, BiFunction<MapDecorationType<?, ?>, class_2540, D> decorationFactory) {
        this.markerFactory = markerFactory;
        this.markerFromWorldFactory = markerFromWorldFactory;
        this.decorationFactory = decorationFactory;
        this.hasMarker = true;
        this.factoryID = factoryID;
    }

    public CustomDecorationType(class_2960 factoryID, BiFunction<MapDecorationType<?, ?>, class_2540, D> decoFromBuffer) {
        this.markerFactory = () -> null;
        this.markerFromWorldFactory = (s, d) -> null;
        this.decorationFactory = decoFromBuffer;
        this.hasMarker = false;
        this.factoryID = factoryID;
    }

    @Override
    public class_2960 getCustomFactoryID() {
        return this.factoryID;
    }

    @Override
    public boolean hasMarker() {
        return this.hasMarker;
    }

    @Override
    @Nullable
    public D loadDecorationFromBuffer(class_2540 buffer) {
        try {
            return (D)((CustomMapDecoration)this.decorationFactory.apply(this, buffer));
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load custom map decoration for decoration type" + this + ": " + e);
            return null;
        }
    }

    @Override
    @Nullable
    public M loadMarkerFromNBT(class_2487 compound) {
        if (this.hasMarker) {
            MapBlockMarker marker = (MapBlockMarker)this.markerFactory.get();
            try {
                marker.loadFromNBT(compound);
                return (M)marker;
            }
            catch (Exception e) {
                Moonlight.LOGGER.warn("Failed to load world map marker for decoration type" + this + ": " + e);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public M getWorldMarkerFromWorld(class_1922 reader, class_2338 pos) {
        return (M)(this.hasMarker ? (MapBlockMarker)this.markerFromWorldFactory.apply(reader, pos) : null);
    }
}

